/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson;

import com.alibaba.fastjson.JSONAware;
import com.alibaba.fastjson.annotation.JSONField;
import com.alibaba.fastjson.annotation.JSONType;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.codec.BeanInfo;
import com.alibaba.fastjson2.codec.FieldInfo;
import com.alibaba.fastjson2.modules.ObjectWriterAnnotationProcessor;
import com.alibaba.fastjson2.modules.ObjectWriterModule;
import com.alibaba.fastjson2.util.BeanUtils;
import com.alibaba.fastjson2.writer.FieldWriter;
import com.alibaba.fastjson2.writer.ObjectWriter;
import com.alibaba.fastjson2.writer.ObjectWriterProvider;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.List;

public class Fastjson1xWriterModule
implements ObjectWriterModule {
    final ObjectWriterProvider provider;
    final WriterAnnotationProcessor annotationProcessor;

    public Fastjson1xWriterModule(ObjectWriterProvider provider) {
        this.provider = provider;
        this.annotationProcessor = new WriterAnnotationProcessor();
    }

    public WriterAnnotationProcessor getAnnotationProcessor() {
        return this.annotationProcessor;
    }

    public ObjectWriter getObjectWriter(Type objectType, Class objectClass) {
        if (objectClass != null && JSONAware.class.isAssignableFrom(objectClass)) {
            return JSONAwareWriter.INSTANCE;
        }
        return null;
    }

    static class JSONAwareWriter
    implements ObjectWriter {
        static final JSONAwareWriter INSTANCE = new JSONAwareWriter();

        JSONAwareWriter() {
        }

        public List<FieldWriter> getFieldWriters() {
            return null;
        }

        public void writeJSONB(JSONWriter jsonWriter, Object object, Object fieldName, Type fieldType, long features) {
            if (object == null) {
                jsonWriter.writeNull();
                return;
            }
            throw new UnsupportedOperationException();
        }

        public void write(JSONWriter jsonWriter, Object object, Object fieldName, Type fieldType, long features) {
            if (object == null) {
                jsonWriter.writeNull();
                return;
            }
            JSONAware jsonAware = (JSONAware)object;
            String str = jsonAware.toJSONString();
            jsonWriter.writeRaw(str);
        }
    }

    class WriterAnnotationProcessor
    implements ObjectWriterAnnotationProcessor {
        WriterAnnotationProcessor() {
        }

        public void getBeanInfo(BeanInfo beanInfo, Class objectClass) {
            JSONType jsonType;
            Class superclass = objectClass.getSuperclass();
            if (superclass != Object.class && superclass != null) {
                this.getBeanInfo(beanInfo, superclass);
            }
            if ((jsonType = objectClass.getAnnotation(JSONType.class)) != null) {
                String typeKey;
                Class<?>[] classes = jsonType.seeAlso();
                if (classes.length != 0) {
                    beanInfo.seeAlso = classes;
                }
                if ((typeKey = jsonType.typeKey()).length() != 0) {
                    beanInfo.typeKey = typeKey;
                }
                block10: for (SerializerFeature feature : jsonType.serialzeFeatures()) {
                    switch (feature) {
                        case WriteMapNullValue: {
                            beanInfo.writerFeatures |= JSONWriter.Feature.WriteNulls.mask;
                            continue block10;
                        }
                        case WriteNullListAsEmpty: 
                        case WriteNullStringAsEmpty: {
                            beanInfo.writerFeatures |= JSONWriter.Feature.NullAsDefaultValue.mask;
                            continue block10;
                        }
                        case BrowserCompatible: {
                            beanInfo.writerFeatures |= JSONWriter.Feature.BrowserCompatible.mask;
                            continue block10;
                        }
                        case WriteClassName: {
                            beanInfo.writerFeatures |= JSONWriter.Feature.WriteClassName.mask;
                            continue block10;
                        }
                        case WriteNonStringValueAsString: {
                            beanInfo.writerFeatures |= JSONWriter.Feature.WriteNonStringValueAsString.mask;
                            continue block10;
                        }
                        case WriteEnumUsingToString: {
                            beanInfo.writerFeatures |= JSONWriter.Feature.WriteEnumUsingToString.mask;
                            continue block10;
                        }
                        case NotWriteRootClassName: {
                            beanInfo.writerFeatures |= JSONWriter.Feature.NotWriteRootClassName.mask;
                            continue block10;
                        }
                        case IgnoreErrorGetter: {
                            beanInfo.writerFeatures |= JSONWriter.Feature.IgnoreErrorGetter.mask;
                            continue block10;
                        }
                    }
                }
                if (jsonType.serializeEnumAsJavaBean()) {
                    beanInfo.writeEnumAsJavaBean = true;
                }
                beanInfo.namingStrategy = jsonType.naming().name();
            }
            if (beanInfo.seeAlso != null && beanInfo.seeAlso.length != 0) {
                for (Class seeAlsoClass : beanInfo.seeAlso) {
                    if (seeAlsoClass != objectClass) continue;
                    beanInfo.typeName = objectClass.getSimpleName();
                }
            }
        }

        public void getFieldInfo(FieldInfo fieldInfo, Class objectType, Field field) {
            Class mixInSource = Fastjson1xWriterModule.this.provider.getMixIn(objectType);
            if (mixInSource != null && mixInSource != objectType) {
                Field mixInField = null;
                try {
                    mixInField = mixInSource.getDeclaredField(field.getName());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (mixInField != null) {
                    this.getFieldInfo(fieldInfo, mixInSource, mixInField);
                }
            }
            this.getFieldInfo(fieldInfo, field.getAnnotation(JSONField.class));
        }

        public void getFieldInfo(FieldInfo fieldInfo, Class objectClass, Method method) {
            int modifiers;
            Class mixInSource = Fastjson1xWriterModule.this.provider.getMixIn(objectClass);
            if (mixInSource != null && mixInSource != objectClass) {
                Method mixInMethod = null;
                try {
                    mixInMethod = mixInSource.getDeclaredMethod(method.getName(), method.getParameterTypes());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (mixInMethod != null) {
                    this.getFieldInfo(fieldInfo, mixInSource, mixInMethod);
                }
            }
            this.getFieldInfo(fieldInfo, method.getAnnotation(JSONField.class));
            String fieldName = BeanUtils.setterName((String)method.getName(), null);
            Field declaredField = null;
            try {
                declaredField = objectClass.getDeclaredField(fieldName);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (declaredField != null && !Modifier.isPublic(modifiers = declaredField.getModifiers()) && !Modifier.isStatic(modifiers)) {
                this.getFieldInfo(fieldInfo, objectClass, declaredField);
            }
        }

        private void getFieldInfo(FieldInfo fieldInfo, JSONField jsonField) {
            String jsonFieldFormat;
            if (jsonField == null) {
                return;
            }
            String jsonFIeldName = jsonField.name();
            if (!jsonFIeldName.isEmpty()) {
                fieldInfo.fieldName = jsonFIeldName;
            }
            if ((jsonFieldFormat = jsonField.format()) != null) {
                jsonFieldFormat = jsonFieldFormat.trim();
            }
            if (!jsonFieldFormat.isEmpty()) {
                if (jsonFieldFormat.indexOf(84) != -1 && !jsonFieldFormat.contains("'T'")) {
                    jsonFieldFormat = jsonFieldFormat.replaceAll("T", "'T'");
                }
                fieldInfo.format = jsonFieldFormat;
            }
            boolean bl = fieldInfo.ignore = !jsonField.serialize();
            if (jsonField.unwrapped()) {
                fieldInfo.format = "unwrapped";
            }
            this.applyFeatures(fieldInfo, jsonField.serialzeFeatures());
            int ordinal = jsonField.ordinal();
            if (ordinal != 0) {
                fieldInfo.ordinal = ordinal;
            }
        }

        private void applyFeatures(FieldInfo fieldInfo, SerializerFeature[] features) {
            block11: for (SerializerFeature feature : features) {
                switch (feature) {
                    case UseISO8601DateFormat: {
                        fieldInfo.format = "iso8601";
                        continue block11;
                    }
                    case WriteMapNullValue: {
                        fieldInfo.features |= JSONWriter.Feature.WriteNulls.mask;
                        continue block11;
                    }
                    case WriteNullListAsEmpty: 
                    case WriteNullStringAsEmpty: {
                        fieldInfo.features |= JSONWriter.Feature.NullAsDefaultValue.mask;
                        continue block11;
                    }
                    case BrowserCompatible: {
                        fieldInfo.features |= JSONWriter.Feature.BrowserCompatible.mask;
                        continue block11;
                    }
                    case WriteClassName: {
                        fieldInfo.features |= JSONWriter.Feature.WriteClassName.mask;
                        continue block11;
                    }
                    case WriteNonStringValueAsString: {
                        fieldInfo.features |= JSONWriter.Feature.WriteNonStringValueAsString.mask;
                        continue block11;
                    }
                    case WriteEnumUsingToString: {
                        fieldInfo.features |= JSONWriter.Feature.WriteEnumUsingToString.mask;
                        continue block11;
                    }
                    case NotWriteRootClassName: {
                        fieldInfo.features |= JSONWriter.Feature.NotWriteRootClassName.mask;
                        continue block11;
                    }
                    case IgnoreErrorGetter: {
                        fieldInfo.features |= JSONWriter.Feature.IgnoreErrorGetter.mask;
                        continue block11;
                    }
                }
            }
        }
    }
}

