/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.simpleimage.analyze.search.tree;

import com.alibaba.simpleimage.analyze.search.cluster.ClusterBuilder;
import com.alibaba.simpleimage.analyze.search.cluster.Clusterable;
import com.alibaba.simpleimage.analyze.search.cluster.impl.Cluster;
import com.alibaba.simpleimage.analyze.search.tree.KMeansTree;
import com.alibaba.simpleimage.analyze.search.util.ClusterUtils;
import com.alibaba.simpleimage.analyze.search.util.TreeUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KMeansTreeNode
implements Clusterable,
Serializable {
    private static final long serialVersionUID = 1L;
    private List<KMeansTreeNode> subNodes;
    private boolean isLeafNode = false;
    private float[] center;
    private int height = 0;
    private int numSubItems;
    private int currentItems;
    private int id = -1;

    public KMeansTreeNode(float[] center, List<Clusterable> items, int branchFactor, int maxHeight, int height, ClusterBuilder clusterBuilder) {
        if (height == maxHeight || items.size() < branchFactor || this.getMeanDist(items, center) < 0.0f) {
            this.isLeafNode = true;
            this.subNodes = new ArrayList<KMeansTreeNode>(0);
            this.id = KMeansTree.idCount++;
        } else {
            Clusterable[] clusters = clusterBuilder.collect(items, branchFactor);
            this.subNodes = new ArrayList<KMeansTreeNode>(branchFactor);
            for (Clusterable cluster : clusters) {
                if (!(cluster instanceof Cluster) || ((Cluster)cluster).getItems().size() <= 0) continue;
                KMeansTreeNode node = new KMeansTreeNode(((Cluster)cluster).getClusterMean(), ((Cluster)cluster).getItems(), branchFactor, maxHeight, height + 1, clusterBuilder);
                this.subNodes.add(node);
            }
        }
        this.height = height;
        this.center = center;
        this.numSubItems = items.size();
    }

    private float getMeanDist(List<Clusterable> items, float[] center) {
        float sum = 0.0f;
        for (Clusterable clusterItem : items) {
            float dist = ClusterUtils.getEuclideanDistance(clusterItem.getLocation(), center);
            sum += dist;
        }
        return sum / (float)items.size();
    }

    public boolean isLeafNode() {
        return this.isLeafNode;
    }

    public List<KMeansTreeNode> getSubNodes() {
        return this.subNodes;
    }

    @Override
    public float[] getLocation() {
        return this.center;
    }

    public int getNumSubItems() {
        return this.numSubItems;
    }

    public int getHeight() {
        return this.height;
    }

    public int getId() {
        return this.id;
    }

    public int addValue(Clusterable c) {
        ++this.currentItems;
        int index = TreeUtils.findNearestNodeIndex(this.subNodes, c);
        if (index >= 0) {
            KMeansTreeNode node = this.subNodes.get(index);
            return node.addValue(c);
        }
        return this.id;
    }

    public int getCurrentItemCount() {
        return this.currentItems;
    }

    public void reset() {
        this.currentItems = 0;
        for (KMeansTreeNode node : this.subNodes) {
            node.reset();
        }
    }

    public String toString() {
        return "KMeansTreeNode [isLeafNode=" + this.isLeafNode + ", center=" + Arrays.toString(this.center) + ", height=" + this.height + ", numSubItems=" + this.numSubItems + ", currentItems=" + this.currentItems + ", id=" + this.id + "]";
    }
}

