/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.simpleimage.codec.jpeg;

import com.alibaba.simpleimage.ImageFormat;
import com.alibaba.simpleimage.ImageWrapper;
import com.alibaba.simpleimage.codec.AbstractImageDecoder;
import com.alibaba.simpleimage.codec.ExtendImageHeaderReader;
import com.alibaba.simpleimage.codec.convertor.ColorConvertor;
import com.alibaba.simpleimage.codec.convertor.FastInverseDCTCalculator;
import com.alibaba.simpleimage.codec.convertor.InverseColorConvertor;
import com.alibaba.simpleimage.codec.convertor.InverseDCTCalculator;
import com.alibaba.simpleimage.codec.convertor.NullColorConvertor;
import com.alibaba.simpleimage.codec.convertor.SlowInverseDCTCalculator;
import com.alibaba.simpleimage.codec.convertor.YCCK2CMYKColorConvertor;
import com.alibaba.simpleimage.codec.convertor.YCbCr2RGBColorConvertor;
import com.alibaba.simpleimage.codec.jpeg.Component;
import com.alibaba.simpleimage.codec.jpeg.FrameHeader;
import com.alibaba.simpleimage.codec.jpeg.HuffmanTable;
import com.alibaba.simpleimage.codec.jpeg.InternalRawImage;
import com.alibaba.simpleimage.codec.jpeg.JPEGColorSpace;
import com.alibaba.simpleimage.codec.jpeg.JPEGDecoderException;
import com.alibaba.simpleimage.codec.jpeg.JPEGMarkerException;
import com.alibaba.simpleimage.codec.jpeg.MarkerConstants;
import com.alibaba.simpleimage.codec.jpeg.QuantizationTable;
import com.alibaba.simpleimage.codec.jpeg.ScanHeader;
import com.alibaba.simpleimage.codec.jpeg.ext.AdobeHeaderReader;
import com.alibaba.simpleimage.codec.jpeg.ext.ExtendImageHeader;
import com.alibaba.simpleimage.codec.jpeg.ext.ICCProfileReader;
import com.alibaba.simpleimage.codec.jpeg.ext.JFIFHeaderReader;
import com.alibaba.simpleimage.io.ImageInputStream;
import com.alibaba.simpleimage.jai.cmm.CMMColorSpace;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.EOFException;
import java.io.IOException;

public class JPEGDecoder
extends AbstractImageDecoder {
    private ImageInputStream in;
    private HuffmanTable[] dcHuffTables = new HuffmanTable[4];
    private HuffmanTable[] acHuffTables = new HuffmanTable[4];
    private QuantizationTable[] qTables = new QuantizationTable[4];
    private FrameHeader frameHeader;
    private ScanHeader scanHeader;
    private int restartInterval;
    private ExtendImageHeader extendImageHeader = new ExtendImageHeader();
    private InverseDCTCalculator inverseDCTCalculator;
    private ColorConvertor colorConvertor;
    private InternalRawImage rawImage;
    private int[][] singleMCUData = new int[4][];
    private int[] singleBlockData = new int[64];
    private int[] pixesBuffer = null;
    private int x = 0;
    private int y = 0;
    private int[][][] allMCUDatas;
    private int MCUsPerRow;
    private int MCUsPerColumn;
    private int maxHSampleFactor = 0;
    private int maxVSampleFactor = 0;
    private int[] blocksInMCU = new int[10];
    private int blocksNumInMCU = 0;
    private int[] preDC;
    private int EOBRUN = 0;
    private boolean fastIDCTMode = false;
    private boolean supportICC = false;
    private boolean broken = false;

    public JPEGDecoder(ImageInputStream in, boolean fastIDCTMode, boolean supportICC) {
        this.in = in;
        this.fastIDCTMode = fastIDCTMode;
        this.supportICC = supportICC;
        super.addExtendHeaderReader(224, new JFIFHeaderReader());
        if (supportICC) {
            super.addExtendHeaderReader(226, new ICCProfileReader());
        }
        super.addExtendHeaderReader(238, new AdobeHeaderReader());
        this.inverseDCTCalculator = fastIDCTMode ? new FastInverseDCTCalculator() : new SlowInverseDCTCalculator();
    }

    public JPEGDecoder(ImageInputStream in) {
        this(in, false, false);
    }

    public ImageWrapper decode() throws IOException {
        int prefix = this.in.read();
        int magic = this.in.read();
        if (prefix != 255 || magic != 216) {
            throw new IllegalArgumentException("Not JPEG file");
        }
        int marker = this.nextMarker();
        try {
            while (!this.isSOFnMarker(marker)) {
                this.readTables(marker);
                marker = this.nextMarker();
                if (marker != -1) continue;
                throw new IOException("Unexpected end of file");
            }
        }
        catch (JPEGMarkerException e) {
            throw new JPEGDecoderException("Decode JPEG fail");
        }
        marker = this.decodeFrame(marker);
        if (marker == -1 || marker == 217) {
            if (this.rawImage == null) {
                throw new JPEGDecoderException("Decode JPEG fail");
            }
            if (marker == -1) {
                this.broken = true;
            }
            return this.createImage();
        }
        throw new JPEGDecoderException("Decode JPEG fail");
    }

    protected ImageWrapper createImage() {
        WritableRaster dstRaster = null;
        ColorSpace cs = null;
        if (this.frameHeader.isProgressiveMode()) {
            this.inverseDCT();
            this.writeFull();
        }
        if (this.rawImage.getColorspace() == JPEGColorSpace.Gray) {
            dstRaster = Raster.createInterleavedRaster(new DataBufferByte(this.rawImage.getData(), this.rawImage.getData().length), this.rawImage.getWidth(), this.rawImage.getHeight(), this.rawImage.getWidth() * 1, 1, new int[]{0}, null);
            cs = this.getColorSpace();
        } else if (this.rawImage.getColorspace() == JPEGColorSpace.RGB) {
            dstRaster = Raster.createInterleavedRaster(new DataBufferByte(this.rawImage.getData(), this.rawImage.getData().length), this.rawImage.getWidth(), this.rawImage.getHeight(), this.rawImage.getWidth() * 3, 3, new int[]{0, 1, 2}, null);
            cs = this.getColorSpace();
        } else if (this.rawImage.getColorspace() == JPEGColorSpace.CMYK) {
            dstRaster = Raster.createInterleavedRaster(new DataBufferByte(this.rawImage.getData(), this.rawImage.getData().length), this.rawImage.getWidth(), this.rawImage.getHeight(), this.rawImage.getWidth() * 4, 4, new int[]{0, 1, 2, 3}, null);
            cs = this.getColorSpace();
        } else {
            throw new JPEGDecoderException("Unknow colorspace");
        }
        ComponentColorModel cm = new ComponentColorModel(cs, false, true, 1, 0);
        BufferedImage img = new BufferedImage(cm, dstRaster, true, null);
        ImageWrapper wi = new ImageWrapper(img, this.getQuality(), this.broken);
        wi.setImageFormat(ImageFormat.JPEG);
        for (Component c : this.frameHeader.getComponents()) {
            wi.setHorizontalSamplingFactor(c.getIndex(), c.getH());
            wi.setVerticalSamplingFactor(c.getIndex(), c.getV());
        }
        return wi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected ColorSpace getColorSpace() {
        ColorSpace cs = null;
        if (this.supportICC && this.extendImageHeader.isExistProfile()) {
            ICC_Profile profile = null;
            try {
                Class<ICC_Profile> clazz = ICC_Profile.class;
                // MONITORENTER : java.awt.color.ICC_Profile.class
                profile = ICC_Profile.getInstance(this.extendImageHeader.getProfileData());
                // MONITOREXIT : clazz
            }
            catch (Exception ignore) {
                profile = null;
            }
            if (profile != null) {
                try {
                    cs = new ICC_ColorSpace(profile);
                }
                catch (Exception ignore) {
                    cs = null;
                }
            }
        }
        if (cs != null) return cs;
        this.extendImageHeader.setExistProfile(false);
        if (this.rawImage.getColorspace() == JPEGColorSpace.CMYK) {
            return CMMColorSpace.getInstance(9);
        }
        if (this.rawImage.getColorspace() != JPEGColorSpace.RGB) return ColorSpace.getInstance(1003);
        return ColorSpace.getInstance(1000);
    }

    protected int decodeFrame(int marker) throws IOException {
        this.readFrameHeader(marker);
        this.determinColorspace();
        marker = this.nextMarker();
        int scanNum = 0;
        do {
            if ((marker = this.frameHeader.isProgressiveMode() ? this.decodeProgressiveScan(marker) : this.decodeScan(marker)) != 220 || ++scanNum != 1) continue;
            this.decodeDNL();
        } while (marker != 217 && marker != -1);
        return marker;
    }

    protected void calculateMCUs(int[] componentIndexes, Component[] components) {
        this.blocksNumInMCU = 0;
        for (int i : componentIndexes) {
            int blocks = components[i].getH() * components[i].getV();
            while (blocks-- > 0) {
                this.blocksInMCU[this.blocksNumInMCU++] = i;
            }
        }
    }

    protected int decodeScan(int marker) throws IOException {
        try {
            while (marker != 218) {
                this.readTables(marker);
                marker = this.nextMarker();
                if (marker != -1) continue;
                return marker;
            }
        }
        catch (JPEGMarkerException e) {
            return -1;
        }
        int[] componentIndexes = this.readScanHeader();
        Component[] components = this.frameHeader.getComponents();
        this.calculateMCUs(componentIndexes, components);
        try {
            int restartsLeft = this.restartInterval;
            this.in.resetBuffer();
            this.resetDecoder();
            for (int m = 0; m < this.MCUsPerColumn * this.MCUsPerRow; ++m) {
                if (this.restartInterval > 0 && restartsLeft == 0) {
                    marker = this.nextMarker();
                    if (marker > 215 || marker < 208) {
                        return marker;
                    }
                    this.in.resetBuffer();
                    this.resetDecoder();
                    restartsLeft = this.restartInterval;
                }
                int index = 0;
                int ctr = 0;
                for (int c = 0; c < this.blocksNumInMCU; ++c) {
                    index = this.blocksInMCU[c];
                    ctr = c == 0 ? 0 : (index == this.blocksInMCU[c - 1] ? ++ctr : 0);
                    HuffmanTable curACTable = components[index].acHuffTable;
                    HuffmanTable curDCTable = components[index].dcHuffTable;
                    QuantizationTable curQTable = components[index].qTable;
                    for (int z = 0; z < 64; ++z) {
                        this.singleBlockData[z] = 0;
                    }
                    int s = 0;
                    int r = 0;
                    s = curDCTable.decode(this.in);
                    if (s > 0) {
                        r = (int)this.in.readBits(s);
                        s = curDCTable.extend(r, s);
                    }
                    this.preDC[index] = s = this.preDC[index] + s;
                    this.singleBlockData[0] = s;
                    int k = 1;
                    while (true) {
                        s = curACTable.decode(this.in);
                        r = s >> 4;
                        if ((s &= 0xF) == 0) {
                            if (r != 15) break;
                            k += 16;
                            continue;
                        }
                        k += r;
                        r = (int)this.in.readBits(s);
                        this.singleBlockData[MarkerConstants.BLOCK_NATURAL_ORDER[k]] = s = curACTable.extend(r, s);
                        if (k >= 63) break;
                        ++k;
                    }
                    if (this.fastIDCTMode) {
                        throw new UnsupportedOperationException("Not implemented yet");
                    }
                    this.inverseDCTCalculator.calculate(this.singleBlockData, 0, curQTable.getQ(), this.singleMCUData[index], ctr * 64, components[index].getHorizonDCTScaledSize(), components[index].getVerticaDCTScaledSize());
                }
                this.writeMCU();
                --restartsLeft;
            }
            marker = this.nextMarker();
        }
        catch (JPEGMarkerException e) {
            marker = e.getMarker();
        }
        catch (EOFException e) {
            marker = -1;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            marker = -1;
            this.broken = true;
        }
        return marker;
    }

    protected int decodeProgressiveScan(int marker) throws IOException {
        try {
            while (marker != 218) {
                this.readTables(marker);
                marker = this.nextMarker();
                if (marker != -1) continue;
                return marker;
            }
        }
        catch (JPEGMarkerException e) {
            return -1;
        }
        int[] componentIndexes = this.readScanHeader();
        this.validateProgressiveParam();
        Component[] components = this.frameHeader.getComponents();
        this.calculateMCUs(componentIndexes, components);
        try {
            int restartsLeft = this.restartInterval;
            this.in.resetBuffer();
            this.resetDecoder();
            if (this.scanHeader.getSs() == 0) {
                for (int m = 0; m < this.MCUsPerColumn * this.MCUsPerRow; ++m) {
                    if (this.restartInterval > 0 && restartsLeft == 0) {
                        marker = this.nextMarker();
                        if (marker > 215 || marker < 208) {
                            return marker;
                        }
                        this.in.resetBuffer();
                        this.resetDecoder();
                        restartsLeft = this.restartInterval;
                    }
                    int index = 0;
                    int blkIndex = 0;
                    for (int c = 0; c < this.blocksNumInMCU; ++c) {
                        index = this.blocksInMCU[c];
                        blkIndex = c == 0 ? 0 : (index == this.blocksInMCU[c - 1] ? ++blkIndex : 0);
                        HuffmanTable curDCTable = components[index].dcHuffTable;
                        if (this.scanHeader.getAh() == 0) {
                            this.decodeDCFirst(index, curDCTable, this.scanHeader.getAl(), this.allMCUDatas[index][m], blkIndex);
                            continue;
                        }
                        this.decodeDCRefine(this.scanHeader.getAl(), this.allMCUDatas[index][m], blkIndex);
                    }
                    --restartsLeft;
                }
            } else {
                int componentH = components[componentIndexes[0]].getH();
                int componentV = components[componentIndexes[0]].getV();
                int blksInVertica = componentV == 1 ? this.MCUsPerColumn : (this.frameHeader.getY() + 7) / 8;
                int blksInHorizon = componentH == 1 ? this.MCUsPerRow : (this.frameHeader.getX() + 7) / 8;
                int MCUIndex = 0;
                int blkIndex = 0;
                int secondBlkIndex = componentH == 1 ? 1 : 2;
                HuffmanTable curACTable = components[componentIndexes[0]].acHuffTable;
                for (int v = 0; v < blksInVertica; ++v) {
                    MCUIndex = v / componentV * this.MCUsPerRow - 1;
                    for (int h = 0; h < blksInHorizon; ++h) {
                        if (h % componentH == 0) {
                            ++MCUIndex;
                            blkIndex = 0;
                            if (v % componentV != 0) {
                                blkIndex = secondBlkIndex;
                            }
                        }
                        if (this.restartInterval > 0 && restartsLeft == 0) {
                            marker = this.nextMarker();
                            if (marker > 215 || marker < 208) {
                                return marker;
                            }
                            this.in.resetBuffer();
                            this.resetDecoder();
                            restartsLeft = this.restartInterval;
                        }
                        if (this.scanHeader.getAh() == 0) {
                            this.decodeACFirst(curACTable, this.scanHeader.getSs(), this.scanHeader.getSe(), this.scanHeader.getAl(), this.allMCUDatas[componentIndexes[0]][MCUIndex], blkIndex);
                        } else {
                            this.decodeACRefine(curACTable, this.scanHeader.getSs(), this.scanHeader.getSe(), this.scanHeader.getAl(), this.allMCUDatas[componentIndexes[0]][MCUIndex], blkIndex);
                        }
                        ++blkIndex;
                        --restartsLeft;
                    }
                }
            }
            marker = this.nextMarker();
        }
        catch (JPEGMarkerException e) {
            marker = e.getMarker();
        }
        catch (EOFException e) {
            marker = -1;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            marker = -1;
            this.broken = true;
        }
        return marker;
    }

    protected void validateProgressiveParam() {
        if (this.scanHeader.getSs() == 0) {
            if (this.scanHeader.getSe() != 0) {
                throw new IllegalArgumentException("Invalid progressive parameters");
            }
        } else {
            if (this.scanHeader.getSe() < this.scanHeader.getSs() || this.scanHeader.getSe() > 63) {
                throw new IllegalArgumentException("Invalid progressive parameters");
            }
            if (this.scanHeader.getNs() != 1) {
                throw new IllegalArgumentException("Invalid progressive parameters");
            }
        }
        if (this.scanHeader.getAh() != 0 && this.scanHeader.getAh() - 1 != this.scanHeader.getAl()) {
            throw new IllegalArgumentException("Invalid progressive parameters");
        }
        if (this.scanHeader.getAl() > 13) {
            throw new IllegalArgumentException("Invalid progressive parameters");
        }
    }

    protected boolean isSOFnMarker(int marker) {
        if (marker <= 195 && marker >= 192) {
            return true;
        }
        if (marker <= 203 && marker >= 197) {
            return true;
        }
        return marker <= 207 && marker >= 205;
    }

    protected void readTables(int marker) throws IOException, JPEGMarkerException {
        switch (marker) {
            case 224: 
            case 225: 
            case 226: 
            case 227: 
            case 228: 
            case 229: 
            case 230: 
            case 231: 
            case 232: 
            case 233: 
            case 234: 
            case 235: 
            case 236: 
            case 237: 
            case 238: 
            case 239: {
                this.decodeExtendMarker(marker);
                break;
            }
            case 204: {
                this.decodeDAC();
                break;
            }
            case 196: {
                this.decodeHuffmanTable();
                break;
            }
            case 219: {
                this.decodeQuantizationTable();
                break;
            }
            case 221: {
                this.decodeDRI();
                break;
            }
            case 254: {
                this.decodeExtendMarker(254);
                break;
            }
            case 220: {
                this.decodeDNL();
                break;
            }
            default: {
                throw new JPEGMarkerException(marker);
            }
        }
    }

    protected void decodeDNL() throws IOException {
        this.in.readShort();
        this.in.readUnsignedShort();
    }

    protected void decodeDRI() throws IOException {
        int length = this.in.readUnsignedShort();
        if (length != 4) {
            throw new JPEGDecoderException("Bogus marker length");
        }
        this.restartInterval = this.in.readUnsignedShort();
    }

    protected void decodeHuffmanTable() throws IOException {
        int length = this.in.readUnsignedShort();
        length -= 2;
        while (length > 0) {
            int i;
            int index = this.in.read();
            int count = 0;
            int[] bits = new int[17];
            for (i = 1; i <= 16; ++i) {
                bits[i] = this.in.read();
                count += bits[i];
            }
            if (count > 256 || count > (length -= 17)) {
                throw new JPEGDecoderException("Bogus Huffman table definition");
            }
            int[] huffval = new int[256];
            for (i = 0; i < count; ++i) {
                huffval[i] = this.in.read();
            }
            length -= count;
            if (index >> 4 == 1) {
                this.acHuffTables[index -= 16] = new HuffmanTable(1, index, bits, huffval);
            } else {
                this.dcHuffTables[index] = new HuffmanTable(0, index, bits, huffval);
            }
            if (index >= 0 && index < 4) continue;
            throw new JPEGDecoderException("Bogus DHT index " + index);
        }
        if (length != 0) {
            throw new JPEGDecoderException("Bogus marker length");
        }
    }

    protected void decodeQuantizationTable() throws IOException {
        int count = 0;
        int length = this.in.readUnsignedShort();
        length -= 2;
        while (length > 0) {
            QuantizationTable qTable;
            int i;
            int prec = 0;
            int n = 0;
            n = this.in.read();
            --length;
            prec = n >> 4;
            if ((n &= 0xF) >= 4) {
                throw new JPEGDecoderException("Unsupport quantization table more than 4 ");
            }
            int[] Q = new int[64];
            if (prec > 0) {
                if (length < 128) {
                    for (i = 0; i < 64; ++i) {
                        Q[i] = 1;
                    }
                    count = length >> 1;
                } else {
                    count = 64;
                }
            } else if (length < 64) {
                for (int i2 = 0; i2 < 64; ++i2) {
                    Q[i2] = 1;
                }
                count = length;
            } else {
                count = 64;
            }
            for (i = 0; i < count; ++i) {
                Q[MarkerConstants.BLOCK_NATURAL_ORDER[i]] = prec > 0 ? this.in.readUnsignedShort() : this.in.read();
            }
            if (this.fastIDCTMode) {
                int half = 2048;
                for (int i3 = 0; i3 < 64; ++i3) {
                    Q[i3] = Q[i3] * MarkerConstants.AAN_SCALES[i3] + half >> 12;
                }
            }
            this.qTables[n] = qTable = new QuantizationTable(Q);
            length -= count;
            if (prec <= 0) continue;
            length -= count;
        }
        if (length != 0) {
            throw new JPEGDecoderException("Bogus marker length");
        }
    }

    protected void decodeDAC() throws IOException {
        throw new UnsupportedOperationException("Not implement yet");
    }

    protected void decodeExtendMarker(int marker) throws IOException {
        int length = this.in.readUnsignedShort();
        length -= 2;
        ExtendImageHeaderReader reader = (ExtendImageHeaderReader)this.extendImageHeaderReaders.get(marker);
        if (reader != null) {
            reader.readProperties(this.in, length, this.extendImageHeader);
        } else if (length > 0) {
            this.in.skipBytes(length);
        }
    }

    protected void determinColorspace() {
        switch (this.frameHeader.getNf()) {
            case 1: {
                this.rawImage.setRawColorspace(JPEGColorSpace.Gray);
                this.rawImage.setColorspace(JPEGColorSpace.Gray);
                this.colorConvertor = new NullColorConvertor();
                break;
            }
            case 3: {
                if (this.extendImageHeader.isSawJFIFMarker()) {
                    this.rawImage.setRawColorspace(JPEGColorSpace.YCbCr);
                    this.colorConvertor = new YCbCr2RGBColorConvertor();
                } else if (this.extendImageHeader.isSawAdobeMarker()) {
                    switch (this.extendImageHeader.getAdobeTransform()) {
                        case 0: {
                            this.rawImage.setRawColorspace(JPEGColorSpace.RGB);
                            this.colorConvertor = new NullColorConvertor();
                            break;
                        }
                        case 1: {
                            this.rawImage.setRawColorspace(JPEGColorSpace.YCbCr);
                            this.colorConvertor = new YCbCr2RGBColorConvertor();
                            break;
                        }
                        default: {
                            this.rawImage.setRawColorspace(JPEGColorSpace.YCbCr);
                            this.colorConvertor = new YCbCr2RGBColorConvertor();
                            break;
                        }
                    }
                } else {
                    int cid0 = this.frameHeader.getComponents()[0].getC();
                    int cid1 = this.frameHeader.getComponents()[1].getC();
                    int cid2 = this.frameHeader.getComponents()[2].getC();
                    if (cid0 == 1 && cid1 == 2 && cid2 == 3) {
                        this.rawImage.setRawColorspace(JPEGColorSpace.YCbCr);
                        this.colorConvertor = new YCbCr2RGBColorConvertor();
                    } else if (cid0 == 82 && cid1 == 71 && cid2 == 66) {
                        this.rawImage.setRawColorspace(JPEGColorSpace.RGB);
                        this.colorConvertor = new NullColorConvertor();
                    } else {
                        this.rawImage.setRawColorspace(JPEGColorSpace.YCbCr);
                        this.colorConvertor = new YCbCr2RGBColorConvertor();
                    }
                }
                this.rawImage.setColorspace(JPEGColorSpace.RGB);
                break;
            }
            case 4: {
                if (this.extendImageHeader.isSawAdobeMarker()) {
                    switch (this.extendImageHeader.getAdobeTransform()) {
                        case 0: {
                            this.rawImage.setRawColorspace(JPEGColorSpace.CMYK);
                            this.colorConvertor = new InverseColorConvertor();
                            break;
                        }
                        case 2: {
                            this.rawImage.setRawColorspace(JPEGColorSpace.YCCK);
                            this.colorConvertor = new YCCK2CMYKColorConvertor();
                            break;
                        }
                        default: {
                            this.rawImage.setRawColorspace(JPEGColorSpace.YCCK);
                            this.colorConvertor = new YCCK2CMYKColorConvertor();
                            break;
                        }
                    }
                } else {
                    this.rawImage.setRawColorspace(JPEGColorSpace.CMYK);
                    this.colorConvertor = new InverseColorConvertor();
                }
                this.rawImage.setColorspace(JPEGColorSpace.CMYK);
                break;
            }
            default: {
                this.rawImage.setRawColorspace(JPEGColorSpace.UNKNOWN);
                this.rawImage.setColorspace(JPEGColorSpace.UNKNOWN);
                this.colorConvertor = new NullColorConvertor();
            }
        }
    }

    protected void readFrameHeader(int marker) throws IOException {
        switch (marker) {
            case 192: {
                this.createFrameHeader(true, false);
                break;
            }
            case 193: {
                this.createFrameHeader(false, false);
                break;
            }
            case 194: {
                this.createFrameHeader(false, true);
                break;
            }
            default: {
                throw new JPEGDecoderException("Unsupported SOFn types " + marker);
            }
        }
    }

    protected void createFrameHeader(boolean baseline, boolean progressive) throws IOException {
        int i;
        if (this.frameHeader != null) {
            throw new JPEGDecoderException("Duplicate SOFn marker");
        }
        int length = this.in.readUnsignedShort();
        this.frameHeader = new FrameHeader(baseline, progressive);
        this.frameHeader.setLF(length);
        this.frameHeader.setP(this.in.read());
        this.frameHeader.setY(this.in.readUnsignedShort());
        this.frameHeader.setX(this.in.readUnsignedShort());
        this.frameHeader.setNf(this.in.read());
        length -= 8;
        if (this.frameHeader.getX() <= 0 || this.frameHeader.getY() <= 0 || this.frameHeader.getNf() <= 0) {
            throw new JPEGDecoderException("Illegal JPEG frame width or height or components");
        }
        if (length != this.frameHeader.getNf() * 3) {
            throw new JPEGDecoderException("Illegal JPEG frame length");
        }
        this.frameHeader.setComponents(new Component[this.frameHeader.getNf()]);
        for (i = 0; i < this.frameHeader.getNf(); ++i) {
            Component com = new Component();
            com.setIndex(i);
            com.setC(this.in.read());
            int factor = this.in.read();
            com.setH(factor >> 4 & 0xF);
            com.setV(factor & 0xF);
            com.setTq(this.in.read());
            this.frameHeader.getComponents()[i] = com;
            if (com.getH() > this.maxHSampleFactor) {
                this.maxHSampleFactor = com.getH();
            }
            if (com.getV() <= this.maxVSampleFactor) continue;
            this.maxVSampleFactor = com.getV();
        }
        for (i = 0; i < this.frameHeader.getNf(); ++i) {
            Component comp = this.frameHeader.getComponents()[i];
            int st = this.maxHSampleFactor * this.maxVSampleFactor / (comp.getH() * comp.getV());
            comp.setSampleTimes(st);
            if (comp.getH() != this.maxHSampleFactor) {
                comp.setHorizonDCTScaledSize(this.maxHSampleFactor * 8);
            } else {
                comp.setHorizonDCTScaledSize(8);
            }
            if (comp.getV() != this.maxVSampleFactor) {
                comp.setVerticaDCTScaledSize(this.maxVSampleFactor * 8);
                continue;
            }
            comp.setVerticaDCTScaledSize(8);
        }
        if (this.rawImage == null) {
            this.rawImage = new InternalRawImage();
        }
        this.rawImage.setHeight(this.frameHeader.getY());
        this.rawImage.setWidth(this.frameHeader.getX());
        this.rawImage.setNumOfComponents(this.frameHeader.getNf());
        this.rawImage.initData();
        this.preDC = new int[this.frameHeader.getNf()];
        this.MCUsPerRow = ((this.frameHeader.getX() + 7) / 8 + (this.maxHSampleFactor - 1)) / this.maxHSampleFactor;
        this.MCUsPerColumn = ((this.frameHeader.getY() + 7) / 8 + (this.maxVSampleFactor - 1)) / this.maxVSampleFactor;
        if (progressive) {
            int MCUs = this.MCUsPerRow * this.MCUsPerColumn;
            this.allMCUDatas = new int[4][][];
            this.allMCUDatas[0] = new int[MCUs][64 * this.maxVSampleFactor * this.maxHSampleFactor];
            if (this.frameHeader.getNf() > 1) {
                this.allMCUDatas[1] = new int[MCUs][64 * this.maxVSampleFactor * this.maxHSampleFactor];
                this.allMCUDatas[2] = new int[MCUs][64 * this.maxVSampleFactor * this.maxHSampleFactor];
            }
            if (this.frameHeader.getNf() > 3) {
                this.allMCUDatas[3] = new int[MCUs][64 * this.maxVSampleFactor * this.maxHSampleFactor];
            }
        } else {
            this.singleMCUData[0] = new int[64 * this.maxVSampleFactor * this.maxHSampleFactor];
            if (this.frameHeader.getNf() > 1) {
                this.singleMCUData[1] = new int[64 * this.maxVSampleFactor * this.maxHSampleFactor];
                this.singleMCUData[2] = new int[64 * this.maxVSampleFactor * this.maxHSampleFactor];
            }
            if (this.frameHeader.getNf() > 3) {
                this.singleMCUData[3] = new int[64 * this.maxVSampleFactor * this.maxHSampleFactor];
            }
        }
    }

    protected void inverseDCT() {
        int numOfComponents = this.frameHeader.getNf();
        Component[] components = this.frameHeader.getComponents();
        int[] codeBlocks = new int[64 * this.maxHSampleFactor * this.maxVSampleFactor];
        for (int m = 0; m < this.MCUsPerColumn * this.MCUsPerRow; ++m) {
            for (int c = 0; c < numOfComponents; ++c) {
                int blkNum = components[c].getH() * components[c].getV();
                for (int i = 0; i < blkNum * 64; ++i) {
                    codeBlocks[i] = this.allMCUDatas[c][m][i];
                }
                for (int b = 0; b < blkNum; ++b) {
                    this.inverseDCTCalculator.calculate(codeBlocks, b * 64, components[c].qTable.getQ(), this.allMCUDatas[c][m], b * 64, components[c].getHorizonDCTScaledSize(), components[c].getVerticaDCTScaledSize());
                }
            }
        }
    }

    protected void writeFull() {
        byte[] imageData = this.rawImage.getData();
        int numOfComponents = this.frameHeader.getNf();
        int[] pixes = new int[numOfComponents * 64];
        int blockIndex = 0;
        int startCoordinate = 0;
        int scanlineStride = numOfComponents * this.rawImage.getWidth();
        int row = 0;
        this.x = 0;
        this.y = 0;
        for (int m = 0; m < this.MCUsPerColumn * this.MCUsPerRow; ++m) {
            blockIndex = 0;
            for (int v = 0; v < this.maxVSampleFactor; ++v) {
                for (int h = 0; h < this.maxHSampleFactor; ++h) {
                    row = this.y + 1;
                    startCoordinate = (this.y * this.rawImage.getWidth() + this.x) * numOfComponents;
                    int i = 0;
                    for (int k = blockIndex * 64; k < blockIndex * 64 + 64; ++k) {
                        pixes[i++] = this.allMCUDatas[0][m][k];
                        if (numOfComponents > 1) {
                            pixes[i++] = this.allMCUDatas[1][m][k];
                            pixes[i++] = this.allMCUDatas[2][m][k];
                        }
                        if (numOfComponents > 3) {
                            pixes[i++] = this.allMCUDatas[3][m][k];
                        }
                        ++this.x;
                        if (this.x % 8 != 0) continue;
                        ++this.y;
                        this.x -= 8;
                    }
                    this.colorConvertor.convertBlock(pixes, 0, imageData, numOfComponents, startCoordinate, row, scanlineStride);
                    ++blockIndex;
                    this.x += 8;
                    this.y -= 8;
                }
                this.x -= this.maxHSampleFactor * 8;
                this.y += 8;
            }
            this.x += this.maxHSampleFactor * 8;
            this.y -= this.maxVSampleFactor * 8;
            if (this.x < this.rawImage.getWidth()) continue;
            this.x = 0;
            this.y += this.maxVSampleFactor * 8;
        }
    }

    protected void writeMCU() {
        byte[] imageData = this.rawImage.getData();
        int numOfComponents = this.frameHeader.getNf();
        int blockIndex = 0;
        int startCoordinate = 0;
        int row = 0;
        int scanlineStride = numOfComponents * this.rawImage.getWidth();
        if (this.pixesBuffer == null) {
            this.pixesBuffer = new int[numOfComponents * 64];
        }
        for (int v = 0; v < this.maxVSampleFactor; ++v) {
            for (int h = 0; h < this.maxHSampleFactor; ++h) {
                row = this.y + 1;
                startCoordinate = (this.y * this.rawImage.getWidth() + this.x) * numOfComponents;
                int i = 0;
                for (int k = blockIndex * 64; k < blockIndex * 64 + 64; ++k) {
                    this.pixesBuffer[i++] = this.singleMCUData[0][k];
                    if (numOfComponents > 1) {
                        this.pixesBuffer[i++] = this.singleMCUData[1][k];
                        this.pixesBuffer[i++] = this.singleMCUData[2][k];
                    }
                    if (numOfComponents > 3) {
                        this.pixesBuffer[i++] = this.singleMCUData[3][k];
                    }
                    ++this.x;
                    if (this.x % 8 != 0) continue;
                    ++this.y;
                    this.x -= 8;
                }
                this.colorConvertor.convertBlock(this.pixesBuffer, 0, imageData, numOfComponents, startCoordinate, row, scanlineStride);
                ++blockIndex;
                this.x += 8;
                this.y -= 8;
            }
            this.x -= this.maxHSampleFactor * 8;
            this.y += 8;
        }
        this.x += this.maxHSampleFactor * 8;
        this.y -= this.maxVSampleFactor * 8;
        if (this.x >= this.rawImage.getWidth()) {
            this.x = 0;
            this.y += this.maxVSampleFactor * 8;
        }
    }

    protected void resetDecoder() {
        for (int i = 0; i < this.frameHeader.getNf(); ++i) {
            this.preDC[i] = 0;
        }
        this.EOBRUN = 0;
    }

    protected int nextMarker() throws IOException {
        int c;
        do {
            c = this.in.read();
            while (c != 255 && c != -1) {
                c = this.in.read();
            }
            while ((c = this.in.read()) == 255) {
            }
            if (c == 0) continue;
            return c;
        } while (c != -1);
        return -1;
    }

    protected int[] readScanHeader() throws IOException {
        this.scanHeader = new ScanHeader();
        int length = this.in.readUnsignedShort();
        this.scanHeader.setLs(length);
        length -= 2;
        this.scanHeader.setNs(this.in.read());
        --length;
        int[] componentsInScan = new int[this.scanHeader.getNs()];
        int Cs = 0;
        int Ta = 0;
        int Td = 0;
        for (int i = 0; i < this.scanHeader.getNs(); ++i) {
            Cs = this.in.read();
            --length;
            int temp = this.in.read();
            --length;
            Td = temp >> 4;
            Ta = temp & 0xF;
            Component component = this.frameHeader.getComponentByID(Cs);
            component.setDcHuffTable(this.dcHuffTables[Td]);
            component.setAcHuffTable(this.acHuffTables[Ta]);
            component.setQTable(this.qTables[component.getTq()]);
            componentsInScan[i] = component.getIndex();
        }
        this.scanHeader.setSs(this.in.read());
        --length;
        this.scanHeader.setSe(this.in.read());
        --length;
        int temp = this.in.read();
        this.scanHeader.setAh(temp >> 4 & 0xF);
        this.scanHeader.setAl(temp & 0xF);
        if (--length != 0) {
            throw new JPEGDecoderException("Bugos scan header length");
        }
        return componentsInScan;
    }

    public int getQuality() {
        int quality;
        block4: {
            int i;
            int sum;
            block5: {
                sum = 0;
                quality = 0;
                for (i = 0; i < this.qTables.length; ++i) {
                    if (this.qTables[i] == null) continue;
                    int[] tempQ = this.qTables[i].getQ();
                    for (int j = 0; j < 64; ++j) {
                        sum += tempQ[j];
                    }
                }
                if (this.qTables[0] == null || this.qTables[1] == null) break block5;
                int qvalue = this.qTables[0].getQ()[2] + this.qTables[0].getQ()[53] + this.qTables[1].getQ()[0] + this.qTables[1].getQ()[63];
                for (i = 0; i < 100; ++i) {
                    if (qvalue < DOUBLE_QUANT_HASH[i] && sum < DOUBLE_QUANT_SUMS[i]) continue;
                    if ((qvalue > DOUBLE_QUANT_HASH[i] || sum > DOUBLE_QUANT_SUMS[i]) && i < 50) break block4;
                    quality = i + 1;
                    break block4;
                }
                break block4;
            }
            if (this.qTables[0] == null) break block4;
            int qvalue = this.qTables[0].getQ()[2] + this.qTables[0].getQ()[53];
            for (i = 0; i < 100; ++i) {
                if (qvalue < SINGLE_QUANT_HASH[i] && sum < SINGLE_QUANT_SUMS[i]) continue;
                if ((qvalue > SINGLE_QUANT_HASH[i] || sum > SINGLE_QUANT_SUMS[i]) && i < 50) break;
                quality = i + 1;
                break;
            }
        }
        return quality;
    }

    protected int decodeACRefine(HuffmanTable huffTable, int Ss, int Se, int Al, int[] mcu, int blkIndex) throws IOException, JPEGMarkerException {
        int k;
        int p1 = 1 << Al;
        int m1 = -1 << Al;
        int s = 0;
        int r = 0;
        int coef = 0;
        int offset = blkIndex * 64;
        if (this.EOBRUN == 0) {
            for (k = Ss; k <= Se; ++k) {
                s = huffTable.decode(this.in);
                r = s >> 4;
                if ((s &= 0xF) != 0) {
                    if (s != 1) {
                        // empty if block
                    }
                    s = this.in.readBit() != 0 ? p1 : m1;
                } else if (r != 15) {
                    this.EOBRUN = 1 << r;
                    if (r == 0) break;
                    r = (int)this.in.readBits(r);
                    this.EOBRUN += r;
                    break;
                }
                do {
                    if ((coef = mcu[offset + MarkerConstants.BLOCK_NATURAL_ORDER[k]]) != 0) {
                        if (this.in.readBit() == 0 || (coef & p1) != 0) continue;
                        coef = coef >= 0 ? (coef += p1) : (coef += m1);
                        mcu[offset + MarkerConstants.BLOCK_NATURAL_ORDER[k]] = coef;
                        continue;
                    }
                    if (--r < 0) break;
                } while (++k <= Se);
                if (s == 0) continue;
                mcu[offset + MarkerConstants.BLOCK_NATURAL_ORDER[k]] = s;
            }
        }
        if (this.EOBRUN > 0) {
            while (k <= Se) {
                coef = mcu[offset + MarkerConstants.BLOCK_NATURAL_ORDER[k]];
                if (coef != 0 && this.in.readBit() != 0 && (coef & p1) == 0) {
                    coef = coef >= 0 ? (coef += p1) : (coef += m1);
                    mcu[offset + MarkerConstants.BLOCK_NATURAL_ORDER[k]] = coef;
                }
                ++k;
            }
            --this.EOBRUN;
        }
        return 0;
    }

    protected int decodeDCRefine(int Al, int[] mcu, int blkIndex) throws IOException, JPEGMarkerException {
        int bit = 0;
        int p1 = 1 << Al;
        bit = this.in.readBit();
        if (bit != 0) {
            int n = blkIndex * 64 + 0;
            mcu[n] = mcu[n] | p1;
        }
        return 0;
    }

    protected int decodeACFirst(HuffmanTable huffTable, int Ss, int Se, int Al, int[] mcu, int blkIndex) throws IOException, JPEGMarkerException {
        int r = 0;
        int s = 0;
        int offset = blkIndex * 64;
        if (this.EOBRUN > 0) {
            --this.EOBRUN;
        } else {
            for (int k = Ss; k <= Se; ++k) {
                s = huffTable.decode(this.in);
                r = s >> 4;
                if ((s &= 0xF) != 0) {
                    k += r;
                    r = (int)this.in.readBits(s);
                    s = huffTable.extend(r, s);
                    mcu[offset + MarkerConstants.BLOCK_NATURAL_ORDER[k]] = s << Al;
                    continue;
                }
                if (r == 15) {
                    k += 15;
                    continue;
                }
                this.EOBRUN = 1 << r;
                if (r != 0) {
                    r = (int)this.in.readBits(r);
                    this.EOBRUN += r;
                }
                --this.EOBRUN;
                break;
            }
        }
        return 1;
    }

    protected int decodeDCFirst(int index, HuffmanTable huffTable, int Al, int[] mcu, int blkIndex) throws IOException, JPEGMarkerException {
        int s = huffTable.decode(this.in);
        if (s > 0) {
            int r = (int)this.in.readBits(s);
            s = huffTable.extend(r, s);
        }
        this.preDC[index] = s = this.preDC[index] + s;
        mcu[blkIndex * 64 + 0] = s << Al;
        return 0;
    }

    public ExtendImageHeader getExtendImageHeader() {
        return this.extendImageHeader;
    }
}

