/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.simpleimage.render;

import com.alibaba.simpleimage.ImageFormat;
import com.alibaba.simpleimage.ImageRender;
import com.alibaba.simpleimage.ImageWrapper;
import com.alibaba.simpleimage.SimpleImageException;
import com.alibaba.simpleimage.render.ReadRender;
import com.alibaba.simpleimage.render.ScaleParameter;
import com.alibaba.simpleimage.util.ImageScaleHelper;
import java.io.InputStream;
import javax.media.jai.PlanarImage;

public class ScaleRender
extends ImageRender {
    private ScaleParameter zoom = null;
    private ImageWrapper imgWrapper = null;

    public ScaleRender(ImageRender imageRender, ScaleParameter p) {
        super(imageRender);
        this.zoom = p;
    }

    public ScaleRender(ImageWrapper imgWrapper, ScaleParameter p) {
        super(null);
        this.zoom = p;
        this.imgWrapper = imgWrapper;
    }

    public ScaleRender(InputStream input, ScaleParameter param) {
        super(new ReadRender(input));
        this.zoom = param;
    }

    public ScaleRender(InputStream input, boolean tosRGBColorSpace, ScaleParameter param) {
        super(new ReadRender(input, tosRGBColorSpace));
        this.zoom = param;
    }

    public void dispose() throws SimpleImageException {
        super.dispose();
        this.zoom = null;
    }

    public ImageWrapper render() throws SimpleImageException {
        if (this.imgWrapper == null) {
            this.imgWrapper = this.imageRender.render();
        }
        if (this.zoom == null) {
            return this.imgWrapper;
        }
        if (this.imgWrapper.getImageFormat() == ImageFormat.GIF) {
            this.imgWrapper = ImageScaleHelper.scaleGIF(this.imgWrapper, this.zoom);
        } else {
            PlanarImage img = ImageScaleHelper.scale(this.imgWrapper.getAsPlanarImage(), this.zoom);
            this.imgWrapper.setImage(img);
        }
        return this.imgWrapper;
    }

    public ScaleParameter getZoom() {
        return this.zoom;
    }

    public void setZoom(ScaleParameter zoom) {
        this.zoom = zoom;
    }
}

