/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.testable.agent.handler;

import agent.org.objectweb.asm.Label;
import agent.org.objectweb.asm.Type;
import agent.org.objectweb.asm.tree.AnnotationNode;
import agent.org.objectweb.asm.tree.ClassNode;
import agent.org.objectweb.asm.tree.InsnList;
import agent.org.objectweb.asm.tree.InsnNode;
import agent.org.objectweb.asm.tree.LabelNode;
import agent.org.objectweb.asm.tree.LdcInsnNode;
import agent.org.objectweb.asm.tree.LocalVariableNode;
import agent.org.objectweb.asm.tree.MethodInsnNode;
import agent.org.objectweb.asm.tree.MethodNode;
import agent.org.objectweb.asm.tree.TypeInsnNode;
import agent.org.objectweb.asm.tree.VarInsnNode;
import com.alibaba.testable.agent.handler.BaseClassHandler;
import com.alibaba.testable.agent.util.AnnotationUtil;
import com.alibaba.testable.agent.util.BytecodeUtil;
import com.alibaba.testable.agent.util.ClassUtil;
import com.alibaba.testable.core.tool.CollectionTool;
import com.alibaba.testable.core.util.CollectionUtil;
import com.alibaba.testable.core.util.LogUtil;
import com.alibaba.testable.core.util.StringUtil;
import com.alibaba.testable.core.util.TypeUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OmniClassHandler
extends BaseClassHandler {
    private static final String VOID_TYPE = "java/lang/Void";
    private static final String IGNORE = "ignore";
    private static final String METHOD_START = "(";
    private static final String VOID_METHOD_END = ")V";
    private static final String ENABLE_CONFIGURATION = "org.springframework.context.annotation.Configuration";
    private static final String CLASS_OMNI_CONSTRUCTOR = "com/alibaba/testable/core/tool/OmniConstructor";
    public static final String CLASS_CONSTRUCTION_OPTION = "com/alibaba/testable/core/model/ConstructionOption";
    public static final String METHOD_NEW_INSTANCE = "newInstance";
    public static final String METHOD_DESC_NEW_INSTANCE = "(Ljava/lang/Class;[Lcom/alibaba/testable/core/model/ConstructionOption;)Ljava/lang/Object;";
    private static final Map<String, String[]> PRELOADED_CLASSES = CollectionTool.mapOf((Map.Entry[])new Map.Entry[]{CollectionTool.entryOf((Object)"java/lang/Object", (Object)CollectionTool.arrayOf((Object[])new String[0]))});
    private static final String[] JUNIT_TEST_ANNOTATIONS = new String[]{"Lorg/junit/Test;", "Lorg/junit/jupiter/api/Test;", "Lorg/junit/jupiter/params/ParameterizedTest;"};
    private static final Map<String, Class<?>[]> constructorParameterCache = new HashMap<String, Class<?>[]>();

    @Override
    protected void transform(ClassNode cn) {
        if (this.isInterfaceOrAtom(cn) || this.isUniqueConstructorClass(cn) || this.isUninstantiableClass(cn) || AnnotationUtil.getClassAnnotation(cn, ENABLE_CONFIGURATION) != null) {
            return;
        }
        this.addConstructorWithVoidTypeParameter(cn);
    }

    private void addConstructorWithVoidTypeParameter(ClassNode cn) {
        int extraParameterCount;
        LabelNode end;
        LabelNode start;
        MethodNode constructor;
        block9: {
            constructor = new MethodNode(1, "<init>", METHOD_START + ClassUtil.toByteCodeClassName(VOID_TYPE) + VOID_METHOD_END, null, null);
            start = new LabelNode(new Label());
            end = new LabelNode(new Label());
            extraParameterCount = 2;
            if (PRELOADED_CLASSES.containsKey(cn.superName)) {
                constructor.instructions = this.invokeSuperWithoutTestableParameter(cn.superName, PRELOADED_CLASSES.get(cn.superName), start, end);
                extraParameterCount = PRELOADED_CLASSES.get(cn.superName).length;
            } else if (cn.superName.startsWith("java/")) {
                try {
                    Class<?>[] constructorParameterTypes = constructorParameterCache.get(cn.superName);
                    if (constructorParameterTypes == null) {
                        Class<?> superClazz = Class.forName(ClassUtil.toDotSeparatedName(cn.superName));
                        constructorParameterTypes = TypeUtil.getBestConstructor(superClazz).getParameterTypes();
                        constructorParameterCache.put(superClazz.getName(), constructorParameterTypes);
                    }
                    if (constructorParameterTypes.length == 0) {
                        constructor.instructions = this.invokeSuperWithoutTestableParameter(cn.superName, new String[0], start, end);
                        extraParameterCount = 0;
                        break block9;
                    }
                    if (constructorParameterTypes.length == 1 && constructorParameterTypes[0].equals(Void.class)) {
                        constructor.instructions = this.invokeSuperWithTestableVoidParameter(cn.superName, start, end);
                        break block9;
                    }
                    constructor.instructions = this.invokeSuperWithoutTestableParameter(cn.superName, this.toByteCodeClassNames(constructorParameterTypes), start, end);
                    extraParameterCount = constructorParameterTypes.length;
                }
                catch (ClassNotFoundException e) {
                    LogUtil.warn((String)("[OmniConstructor] Failed to load class " + cn.superName), (Object[])new Object[0]);
                    constructor.instructions = this.invokeSuperWithoutTestableParameter(cn.superName, new String[0], start, end);
                }
            } else {
                constructor.instructions = this.invokeSuperWithTestableVoidParameter(cn.superName, start, end);
            }
        }
        constructor.localVariables = this.createLocalVariables(cn, start, end);
        constructor.maxStack = 1 + extraParameterCount;
        constructor.maxLocals = 2;
        cn.methods.add(constructor);
    }

    private String[] toByteCodeClassNames(Class<?>[] classes) {
        String[] names = new String[classes.length];
        for (int i = 0; i < names.length; ++i) {
            names[i] = classes[i].isPrimitive() ? BytecodeUtil.PRIMITIVE_TYPE_NAME_MAP.get(classes[i].getName()) : (classes[i].isArray() ? ClassUtil.toSlashSeparatedName(classes[i].getName()) : ClassUtil.toByteCodeClassName(classes[i].getName()));
        }
        return names;
    }

    private boolean isUninstantiableClass(ClassNode cn) {
        for (MethodNode mn : cn.methods) {
            if (!mn.name.equals("<init>")) continue;
            return false;
        }
        return true;
    }

    private boolean isInterfaceOrAtom(ClassNode cn) {
        return (cn.access & 0x200) != 0 || cn.superName == null || VOID_TYPE.equals(cn.name);
    }

    private boolean isUniqueConstructorClass(ClassNode cn) {
        if ("org/elasticsearch/plugins/Plugin".equals(cn.superName)) {
            return true;
        }
        if (cn.name.contains("$MockitoMock$")) {
            return true;
        }
        for (MethodNode mn : cn.methods) {
            if (mn.visibleAnnotations == null) continue;
            for (AnnotationNode an : mn.visibleAnnotations) {
                if (!CollectionUtil.contains((Object[])JUNIT_TEST_ANNOTATIONS, (Object)an.desc)) continue;
                return true;
            }
        }
        return false;
    }

    private InsnList invokeSuperWithoutTestableParameter(String superName, String[] parameters, LabelNode start, LabelNode end) {
        InsnList il = new InsnList();
        il.add(start);
        il.add(new VarInsnNode(25, 0));
        for (String p : parameters) {
            il.add(new LdcInsnNode(Type.getType(p)));
            il.add(new InsnNode(3));
            il.add(new TypeInsnNode(189, CLASS_CONSTRUCTION_OPTION));
            il.add(new MethodInsnNode(184, CLASS_OMNI_CONSTRUCTOR, METHOD_NEW_INSTANCE, METHOD_DESC_NEW_INSTANCE, false));
            il.add(new TypeInsnNode(192, p.startsWith("[") ? p : ClassUtil.toSlashSeparateJavaStyleName(p)));
        }
        il.add(new MethodInsnNode(183, superName, "<init>", METHOD_START + StringUtil.join((String)"", (String[])parameters) + VOID_METHOD_END, false));
        il.add(new InsnNode(177));
        il.add(end);
        return il;
    }

    private InsnList invokeSuperWithTestableVoidParameter(String superName, LabelNode start, LabelNode end) {
        InsnList il = new InsnList();
        il.add(start);
        il.add(new VarInsnNode(25, 0));
        il.add(new VarInsnNode(25, 1));
        il.add(new MethodInsnNode(183, superName, "<init>", METHOD_START + ClassUtil.toByteCodeClassName(VOID_TYPE) + VOID_METHOD_END, false));
        il.add(new InsnNode(177));
        il.add(end);
        return il;
    }

    private List<LocalVariableNode> createLocalVariables(ClassNode cn, LabelNode start, LabelNode end) {
        return CollectionTool.listOf((Object[])new LocalVariableNode[]{new LocalVariableNode("this", ClassUtil.toByteCodeClassName(cn.name), null, start, end, 0), new LocalVariableNode(IGNORE, ClassUtil.toByteCodeClassName(VOID_TYPE), null, start, end, 1)});
    }
}

