/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.testable.agent.handler;

import agent.org.objectweb.asm.Handle;
import agent.org.objectweb.asm.Label;
import agent.org.objectweb.asm.MethodVisitor;
import agent.org.objectweb.asm.Type;
import agent.org.objectweb.asm.tree.AbstractInsnNode;
import agent.org.objectweb.asm.tree.ClassNode;
import agent.org.objectweb.asm.tree.FrameNode;
import agent.org.objectweb.asm.tree.InsnNode;
import agent.org.objectweb.asm.tree.InvokeDynamicInsnNode;
import agent.org.objectweb.asm.tree.JumpInsnNode;
import agent.org.objectweb.asm.tree.LabelNode;
import agent.org.objectweb.asm.tree.LineNumberNode;
import agent.org.objectweb.asm.tree.MethodInsnNode;
import agent.org.objectweb.asm.tree.MethodNode;
import agent.org.objectweb.asm.tree.TypeInsnNode;
import com.alibaba.testable.agent.handler.BaseClassHandler;
import com.alibaba.testable.agent.model.BasicType;
import com.alibaba.testable.agent.model.BsmArg;
import com.alibaba.testable.agent.model.MethodInfo;
import com.alibaba.testable.agent.model.TravelStatus;
import com.alibaba.testable.agent.util.BytecodeUtil;
import com.alibaba.testable.agent.util.ClassUtil;
import com.alibaba.testable.agent.util.MethodUtil;
import com.alibaba.testable.core.util.LogUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

public class SourceClassHandler
extends BaseClassHandler {
    private final AtomicInteger atomicInteger = new AtomicInteger();
    private final String mockClassName;
    private final List<MethodInfo> injectMethods;
    private final Set<Integer> invokeOps = new HashSet<Integer>(){
        {
            this.add(182);
            this.add(183);
            this.add(184);
            this.add(185);
        }
    };

    public SourceClassHandler(List<MethodInfo> injectMethods, String mockClassName) {
        this.injectMethods = injectMethods;
        this.mockClassName = mockClassName;
    }

    @Override
    protected void transform(ClassNode cn) {
        LogUtil.diagnose((String)"Found source class %s", (Object[])new Object[]{cn.name});
        if (this.injectMethods.isEmpty()) {
            return;
        }
        HashSet<MethodInfo> memberInjectMethods = new HashSet<MethodInfo>();
        HashSet<MethodInfo> newOperatorInjectMethods = new HashSet<MethodInfo>();
        for (MethodInfo im : this.injectMethods) {
            if (im.getName().equals("<init>")) {
                newOperatorInjectMethods.add(im);
                continue;
            }
            memberInjectMethods.add(im);
        }
        if (!memberInjectMethods.isEmpty()) {
            this.resolveMethodReference(cn, memberInjectMethods);
        }
        for (MethodNode m : cn.methods) {
            this.transformMethod(m, memberInjectMethods, newOperatorInjectMethods);
        }
    }

    private void transformMethod(MethodNode mn, Set<MethodInfo> memberInjectMethods, Set<MethodInfo> newOperatorInjectMethods) {
        LogUtil.verbose((String)"   Found method %s", (Object[])new Object[]{mn.name});
        if (mn.name.startsWith("$")) {
            return;
        }
        AbstractInsnNode[] instructions = mn.instructions.toArray();
        if (instructions.length == 0) {
            return;
        }
        int i = 0;
        do {
            MethodInfo mockMethod;
            int rangeStart;
            if (!this.invokeOps.contains(instructions[i].getOpcode())) continue;
            MethodInsnNode node = (MethodInsnNode)instructions[i];
            if ("<init>".equals(node.name)) {
                MethodInfo newOperatorInjectMethod;
                if (LogUtil.isVerboseEnabled()) {
                    LogUtil.verbose((String)"     Line %d, constructing \"%s\"", (Object[])new Object[]{this.getLineNum(instructions, i), MethodUtil.toJavaMethodDesc(node.owner, node.desc)});
                }
                if ((newOperatorInjectMethod = this.getNewOperatorInjectMethod(newOperatorInjectMethods, node)) == null || (rangeStart = this.getConstructorStart(instructions, node.owner, i)) < 0) continue;
                if (rangeStart < i) {
                    this.handleFrameStackChange(mn, newOperatorInjectMethod, rangeStart, i);
                }
                instructions = this.replaceNewOps(mn, newOperatorInjectMethod, instructions, rangeStart, i);
                i = rangeStart;
                continue;
            }
            if (LogUtil.isVerboseEnabled()) {
                LogUtil.verbose((String)"     Line %d, invoking \"%s\"", (Object[])new Object[]{this.getLineNum(instructions, i), MethodUtil.toJavaMethodDesc(node.owner, node.name, node.desc)});
            }
            if ((mockMethod = this.getMemberInjectMethodName(memberInjectMethods, node)) == null) continue;
            rangeStart = this.getMemberMethodStart(instructions, i);
            if (rangeStart >= 0) {
                if (rangeStart < i) {
                    this.handleFrameStackChange(mn, mockMethod, rangeStart, i);
                }
                instructions = this.replaceMemberCallOps(mn, mockMethod, instructions, node.owner, node.getOpcode(), rangeStart, i);
                i = rangeStart;
                continue;
            }
            LogUtil.warn((String)"Potential missed mocking at %s:%s", (Object[])new Object[]{mn.name, this.getLineNum(instructions, i)});
        } while (++i < instructions.length);
    }

    private MethodInfo getMemberInjectMethodName(Set<MethodInfo> memberInjectMethods, MethodInsnNode node) {
        for (MethodInfo m : memberInjectMethods) {
            String nodeDesc;
            String nodeOwner = ClassUtil.fitCompanionClassName(node.owner);
            String nodeName = ClassUtil.fitKotlinAccessorName(node.name);
            String string = nodeDesc = nodeName.equals(node.name) ? node.desc : MethodUtil.removeFirstParameter(node.desc);
            if (!m.getClazz().equals(nodeOwner) || !m.getName().equals(nodeName) || !m.getDesc().equals(nodeDesc)) continue;
            return m;
        }
        return null;
    }

    private MethodInfo getNewOperatorInjectMethod(Set<MethodInfo> newOperatorInjectMethods, MethodInsnNode node) {
        for (MethodInfo m : newOperatorInjectMethods) {
            if (!m.getDesc().equals(this.getConstructorInjectDesc(node))) continue;
            return m;
        }
        return null;
    }

    private String getConstructorInjectDesc(MethodInsnNode constructorNode) {
        return constructorNode.desc.substring(0, constructorNode.desc.length() - 1) + ClassUtil.toByteCodeClassName(constructorNode.owner);
    }

    private int getConstructorStart(AbstractInsnNode[] instructions, String target, int rangeEnd) {
        for (int i = rangeEnd - 1; i >= 0; --i) {
            if (instructions[i].getOpcode() != 187 || !((TypeInsnNode)instructions[i]).desc.equals(target)) continue;
            return i;
        }
        return -1;
    }

    private int getMemberMethodStart(AbstractInsnNode[] instructions, int rangeEnd) {
        int stackLevel = this.getInitialStackLevel((MethodInsnNode)instructions[rangeEnd]);
        if (stackLevel < 0) {
            return rangeEnd;
        }
        Label labelToJump = null;
        TravelStatus status = TravelStatus.Normal;
        block5: for (int i = rangeEnd - 1; i >= 0; --i) {
            switch (status) {
                case Normal: {
                    if (instructions[i] instanceof FrameNode) {
                        status = TravelStatus.LookingForLabel;
                        continue block5;
                    }
                    if ((stackLevel += this.getStackLevelChange(instructions[i])) >= 0) continue block5;
                    return i;
                }
                case LookingForLabel: {
                    if (!(instructions[i] instanceof LabelNode)) continue block5;
                    labelToJump = ((LabelNode)instructions[i]).getLabel();
                    status = TravelStatus.LookingForJump;
                    continue block5;
                }
                case LookingForJump: {
                    if (!(instructions[i] instanceof JumpInsnNode) || !((JumpInsnNode)instructions[i]).label.getLabel().equals(labelToJump)) continue block5;
                    stackLevel += this.getStackLevelChange(instructions[i]);
                    labelToJump = null;
                    status = TravelStatus.Normal;
                    continue block5;
                }
            }
        }
        return -1;
    }

    private int getInitialStackLevel(MethodInsnNode instruction) {
        int stackLevel = MethodUtil.getParameterTypes(instruction.desc).size();
        switch (instruction.getOpcode()) {
            case 182: 
            case 183: 
            case 185: {
                return stackLevel;
            }
            case 184: 
            case 186: {
                return stackLevel - 1;
            }
        }
        return 0;
    }

    private int getStackLevelChange(AbstractInsnNode instruction) {
        switch (instruction.getOpcode()) {
            case 182: 
            case 183: 
            case 185: {
                return this.stackEffectOfInvocation(((MethodInsnNode)instruction).desc) + 1;
            }
            case 184: {
                return this.stackEffectOfInvocation(((MethodInsnNode)instruction).desc);
            }
            case 186: {
                return this.stackEffectOfInvocation(((InvokeDynamicInsnNode)instruction).desc);
            }
            case -1: {
                return 0;
            }
        }
        return -BytecodeUtil.stackEffect(instruction.getOpcode());
    }

    private int stackEffectOfInvocation(String desc) {
        return MethodUtil.getParameterTypes(desc).size() - (MethodUtil.getReturnType(desc).equals("V") ? 0 : 1);
    }

    private AbstractInsnNode[] replaceNewOps(MethodNode mn, MethodInfo newOperatorInjectMethod, AbstractInsnNode[] instructions, int start, int end) {
        String mockMethodName = newOperatorInjectMethod.getMockName();
        int invokeOpcode = newOperatorInjectMethod.isStatic() ? 184 : 182;
        String log = String.format("Line %d, mock method \"%s\" used", this.getLineNum(instructions, start), mockMethodName);
        if (LogUtil.isVerboseEnabled()) {
            LogUtil.verbose((int)5, (String)log, (Object[])new Object[0]);
        } else {
            LogUtil.diagnose((int)2, (String)log, (Object[])new Object[0]);
        }
        String classType = ((TypeInsnNode)instructions[start]).desc;
        String constructorDesc = ((MethodInsnNode)instructions[end]).desc;
        if (!newOperatorInjectMethod.isStatic()) {
            mn.instructions.insertBefore(instructions[start], new MethodInsnNode(184, this.mockClassName, "testableIns", "()" + ClassUtil.toByteCodeClassName(this.mockClassName), false));
        }
        mn.instructions.insertBefore(instructions[end], new MethodInsnNode(invokeOpcode, this.mockClassName, mockMethodName, this.getConstructorInjectDesc(constructorDesc, classType), false));
        mn.instructions.remove(instructions[start]);
        mn.instructions.remove(instructions[start + 1]);
        mn.instructions.remove(instructions[end]);
        return mn.instructions.toArray();
    }

    private int getLineNum(AbstractInsnNode[] instructions, int start) {
        for (int i = start - 1; i >= 0; --i) {
            if (!(instructions[i] instanceof LineNumberNode)) continue;
            return ((LineNumberNode)instructions[i]).line;
        }
        return 0;
    }

    private String getConstructorInjectDesc(String constructorDesc, String classType) {
        return constructorDesc.substring(0, constructorDesc.length() - 1) + ClassUtil.toByteCodeClassName(classType);
    }

    private AbstractInsnNode[] replaceMemberCallOps(MethodNode mn, MethodInfo mockMethod, AbstractInsnNode[] instructions, String ownerClass, int opcode, int start, int end) {
        String log = String.format("Line %d, mock method \"%s\" used", this.getLineNum(instructions, start), mockMethod.getMockName());
        if (LogUtil.isVerboseEnabled()) {
            LogUtil.verbose((int)5, (String)log, (Object[])new Object[0]);
        } else {
            LogUtil.diagnose((int)2, (String)log, (Object[])new Object[0]);
        }
        if (!mockMethod.isStatic()) {
            mn.instructions.insertBefore(instructions[start], new MethodInsnNode(184, this.mockClassName, "testableIns", "()" + ClassUtil.toByteCodeClassName(this.mockClassName), false));
        }
        if (184 == opcode || this.isCompanionMethod(ownerClass, opcode)) {
            mn.instructions.insertBefore(instructions[start], new InsnNode(1));
            ++mn.maxStack;
            if (ClassUtil.isCompanionClassName(ownerClass)) {
                mn.instructions.remove(instructions[end - 1]);
            }
        }
        int invokeOpcode = mockMethod.isStatic() ? 184 : 182;
        mn.instructions.insertBefore(instructions[end], new MethodInsnNode(invokeOpcode, this.mockClassName, mockMethod.getMockName(), mockMethod.getMockDesc(), false));
        mn.instructions.remove(instructions[end]);
        ++mn.maxStack;
        return mn.instructions.toArray();
    }

    private void handleFrameStackChange(MethodNode mn, MethodInfo mockMethod, int start, int end) {
        AbstractInsnNode curInsn = mn.instructions.get(start);
        AbstractInsnNode endInsn = mn.instructions.get(end);
        do {
            if (!(curInsn instanceof FrameNode)) continue;
            FrameNode fn = (FrameNode)curInsn;
            if (fn.type != 0) continue;
            fn.stack.add(0, mockMethod.getMockClass());
            for (int i = fn.stack.size() - 1; i >= 0; --i) {
                if (!(fn.stack.get(i) instanceof LabelNode)) continue;
                fn.stack.remove(i);
            }
        } while (!(curInsn = curInsn.getNext()).equals(endInsn));
    }

    private boolean isCompanionMethod(String ownerClass, int opcode) {
        return 182 == opcode && ClassUtil.isCompanionClassName(ownerClass);
    }

    private List<BsmArg> fetchInvokeDynamicHandle(MethodNode mn) {
        ArrayList<BsmArg> handleList = new ArrayList<BsmArg>();
        for (AbstractInsnNode instruction : mn.instructions) {
            if (instruction.getOpcode() != 186) continue;
            InvokeDynamicInsnNode invokeDynamicInsnNode = (InvokeDynamicInsnNode)instruction;
            if (invokeDynamicInsnNode.bsmArgs.length < 3) continue;
            BsmArg bsmArg = new BsmArg(invokeDynamicInsnNode.bsmArgs);
            handleList.add(bsmArg);
        }
        return handleList;
    }

    private void resolveMethodReference(ClassNode cn, Set<MethodInfo> mockedMethods) {
        ArrayList<BsmArg> invokeDynamicList = new ArrayList<BsmArg>();
        for (MethodNode method : cn.methods) {
            List<BsmArg> handleList = this.fetchInvokeDynamicHandle(method);
            for (BsmArg arg : handleList) {
                for (MethodInfo mi : mockedMethods) {
                    if (!this.isMethodMocked(arg.getHandle(), mi)) continue;
                    invokeDynamicList.add(arg);
                }
            }
        }
        for (BsmArg bsmArg : invokeDynamicList) {
            int tag;
            if (bsmArg.getHandle().getName().startsWith("lambda$") || (tag = bsmArg.getHandle().getTag()) == 8) continue;
            boolean isStatic = bsmArg.isStatic();
            Handle handle = bsmArg.getHandle();
            Type handleDesc = bsmArg.getHandleDesc();
            String lambdaName = String.format("_Lambda$_%s_%d", handle.getName(), this.atomicInteger.incrementAndGet());
            MethodVisitor mv = cn.visitMethod(isStatic ? 9 : 1, lambdaName, handleDesc.getDescriptor(), null, null);
            mv.visitCode();
            Label l0 = new Label();
            mv.visitLabel(l0);
            if (!isStatic) {
                mv.visitVarInsn(25, 0);
            }
            Type[] argumentTypes = handleDesc.getArgumentTypes();
            int nextVar = isStatic ? 0 : 1;
            for (Type argumentType : argumentTypes) {
                String arg = argumentType.getDescriptor();
                mv.visitVarInsn(this.getLoadType(arg), nextVar);
                nextVar = this.isLongByte(argumentType) ? nextVar + 2 : nextVar + 1;
            }
            if (tag == 9) {
                mv.visitMethodInsn(185, handle.getOwner(), handle.getName(), bsmArg.getOriginalHandleDesc(), handle.isInterface());
            } else {
                mv.visitMethodInsn(6 == tag ? 184 : 182, handle.getOwner(), handle.getName(), bsmArg.getOriginalHandleDesc(), handle.isInterface());
            }
            mv.visitInsn(this.getReturnType(handleDesc.getReturnType().getDescriptor()));
            Label l1 = new Label();
            mv.visitLabel(l1);
            if (isStatic) {
                this.visitLocalVariableByArguments(mv, 0, argumentTypes, l0, l1);
            } else {
                mv.visitLocalVariable("this", "L" + handle.getOwner() + ";", null, l0, l1, 0);
                this.visitLocalVariableByArguments(mv, 1, argumentTypes, l0, l1);
            }
            mv.visitMaxs(-1, -1);
            mv.visitEnd();
            bsmArg.complete(cn.name, lambdaName);
        }
    }

    private boolean isMethodMocked(Handle targetHandle, MethodInfo mockMethodInfo) {
        if (targetHandle.getTag() == 9 || targetHandle.getTag() == 5) {
            String targetMockDesc = MethodUtil.addParameterAtBegin(mockMethodInfo.getDesc(), ClassUtil.toByteCodeClassName(mockMethodInfo.getClazz()));
            return mockMethodInfo.getClazz().equals(targetHandle.getOwner()) && mockMethodInfo.getName().equals(targetHandle.getName()) && targetMockDesc.equals(targetHandle.getDesc());
        }
        return mockMethodInfo.getClazz().equals(targetHandle.getOwner()) && mockMethodInfo.getName().equals(targetHandle.getName()) && mockMethodInfo.getDesc().equals(targetHandle.getDesc());
    }

    private void visitLocalVariableByArguments(MethodVisitor mv, int initVar, Type[] argumentTypes, Label l0, Label l1) {
        int nextLocalVar = initVar;
        for (int i = 0; i < argumentTypes.length; ++i) {
            Type argumentType = argumentTypes[i];
            String localVar = argumentType.getDescriptor();
            mv.visitLocalVariable(String.format("o%d", i), localVar, null, l0, l1, nextLocalVar);
            nextLocalVar = this.isLongByte(argumentType) ? nextLocalVar + 2 : nextLocalVar + 1;
        }
    }

    private boolean isLongByte(Type argumentType) {
        return Double.TYPE.getName().equals(argumentType.getClassName()) || Long.TYPE.getName().equals(argumentType.getClassName());
    }

    private int getReturnType(String returnType) {
        return BasicType.basicType((char)returnType.charAt((int)0)).returnInsn;
    }

    private int getLoadType(String arg) {
        return BasicType.basicType((char)arg.charAt((int)0)).loadVarInsn;
    }
}

