/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.testable.agent.model;

public final class WrapperType
extends Enum<WrapperType> {
    public static final /* enum */ WrapperType BOOLEAN = new WrapperType(Boolean.class, Boolean.TYPE, 'Z', Format.unsigned(1));
    public static final /* enum */ WrapperType BYTE = new WrapperType(Byte.class, Byte.TYPE, 'B', Format.signed(8));
    public static final /* enum */ WrapperType SHORT = new WrapperType(Short.class, Short.TYPE, 'S', Format.signed(16));
    public static final /* enum */ WrapperType CHAR = new WrapperType(Character.class, Character.TYPE, 'C', Format.unsigned(16));
    public static final /* enum */ WrapperType INT = new WrapperType(Integer.class, Integer.TYPE, 'I', Format.signed(32));
    public static final /* enum */ WrapperType LONG = new WrapperType(Long.class, Long.TYPE, 'J', Format.signed(64));
    public static final /* enum */ WrapperType FLOAT = new WrapperType(Float.class, Float.TYPE, 'F', Format.floating(32));
    public static final /* enum */ WrapperType DOUBLE = new WrapperType(Double.class, Double.TYPE, 'D', Format.floating(64));
    public static final /* enum */ WrapperType OBJECT = new WrapperType(Object.class, Object.class, 'L', Format.other(1));
    public static final /* enum */ WrapperType VOID = new WrapperType(Void.class, Void.TYPE, 'V', Format.other(0));
    private final Class<?> wrapperType;
    private final Class<?> primitiveType;
    private final char basicTypeChar;
    private final int format;
    private static final WrapperType[] FROM_PRIM;
    private static final WrapperType[] FROM_WRAP;
    private static final WrapperType[] FROM_CHAR;
    private static final /* synthetic */ WrapperType[] $VALUES;

    public static WrapperType[] values() {
        return (WrapperType[])$VALUES.clone();
    }

    public static WrapperType valueOf(String name) {
        return Enum.valueOf(WrapperType.class, name);
    }

    private WrapperType(Class<?> wtype, Class<?> ptype, char tchar, int format) {
        this.wrapperType = wtype;
        this.primitiveType = ptype;
        this.basicTypeChar = tchar;
        this.format = format;
    }

    public int bitWidth() {
        return this.format >> 2 & 0x3FF;
    }

    public int stackSlots() {
        return this.format >> 0 & 3;
    }

    public boolean isSingleWord() {
        return (this.format & 1) != 0;
    }

    public boolean isDoubleWord() {
        return (this.format & 2) != 0;
    }

    public boolean isNumeric() {
        return (this.format & 0xFFFFFFFC) != 0;
    }

    public boolean isIntegral() {
        return this.isNumeric() && this.format < 4225;
    }

    public boolean isSubwordOrInt() {
        return this.isIntegral() && this.isSingleWord();
    }

    public boolean isSigned() {
        return this.format < 0;
    }

    public boolean isUnsigned() {
        return this.format >= 5 && this.format < 4225;
    }

    public boolean isFloating() {
        return this.format >= 4225;
    }

    public boolean isOther() {
        return (this.format & 0xFFFFFFFC) == 0;
    }

    public boolean isConvertibleFrom(WrapperType source) {
        boolean floatOrSigned;
        if (this == source) {
            return true;
        }
        if (this.compareTo(source) < 0) {
            return false;
        }
        boolean bl = floatOrSigned = (this.format & source.format & 0xFFFFF000) != 0;
        if (!floatOrSigned) {
            if (this.isOther()) {
                return true;
            }
            return source.format == 65;
        }
        assert (this.isFloating() || this.isSigned());
        assert (source.isFloating() || source.isSigned());
        return true;
    }

    private static boolean checkConvertibleFrom() {
        for (WrapperType w : WrapperType.values()) {
            assert (w.isConvertibleFrom(w));
            assert (VOID.isConvertibleFrom(w));
            if (w != VOID) {
                assert (OBJECT.isConvertibleFrom(w));
                assert (!w.isConvertibleFrom(VOID));
            }
            if (w != CHAR) {
                assert (!CHAR.isConvertibleFrom(w));
                assert (w.isConvertibleFrom(INT) || !w.isConvertibleFrom(CHAR));
            }
            if (w != BOOLEAN) {
                assert (!BOOLEAN.isConvertibleFrom(w));
                assert (w == VOID || w == OBJECT || !w.isConvertibleFrom(BOOLEAN));
            }
            if (w.isSigned()) {
                for (WrapperType x : WrapperType.values()) {
                    if (w != x && (x.isFloating() ? !$assertionsDisabled && w.isConvertibleFrom(x) : x.isSigned() && (w.compareTo(x) < 0 ? !$assertionsDisabled && w.isConvertibleFrom(x) : !$assertionsDisabled && !w.isConvertibleFrom(x)))) {
                        throw new AssertionError();
                    }
                }
            }
            if (!w.isFloating()) continue;
            for (WrapperType x : WrapperType.values()) {
                if (w != x && (x.isSigned() ? !$assertionsDisabled && !w.isConvertibleFrom(x) : x.isFloating() && (w.compareTo(x) < 0 ? !$assertionsDisabled && w.isConvertibleFrom(x) : !$assertionsDisabled && !w.isConvertibleFrom(x)))) {
                    throw new AssertionError();
                }
            }
        }
        return true;
    }

    private static int hashPrim(Class<?> x) {
        String xn = x.getName();
        if (xn.length() < 3) {
            return 0;
        }
        return (xn.charAt(0) + xn.charAt(2)) % 16;
    }

    private static int hashWrap(Class<?> x) {
        String xn = x.getName();
        int offset = 10;
        if (xn.length() < 13) {
            return 0;
        }
        return (3 * xn.charAt(11) + xn.charAt(12)) % 16;
    }

    private static int hashChar(char x) {
        return (x + (x >> 1)) % 16;
    }

    public Object wrap(Object x) {
        switch (this.basicTypeChar) {
            case 'L': {
                return x;
            }
            case 'V': {
                return null;
            }
        }
        Number xn = WrapperType.numberValue(x);
        switch (this.basicTypeChar) {
            case 'I': {
                return xn.intValue();
            }
            case 'J': {
                return xn.longValue();
            }
            case 'F': {
                return Float.valueOf(xn.floatValue());
            }
            case 'D': {
                return xn.doubleValue();
            }
            case 'S': {
                return (short)xn.intValue();
            }
            case 'B': {
                return (byte)xn.intValue();
            }
            case 'C': {
                return Character.valueOf((char)xn.intValue());
            }
            case 'Z': {
                return WrapperType.boolValue(xn.byteValue());
            }
        }
        throw new InternalError("bad wrapper");
    }

    public Object wrap(int x) {
        if (this.basicTypeChar == 'L') {
            return x;
        }
        switch (this.basicTypeChar) {
            case 'L': {
                throw new IllegalArgumentException("cannot wrap to object type");
            }
            case 'V': {
                return null;
            }
            case 'I': {
                return x;
            }
            case 'J': {
                return (long)x;
            }
            case 'F': {
                return Float.valueOf(x);
            }
            case 'D': {
                return (double)x;
            }
            case 'S': {
                return (short)x;
            }
            case 'B': {
                return (byte)x;
            }
            case 'C': {
                return Character.valueOf((char)x);
            }
            case 'Z': {
                return WrapperType.boolValue((byte)x);
            }
        }
        throw new InternalError("bad wrapper");
    }

    private static Number numberValue(Object x) {
        if (x instanceof Number) {
            return (Number)x;
        }
        if (x instanceof Character) {
            return (int)((Character)x).charValue();
        }
        if (x instanceof Boolean) {
            return (Boolean)x != false ? 1 : 0;
        }
        return (Number)x;
    }

    private static boolean boolValue(byte bits) {
        return (bits = (byte)(bits & 1)) != 0;
    }

    static {
        $VALUES = new WrapperType[]{BOOLEAN, BYTE, SHORT, CHAR, INT, LONG, FLOAT, DOUBLE, OBJECT, VOID};
        assert (WrapperType.checkConvertibleFrom());
        FROM_PRIM = new WrapperType[16];
        FROM_WRAP = new WrapperType[16];
        FROM_CHAR = new WrapperType[16];
        for (WrapperType w : WrapperType.values()) {
            int pi = WrapperType.hashPrim(w.primitiveType);
            int wi = WrapperType.hashWrap(w.wrapperType);
            int ci = WrapperType.hashChar(w.basicTypeChar);
            assert (FROM_PRIM[pi] == null);
            assert (FROM_WRAP[wi] == null);
            assert (FROM_CHAR[ci] == null);
            WrapperType.FROM_PRIM[pi] = w;
            WrapperType.FROM_WRAP[wi] = w;
            WrapperType.FROM_CHAR[ci] = w;
        }
    }

    private static abstract class Format {
        static final int SLOT_SHIFT = 0;
        static final int SIZE_SHIFT = 2;
        static final int KIND_SHIFT = 12;
        static final int SIGNED = -4096;
        static final int UNSIGNED = 0;
        static final int FLOATING = 4096;
        static final int SLOT_MASK = 3;
        static final int SIZE_MASK = 1023;
        static final int INT = -3967;
        static final int SHORT = -4031;
        static final int BOOLEAN = 5;
        static final int CHAR = 65;
        static final int FLOAT = 4225;
        static final int VOID = 0;
        static final int NUM_MASK = -4;

        private Format() {
        }

        static int format(int kind, int size, int slots) {
            assert (kind >> 12 << 12 == kind);
            assert ((size & size - 1) == 0);
            assert (kind == -4096 ? size > 0 : (kind == 0 ? size > 0 : kind == 4096 && (size == 32 || size == 64)));
            assert (slots == 2 ? size == 64 : slots == 1 && size <= 32);
            return kind | size << 2 | slots << 0;
        }

        static int signed(int size) {
            return Format.format(-4096, size, size > 32 ? 2 : 1);
        }

        static int unsigned(int size) {
            return Format.format(0, size, size > 32 ? 2 : 1);
        }

        static int floating(int size) {
            return Format.format(4096, size, size > 32 ? 2 : 1);
        }

        static int other(int slots) {
            return slots << 0;
        }
    }
}

