/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.testable.agent.transformer;

import agent.org.objectweb.asm.Type;
import agent.org.objectweb.asm.tree.AnnotationNode;
import agent.org.objectweb.asm.tree.ClassNode;
import agent.org.objectweb.asm.tree.InnerClassNode;
import agent.org.objectweb.asm.tree.MethodNode;
import com.alibaba.testable.agent.model.MethodInfo;
import com.alibaba.testable.agent.tool.ImmutablePair;
import com.alibaba.testable.agent.util.AnnotationUtil;
import com.alibaba.testable.agent.util.ClassUtil;
import com.alibaba.testable.agent.util.DiagnoseUtil;
import com.alibaba.testable.agent.util.GlobalConfig;
import com.alibaba.testable.agent.util.MethodUtil;
import com.alibaba.testable.agent.util.MockInvokeUtil;
import com.alibaba.testable.core.exception.TargetNotExistException;
import com.alibaba.testable.core.util.LogUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class MockClassParser {
    public List<MethodInfo> getTestableMockMethods(String className) {
        ArrayList<MethodInfo> methodInfos = new ArrayList<MethodInfo>();
        ClassNode cn = ClassUtil.getClassNode(className);
        if (cn == null) {
            return new ArrayList<MethodInfo>();
        }
        for (MethodNode mn : this.getAllMethods(cn)) {
            this.addMethodWithAnnotationCheck(methodInfos, cn, mn);
        }
        this.handleMockContainerInherits(methodInfos, cn);
        return methodInfos;
    }

    public boolean isMockClass(ClassNode cn) {
        if (cn == null) {
            return false;
        }
        DiagnoseUtil.setupByClass(cn);
        if (AnnotationUtil.getClassAnnotation(cn, "com.alibaba.testable.core.annotation.MockContainer") != null) {
            return true;
        }
        for (MethodNode mn : cn.name.endsWith("Mock") ? this.getAllMethods(cn) : cn.methods) {
            if (mn.visibleAnnotations == null) continue;
            for (AnnotationNode an : mn.visibleAnnotations) {
                String fullClassName = ClassUtil.toJavaStyleClassName(an.desc);
                if (!fullClassName.equals("com.alibaba.testable.core.annotation.MockInvoke") && !fullClassName.equals("com.alibaba.testable.core.annotation.MockNew")) continue;
                return true;
            }
        }
        return false;
    }

    private List<MethodNode> getAllMethods(ClassNode cn) {
        ClassNode scn;
        ClassNode scn2;
        ArrayList<MethodNode> mns = new ArrayList<MethodNode>(cn.methods);
        if (cn.superName != null && !cn.superName.equals("java/lang/Object") && (scn2 = ClassUtil.getClassNode(cn.superName)) != null) {
            mns.addAll(this.getAllMethods(scn2));
        }
        for (String interfaceClass : cn.interfaces) {
            scn = ClassUtil.getClassNode(interfaceClass);
            if (scn == null) continue;
            mns.addAll(this.getAllMethods(scn));
        }
        for (InnerClassNode innerClass : cn.innerClasses) {
            if (!innerClass.name.equals(cn.name + "$Companion") || (scn = ClassUtil.getClassNode(innerClass.name)) == null) continue;
            mns.addAll(this.getAllMethods(scn));
        }
        return mns;
    }

    private void handleMockContainerInherits(List<MethodInfo> methodInfos, ClassNode cn) {
        AnnotationNode an = AnnotationUtil.getClassAnnotation(cn, "com.alibaba.testable.core.annotation.MockContainer");
        if (an != null) {
            for (Object st : AnnotationUtil.getAnnotationParameter(an, "inherits", Collections.emptyList(), List.class)) {
                String superClassName = ((Type)st).getClassName();
                ClassNode superCn = ClassUtil.getClassNode(superClassName);
                if (superCn == null) {
                    LogUtil.warn((String)"failed to load class '%s' inherited by '%s'", (Object[])new Object[]{superClassName, cn.name});
                    continue;
                }
                for (MethodNode mn : this.getAllMethods(superCn)) {
                    this.addMethodWithAnnotationCheck(methodInfos, cn, mn);
                }
            }
        }
    }

    private void addMethodWithAnnotationCheck(List<MethodInfo> methodInfos, ClassNode cn, MethodNode mn) {
        if (mn.visibleAnnotations == null) {
            return;
        }
        for (AnnotationNode an : mn.visibleAnnotations) {
            String targetMethod;
            MethodInfo mi;
            String fullClassName = ClassUtil.toJavaStyleClassName(an.desc);
            if (fullClassName.equals("com.alibaba.testable.core.annotation.MockNew")) {
                if (GlobalConfig.checkMockTargetExistence) {
                    this.checkTargetConstructorExists(cn, mn);
                }
                methodInfos.add(new MethodInfo(ClassUtil.getSourceClassName(cn.name), "<init>", mn.desc, cn.name, mn.name, mn.desc, MethodUtil.isStatic(mn)));
                continue;
            }
            if (!fullClassName.equals("com.alibaba.testable.core.annotation.MockInvoke") || !this.isValidMockMethod(mn, an)) continue;
            if (GlobalConfig.checkMockTargetExistence) {
                this.checkTargetMethodExists(cn, mn, an);
            }
            if ((mi = this.getMethodInfo(cn, mn, an, targetMethod = AnnotationUtil.getAnnotationParameter(an, "targetMethod", mn.name, String.class))) != null) {
                methodInfos.add(mi);
                break;
            }
            LogUtil.warn((String)"Failed to parse method %s::%s", (Object[])new Object[]{cn.name, mn.name});
            break;
        }
    }

    private MethodInfo getMethodInfo(ClassNode cn, MethodNode mn, AnnotationNode an, String targetMethod) {
        String targetTypeName = MockInvokeUtil.getTargetClassName(an);
        boolean isStatic = MethodUtil.isStatic(mn);
        if (targetTypeName == null) {
            ImmutablePair<String, String> methodDescPair = MethodUtil.splitFirstAndRestParameters(mn.desc);
            if (((String)methodDescPair.left).isEmpty()) {
                return null;
            }
            return new MethodInfo((String)methodDescPair.left, targetMethod, (String)methodDescPair.right, cn.name, mn.name, mn.desc, isStatic);
        }
        String slashSeparatedName = ClassUtil.toSlashSeparatedName(targetTypeName);
        return new MethodInfo(slashSeparatedName, targetMethod, mn.desc, cn.name, mn.name, MethodUtil.addParameterAtBegin(mn.desc, ClassUtil.toByteCodeClassName(slashSeparatedName)), isStatic);
    }

    private void checkTargetMethodExists(ClassNode cn, MethodNode mn, AnnotationNode an) {
        String targetClassName;
        String targetMethodName = AnnotationUtil.getAnnotationParameter(an, "targetMethod", null, String.class);
        if (targetMethodName == null) {
            targetMethodName = mn.name;
        }
        if ((targetClassName = MockInvokeUtil.getTargetClassName(an)) != null) {
            String targetMethodDesc = mn.desc;
            this.checkMethodExists(cn.name, mn.name, targetClassName, targetMethodName, targetMethodDesc);
        } else if (mn.desc.charAt(1) == 'L') {
            ImmutablePair<String, String> parameterPair = MethodUtil.splitFirstAndRestParameters(mn.desc);
            targetClassName = ClassUtil.toDotSeparatedName((String)parameterPair.left);
            String targetMethodDesc = (String)parameterPair.right;
            this.checkMethodExists(cn.name, mn.name, targetClassName, targetMethodName, targetMethodDesc);
        } else {
            throw new TargetNotExistException("target class not exist", cn.name, mn.name);
        }
    }

    private void checkMethodExists(String mockClassName, String mockMethodName, String targetClassName, String targetMethodName, String targetMethodDesc) {
        ClassNode targetClassNode = ClassUtil.getClassNode(targetClassName);
        if (targetClassNode == null) {
            throw new TargetNotExistException("target class not found", mockClassName, mockMethodName);
        }
        boolean targetFound = false;
        for (MethodNode targetMethodNode : this.getAllMethods(targetClassNode)) {
            if (!targetMethodNode.name.equals(targetMethodName)) continue;
            targetFound = true;
            if (!targetMethodNode.desc.equals(targetMethodDesc)) continue;
            return;
        }
        throw new TargetNotExistException(targetFound ? "mock method does not match original method" : "no such method in target class", mockClassName, mockMethodName);
    }

    private void checkTargetConstructorExists(ClassNode cn, MethodNode mn) {
        String returnType = MethodUtil.getReturnType(mn.desc);
        if (returnType.charAt(0) != 'L') {
            throw new TargetNotExistException("return type is not a class", cn.name, mn.name);
        }
        ClassNode targetClassNode = ClassUtil.getClassNode(ClassUtil.toJavaStyleClassName(returnType));
        if (targetClassNode == null) {
            throw new TargetNotExistException("target class not found", cn.name, mn.name);
        }
        for (MethodNode targetMethodNode : targetClassNode.methods) {
            if (!"<init>".equals(targetMethodNode.name) || !MethodUtil.getParameters(targetMethodNode.desc).equals(MethodUtil.getParameters(mn.desc))) continue;
            return;
        }
        throw new TargetNotExistException("no such constructor in target class", cn.name, mn.name);
    }

    private boolean isValidMockMethod(MethodNode mn, AnnotationNode an) {
        if (MockInvokeUtil.hasTargetClassParameter(an)) {
            return true;
        }
        String firstParameter = MethodUtil.getFirstParameter(mn.desc);
        return !firstParameter.isEmpty() && firstParameter.charAt(0) == 'L';
    }
}

