/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.testable.agent.transformer;

import agent.org.objectweb.asm.Type;
import agent.org.objectweb.asm.tree.AnnotationNode;
import agent.org.objectweb.asm.tree.ClassNode;
import agent.org.objectweb.asm.tree.InnerClassNode;
import com.alibaba.testable.agent.handler.FinalFieldClassHandler;
import com.alibaba.testable.agent.handler.MockClassHandler;
import com.alibaba.testable.agent.handler.OmniClassHandler;
import com.alibaba.testable.agent.handler.SourceClassHandler;
import com.alibaba.testable.agent.handler.TestClassHandler;
import com.alibaba.testable.agent.handler.test.Framework;
import com.alibaba.testable.agent.model.MethodInfo;
import com.alibaba.testable.agent.transformer.MockClassParser;
import com.alibaba.testable.agent.transformer.TestClassChecker;
import com.alibaba.testable.agent.util.AnnotationUtil;
import com.alibaba.testable.agent.util.BytecodeUtil;
import com.alibaba.testable.agent.util.ClassUtil;
import com.alibaba.testable.agent.util.DiagnoseUtil;
import com.alibaba.testable.agent.util.GlobalConfig;
import com.alibaba.testable.agent.util.ThreadUtil;
import com.alibaba.testable.core.exception.TargetNotExistException;
import com.alibaba.testable.core.model.ClassType;
import com.alibaba.testable.core.util.LogUtil;
import com.alibaba.testable.core.util.MockAssociationUtil;
import java.lang.instrument.ClassFileTransformer;
import java.security.ProtectionDomain;
import java.util.List;
import java.util.Set;
import javax.lang.model.type.NullType;

public class TestableClassTransformer
implements ClassFileTransformer {
    private static final String FIELD_TREAT_AS = "treatAs";
    private static final String CLASS_JUNIT_5_NESTED = "org.junit.jupiter.api.Nested";
    private final String[] BLACKLIST_PREFIXES = new String[]{"sun/", "com/sun/", "javax/crypto/", "java/util/logging/", "org/gradle/", "org/robolectric/"};
    private final MockClassParser mockClassParser = new MockClassParser();
    private final TestClassChecker testClassChecker = new TestClassChecker();

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classFileBuffer) {
        ClassNode cn;
        if (this.isSystemClass(className)) {
            return null;
        }
        byte[] bytes = GlobalConfig.enhanceOmniConstructor ? new OmniClassHandler().getBytes(classFileBuffer) : classFileBuffer;
        byte[] byArray = bytes = GlobalConfig.enhanceFinal ? new FinalFieldClassHandler().getBytes(bytes) : bytes;
        if (GlobalConfig.enhanceMock && (cn = ClassUtil.getClassNode(className)) != null) {
            return this.transformMock(bytes, cn);
        }
        return bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] transformMock(byte[] bytes, ClassNode cn) {
        try {
            if (this.mockClassParser.isMockClass(cn)) {
                bytes = new MockClassHandler(cn.name).getBytes(bytes);
                BytecodeUtil.dumpByte(cn, GlobalConfig.getDumpPath(), bytes);
                byte[] byArray = bytes;
                return byArray;
            }
            String mockClass = this.foundMockForSourceClass(cn.name);
            if (mockClass != null) {
                List<MethodInfo> injectMethods = this.mockClassParser.getTestableMockMethods(mockClass);
                bytes = new SourceClassHandler(injectMethods, mockClass).getBytes(bytes);
                BytecodeUtil.dumpByte(cn, GlobalConfig.getDumpPath(), bytes);
                byte[] byArray = bytes;
                return byArray;
            }
            Framework framework = this.testClassChecker.checkFramework(cn);
            if (framework != null) {
                bytes = new TestClassHandler(framework).getBytes(bytes);
                BytecodeUtil.dumpByte(cn, GlobalConfig.getDumpPath(), bytes);
                byte[] byArray = bytes;
                return byArray;
            }
            if (cn.name.endsWith("Test")) {
                LogUtil.verbose((String)"Failed to detect test framework for %s", (Object[])new Object[]{cn.name});
            }
        }
        catch (TargetNotExistException e) {
            LogUtil.error((String)"Invalid mock method %s::%s - %s", (Object[])new Object[]{e.getClassName(), e.getMethodName(), e.getMessage()});
            System.exit(0);
        }
        catch (Throwable t) {
            LogUtil.warn((String)("Failed to transform class " + cn.name), (Object[])new Object[0]);
            LogUtil.warn((String)t.toString(), (Object[])new Object[0]);
            LogUtil.warn((String)ThreadUtil.getFirstRelatedStackLine(t), (Object[])new Object[0]);
        }
        finally {
            LogUtil.resetLogLevel();
        }
        BytecodeUtil.dumpByte(cn, null, bytes);
        return bytes;
    }

    private String foundMockForSourceClass(String name) {
        String className = GlobalConfig.getMockPackageMapping() == null ? name : this.mapPackage(name);
        String mockClass = this.lookForMockWithAnnotationAsSourceClass(className);
        if (mockClass != null) {
            return mockClass;
        }
        mockClass = this.foundMockForStandardClass(className);
        if (mockClass != null) {
            return mockClass;
        }
        return this.foundMockForInnerSourceClass(className);
    }

    private String mapPackage(String name) {
        String dotSeparatedName = ClassUtil.toDotSeparatedName(name);
        for (String prefix : GlobalConfig.getMockPackageMapping().keySet()) {
            if (!dotSeparatedName.startsWith(prefix)) continue;
            return ClassUtil.toSlashSeparatedName(GlobalConfig.getMockPackageMapping().get(prefix)) + name.substring(prefix.length());
        }
        return name;
    }

    private String foundMockForInnerSourceClass(String className) {
        return className.contains("$") && !className.endsWith("$Companion") ? this.foundMockForStandardClass(className.substring(0, className.indexOf("$"))) : null;
    }

    private String foundMockForStandardClass(String className) {
        ClassNode cn = this.adaptInnerClass(ClassUtil.getClassNode(ClassUtil.getTestClassName(className)));
        if (cn != null) {
            String mockClass = this.lookForMockWithAnnotationAsTestClass(cn);
            if (mockClass != null) {
                return mockClass;
            }
            mockClass = this.lookForInnerMockClass(cn);
            if (mockClass != null) {
                return mockClass;
            }
        }
        return this.lookForOuterMockClass(className);
    }

    private ClassNode adaptInnerClass(ClassNode cn) {
        if (AnnotationUtil.getClassAnnotation(cn, CLASS_JUNIT_5_NESTED) != null) {
            return ClassUtil.getClassNode(ClassUtil.toOuterClassName(cn.name));
        }
        return cn;
    }

    private String lookForOuterMockClass(String className) {
        String mockClassName = ClassUtil.getMockClassName(className);
        if (this.mockClassParser.isMockClass(ClassUtil.getClassNode(mockClassName))) {
            return mockClassName;
        }
        return null;
    }

    private boolean isSystemClass(String className) {
        if (null == className || className.contains("$$EnhancerBy")) {
            return true;
        }
        String[] blackList = GlobalConfig.getPkgPrefixBlackList();
        if (blackList != null && this.isInPrefixList(className, blackList)) {
            return true;
        }
        String[] whiteList = GlobalConfig.getPkgPrefixWhiteList();
        if (whiteList != null) {
            return !this.isInPrefixList(className, whiteList);
        }
        return this.isInPrefixList(className, this.BLACKLIST_PREFIXES);
    }

    private boolean isInPrefixList(String name, String[] prefixList) {
        for (String prefix : prefixList) {
            if (!name.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    private String lookForMockWithAnnotationAsSourceClass(String className) {
        ClassNode cn = ClassUtil.getClassNode(className);
        if (cn == null) {
            return null;
        }
        return this.parseMockWithAnnotation(cn, ClassType.SourceClass);
    }

    private String lookForInnerMockClass(ClassNode cn) {
        for (InnerClassNode ic : cn.innerClasses) {
            ClassNode innerClassNode = ClassUtil.getClassNode(ic.name);
            boolean isNameMatched = ic.name.equals(this.getInnerMockClassName(cn.name)) || AnnotationUtil.getClassAnnotation(innerClassNode, "com.alibaba.testable.core.annotation.MockContainer") != null;
            if (!isNameMatched || !this.mockClassParser.isMockClass(innerClassNode)) continue;
            if ((ic.access & 8) == 0) {
                LogUtil.warn((String)"Mock class in \"%s\" is not declared as static", (Object[])new Object[]{cn.name});
                continue;
            }
            ic.access = BytecodeUtil.toPublicAccess(ic.access);
            return ic.name;
        }
        return null;
    }

    private String lookForMockWithAnnotationAsTestClass(ClassNode cn) {
        String mockClassName = this.parseMockWithAnnotation(cn, ClassType.TestClass);
        if (mockClassName != null) {
            ((Set)MockAssociationUtil.mockToTests.get(mockClassName)).add(ClassUtil.toJavaStyleClassName(cn.name));
            return ClassUtil.toSlashSeparatedName(mockClassName);
        }
        return null;
    }

    private String parseMockWithAnnotation(ClassNode cn, ClassType expectedType) {
        ClassType type;
        AnnotationNode an = AnnotationUtil.getClassAnnotation(cn, "com.alibaba.testable.core.annotation.MockWith");
        if (an != null && this.isExpectedType(cn.name, type = AnnotationUtil.getAnnotationParameter(an, FIELD_TREAT_AS, ClassType.GuessByName, ClassType.class), expectedType)) {
            Type clazz = AnnotationUtil.getAnnotationParameter(an, "value", Type.getType(NullType.class), Type.class);
            DiagnoseUtil.setupByClass(ClassUtil.getClassNode(clazz.getClassName()));
            return clazz.getClassName();
        }
        return null;
    }

    private boolean isExpectedType(String className, ClassType type, ClassType expectedType) {
        if (type.equals((Object)ClassType.GuessByName)) {
            return expectedType.equals((Object)ClassType.TestClass) == className.endsWith("Test");
        }
        return type.equals((Object)expectedType);
    }

    private String getInnerMockClassName(String className) {
        return className + "$" + GlobalConfig.innerMockClassName;
    }
}

