/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.testable.agent.util;

import agent.org.objectweb.asm.tree.AnnotationNode;
import agent.org.objectweb.asm.tree.ClassNode;
import com.alibaba.testable.agent.util.ClassUtil;

public class AnnotationUtil {
    public static <T> T getAnnotationParameter(AnnotationNode an, String key, T defaultValue, Class<T> clazz) {
        if (an != null && an.values != null) {
            for (int i = 0; i < an.values.size(); i += 2) {
                if (!an.values.get(i).equals(key)) continue;
                if (clazz.isEnum()) {
                    String[] values = (String[])an.values.get(i + 1);
                    if (values == null || values.length != 2) {
                        return defaultValue;
                    }
                    Class<T> enumClazz = clazz;
                    return Enum.valueOf(enumClazz, values[1]);
                }
                try {
                    return clazz.cast(an.values.get(i + 1));
                }
                catch (ClassCastException e) {
                    return defaultValue;
                }
            }
        }
        return defaultValue;
    }

    public static boolean hasAnyAnnotationParameters(AnnotationNode an, String ... keys) {
        if (an != null && an.values != null) {
            for (int i = 0; i < an.values.size(); i += 2) {
                for (String key : keys) {
                    if (!an.values.get(i).equals(key)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean hasAllAnnotationParameters(AnnotationNode an, String ... keys) {
        if (an != null && an.values != null) {
            for (String key : keys) {
                boolean found = false;
                for (int i = 0; i < an.values.size(); i += 2) {
                    if (!an.values.get(i).equals(key)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean removeAnnotationParameters(AnnotationNode an, String ... keys) {
        if (an.values == null) {
            return false;
        }
        block0: for (String key : keys) {
            for (int i = 0; i < an.values.size(); i += 2) {
                if (!an.values.get(i).equals(key)) continue;
                an.values.remove(i + 1);
                an.values.remove(i);
                continue block0;
            }
        }
        return false;
    }

    public static AnnotationNode getClassAnnotation(ClassNode cn, String annotation) {
        if (cn != null && cn.visibleAnnotations != null) {
            for (AnnotationNode an : cn.visibleAnnotations) {
                if (!ClassUtil.toByteCodeClassName(annotation).equals(an.desc)) continue;
                return an;
            }
        }
        return null;
    }
}

