/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.testable.agent.util;

import com.alibaba.testable.agent.util.ClassUtil;
import com.alibaba.testable.agent.util.PathUtil;
import com.alibaba.testable.core.model.LogLevel;
import com.alibaba.testable.core.model.MockScope;
import com.alibaba.testable.core.util.LogUtil;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class GlobalConfig {
    private static final String MUTE = "mute";
    private static final String DEBUG = "debug";
    private static final String VERBOSE = "verbose";
    private static final String DISABLE_LOG_FILE = "null";
    private static final String TESTABLE_AGENT_LOG = "testable-agent.log";
    private static final String DEFAULT_MAVEN_OUTPUT_FOLDER = "target";
    private static final String DEFAULT_GRADLE_OUTPUT_FOLDER = "gradle";
    private static String logFile = null;
    private static String dumpPath = null;
    private static String[] pkgPrefixWhiteList = null;
    private static String[] pkgPrefixBlackList = null;
    private static Map<String, String> mockPkgMapping = null;
    public static MockScope defaultMockScope = MockScope.GLOBAL;
    public static boolean enhanceFinal = false;
    public static boolean enhanceMock = true;
    public static boolean enhanceOmniConstructor = false;
    public static boolean enhanceThreadLocal = false;
    public static boolean checkMockTargetExistence = false;
    public static String innerMockClassName = "Mock";

    public static void setLogLevel(String level) {
        if (level.equals(MUTE)) {
            LogUtil.setDefaultLevel((LogLevel)LogLevel.DISABLE);
        } else if (level.equals(DEBUG)) {
            LogUtil.setDefaultLevel((LogLevel)LogLevel.ENABLE);
        } else if (level.equals(VERBOSE)) {
            LogUtil.setDefaultLevel((LogLevel)LogLevel.VERBOSE);
        }
    }

    public static void setLogFile(String path) {
        logFile = path;
    }

    public static String getDumpPath() {
        return dumpPath == null || dumpPath.isEmpty() || !new File(dumpPath).isDirectory() ? null : dumpPath;
    }

    public static void setDumpPath(String path) {
        String fullPath = PathUtil.join(System.getProperty("user.dir"), path);
        if (com.alibaba.testable.core.util.PathUtil.createFolder((String)fullPath)) {
            dumpPath = fullPath;
        }
    }

    public static String[] getPkgPrefixWhiteList() {
        return pkgPrefixWhiteList;
    }

    public static void setPkgPrefixWhiteList(String prefixes) {
        pkgPrefixWhiteList = GlobalConfig.parsePkgPrefixList(prefixes).toArray(new String[0]);
    }

    public static String[] getPkgPrefixBlackList() {
        return pkgPrefixBlackList;
    }

    public static void setPkgPrefixBlackList(String prefixes) {
        pkgPrefixBlackList = GlobalConfig.parsePkgPrefixList(prefixes).toArray(new String[0]);
    }

    public static void setupLogRootPath() {
        if (logFile == null) {
            String baseFolder = GlobalConfig.getBuildOutputFolder();
            if (!baseFolder.isEmpty()) {
                String logFilePath = PathUtil.join(baseFolder, TESTABLE_AGENT_LOG);
                LogUtil.setGlobalLogPath((String)logFilePath);
                LogUtil.verbose((String)"Generate testable agent log file at: %s", (Object[])new Object[]{logFilePath});
            }
        } else if (!DISABLE_LOG_FILE.equals(logFile)) {
            LogUtil.setGlobalLogPath((String)PathUtil.join(System.getProperty("user.dir"), logFile));
        }
    }

    private static String getBuildOutputFolder() {
        String contextFolder = System.getProperty("user.dir");
        URL rootResourceFolder = Object.class.getResource("/");
        if (rootResourceFolder != null) {
            return PathUtil.getFirstLevelFolder(contextFolder, rootResourceFolder.getPath());
        }
        if (PathUtil.folderExists(PathUtil.join(contextFolder, DEFAULT_MAVEN_OUTPUT_FOLDER))) {
            return PathUtil.join(contextFolder, DEFAULT_MAVEN_OUTPUT_FOLDER);
        }
        if (PathUtil.folderExists(PathUtil.join(contextFolder, DEFAULT_GRADLE_OUTPUT_FOLDER))) {
            return PathUtil.join(contextFolder, DEFAULT_GRADLE_OUTPUT_FOLDER);
        }
        return System.getProperty("java.io.tmpdir");
    }

    public static void addMockPackageMapping(String originPkg, String mockClassPkg) {
        if (mockPkgMapping == null) {
            mockPkgMapping = new LinkedHashMap<String, String>(5);
        }
        mockPkgMapping.put(originPkg + ".", mockClassPkg + ".");
    }

    public static Map<String, String> getMockPackageMapping() {
        return mockPkgMapping;
    }

    private static List<String> parsePkgPrefixList(String prefixes) {
        ArrayList<String> whiteList = new ArrayList<String>();
        for (String p : prefixes.split(",")) {
            whiteList.add(ClassUtil.toSlashSeparatedName(p.endsWith(".") ? p : p + "."));
        }
        return whiteList;
    }
}

