/*
 * Decompiled with CFR 0.152.
 */
package com.alicp.jetcache.anno.support;

import com.alicp.jetcache.CacheBuilder;
import com.alicp.jetcache.CacheManager;
import com.alicp.jetcache.anno.support.CacheContext;
import com.alicp.jetcache.anno.support.CacheNameGenerator;
import com.alicp.jetcache.anno.support.DefaultCacheNameGenerator;
import com.alicp.jetcache.anno.support.DefaultEncoderParser;
import com.alicp.jetcache.anno.support.DefaultKeyConvertorParser;
import com.alicp.jetcache.anno.support.EncoderParser;
import com.alicp.jetcache.anno.support.GlobalCacheConfig;
import com.alicp.jetcache.anno.support.KeyConvertorParser;
import com.alicp.jetcache.anno.support.ParserFunction;
import com.alicp.jetcache.embedded.EmbeddedCacheBuilder;
import com.alicp.jetcache.external.ExternalCacheBuilder;
import com.alicp.jetcache.support.AbstractLifecycle;
import com.alicp.jetcache.support.StatInfo;
import com.alicp.jetcache.support.StatInfoLogger;
import com.alicp.jetcache.template.CacheBuilderTemplate;
import com.alicp.jetcache.template.CacheMonitorInstaller;
import com.alicp.jetcache.template.MetricsMonitorInstaller;
import com.alicp.jetcache.template.NotifyMonitorInstaller;
import java.time.Duration;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigProvider
extends AbstractLifecycle {
    private static final Logger logger = LoggerFactory.getLogger(ConfigProvider.class);
    @Resource
    protected GlobalCacheConfig globalCacheConfig;
    protected EncoderParser encoderParser = new DefaultEncoderParser();
    protected KeyConvertorParser keyConvertorParser = new DefaultKeyConvertorParser();
    private Consumer<StatInfo> metricsCallback = new StatInfoLogger(false);
    private CacheBuilderTemplate cacheBuilderTemplate;

    protected void doInit() {
        ParserFunction f;
        EmbeddedCacheBuilder eb;
        this.cacheBuilderTemplate = new CacheBuilderTemplate(this.globalCacheConfig.isPenetrationProtect(), new Map[]{this.globalCacheConfig.getLocalCacheBuilders(), this.globalCacheConfig.getRemoteCacheBuilders()});
        for (CacheBuilder builder : this.globalCacheConfig.getLocalCacheBuilders().values()) {
            eb = (EmbeddedCacheBuilder)builder;
            if (!(eb.getConfig().getKeyConvertor() instanceof ParserFunction)) continue;
            f = (ParserFunction)eb.getConfig().getKeyConvertor();
            eb.setKeyConvertor(this.parseKeyConvertor(f.getValue()));
        }
        for (CacheBuilder builder : this.globalCacheConfig.getRemoteCacheBuilders().values()) {
            eb = (ExternalCacheBuilder)builder;
            if (eb.getConfig().getKeyConvertor() instanceof ParserFunction) {
                f = (ParserFunction)eb.getConfig().getKeyConvertor();
                eb.setKeyConvertor(this.parseKeyConvertor(f.getValue()));
            }
            if (eb.getConfig().getValueEncoder() instanceof ParserFunction) {
                f = (ParserFunction)eb.getConfig().getValueEncoder();
                eb.setValueEncoder(this.parseValueEncoder(f.getValue()));
            }
            if (!(eb.getConfig().getValueDecoder() instanceof ParserFunction)) continue;
            f = (ParserFunction)eb.getConfig().getValueDecoder();
            eb.setValueDecoder(this.parseValueDecoder(f.getValue()));
        }
        this.initCacheMonitorInstallers();
    }

    protected void initCacheMonitorInstallers() {
        this.cacheBuilderTemplate.getCacheMonitorInstallers().add(this.metricsMonitorInstaller());
        this.cacheBuilderTemplate.getCacheMonitorInstallers().add(this.notifyMonitorInstaller());
        for (CacheMonitorInstaller i : this.cacheBuilderTemplate.getCacheMonitorInstallers()) {
            if (!(i instanceof AbstractLifecycle)) continue;
            ((AbstractLifecycle)i).init();
        }
    }

    protected CacheMonitorInstaller metricsMonitorInstaller() {
        Duration interval = null;
        if (this.globalCacheConfig.getStatIntervalMinutes() > 0) {
            interval = Duration.ofMinutes(this.globalCacheConfig.getStatIntervalMinutes());
        }
        MetricsMonitorInstaller i = new MetricsMonitorInstaller(this.metricsCallback, interval);
        i.init();
        return i;
    }

    protected CacheMonitorInstaller notifyMonitorInstaller() {
        return new NotifyMonitorInstaller(area -> this.globalCacheConfig.getRemoteCacheBuilders().get(area));
    }

    public CacheBuilderTemplate getCacheBuilderTemplate() {
        return this.cacheBuilderTemplate;
    }

    public void doShutdown() {
        try {
            for (CacheMonitorInstaller i : this.cacheBuilderTemplate.getCacheMonitorInstallers()) {
                if (!(i instanceof AbstractLifecycle)) continue;
                ((AbstractLifecycle)i).shutdown();
            }
        }
        catch (Exception e) {
            logger.error("close fail", (Throwable)e);
        }
    }

    public Function<Object, byte[]> parseValueEncoder(String valueEncoder) {
        return this.encoderParser.parseEncoder(valueEncoder);
    }

    public Function<byte[], Object> parseValueDecoder(String valueDecoder) {
        return this.encoderParser.parseDecoder(valueDecoder);
    }

    public Function<Object, Object> parseKeyConvertor(String convertor) {
        return this.keyConvertorParser.parseKeyConvertor(convertor);
    }

    public CacheNameGenerator createCacheNameGenerator(String[] hiddenPackages) {
        return new DefaultCacheNameGenerator(hiddenPackages);
    }

    public CacheContext newContext(CacheManager cacheManager) {
        return new CacheContext(cacheManager, this, this.globalCacheConfig);
    }

    public void setEncoderParser(EncoderParser encoderParser) {
        this.encoderParser = encoderParser;
    }

    public void setKeyConvertorParser(KeyConvertorParser keyConvertorParser) {
        this.keyConvertorParser = keyConvertorParser;
    }

    public GlobalCacheConfig getGlobalCacheConfig() {
        return this.globalCacheConfig;
    }

    public void setGlobalCacheConfig(GlobalCacheConfig globalCacheConfig) {
        this.globalCacheConfig = globalCacheConfig;
    }

    public void setMetricsCallback(Consumer<StatInfo> metricsCallback) {
        this.metricsCallback = metricsCallback;
    }
}

