/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.tracer.plugins.datasource;

import com.alipay.sofa.tracer.plugins.datasource.BaseDataSource;
import com.alipay.sofa.tracer.plugins.datasource.BasePreparedStatement;
import com.alipay.sofa.tracer.plugins.datasource.ExtendedPreparedStatement;
import com.alipay.sofa.tracer.plugins.datasource.ExtendedStatement;
import com.alipay.sofa.tracer.plugins.datasource.Prop;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;

public class ExtendedConnection
implements Connection {
    private final BaseDataSource dataSource;
    private final Connection delegate;
    private final Prop prop;

    public ExtendedConnection(BaseDataSource dataSource, Connection delegate, Prop prop) {
        this.dataSource = dataSource;
        this.delegate = delegate;
        this.prop = prop;
    }

    public Prop getProp() {
        return this.prop;
    }

    public Connection getDelegate() {
        return this.delegate;
    }

    public BaseDataSource getDataSource() {
        return this.dataSource;
    }

    @Override
    public Statement createStatement() throws SQLException {
        Statement st = this.delegate.createStatement();
        if (st != null) {
            return new ExtendedStatement(this, st, this.prop);
        }
        return null;
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        Statement st = this.delegate.createStatement(resultSetType, resultSetConcurrency);
        if (st != null) {
            return new ExtendedStatement(this, st, this.prop);
        }
        return null;
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        Statement st = this.delegate.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
        if (st != null) {
            return new ExtendedStatement(this, st, this.prop);
        }
        return null;
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        PreparedStatement delegatingPreparedStatement = null;
        delegatingPreparedStatement = this.prop.isFastDelegate() ? this.delegate.prepareStatement(sql) : new BasePreparedStatement(this){

            @Override
            protected PreparedStatement doPrepareStatement(String sql) throws SQLException {
                return ExtendedConnection.this.delegate.prepareStatement(sql);
            }
        };
        return new ExtendedPreparedStatement(this, delegatingPreparedStatement, sql, this.prop);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, final int resultSetType, final int resultSetConcurrency) throws SQLException {
        PreparedStatement delegatingPreparedStatement = null;
        delegatingPreparedStatement = this.prop.isFastDelegate() ? this.delegate.prepareStatement(sql, resultSetType, resultSetConcurrency) : new BasePreparedStatement(this){

            @Override
            protected PreparedStatement doPrepareStatement(String sql) throws SQLException {
                return ExtendedConnection.this.delegate.prepareStatement(sql, resultSetType, resultSetConcurrency);
            }
        };
        return new ExtendedPreparedStatement(this, delegatingPreparedStatement, sql, this.prop);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, final int resultSetType, final int resultSetConcurrency, final int resultSetHoldability) throws SQLException {
        PreparedStatement delegatingPreparedStatement = null;
        delegatingPreparedStatement = this.prop.isFastDelegate() ? this.delegate.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability) : new BasePreparedStatement(this){

            @Override
            protected PreparedStatement doPrepareStatement(String sql) throws SQLException {
                return ExtendedConnection.this.delegate.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
            }
        };
        return new ExtendedPreparedStatement(this, delegatingPreparedStatement, sql, this.prop);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, final int autoGeneratedKeys) throws SQLException {
        PreparedStatement delegatingPreparedStatement = null;
        delegatingPreparedStatement = this.prop.isFastDelegate() ? this.delegate.prepareStatement(sql, autoGeneratedKeys) : new BasePreparedStatement(this){

            @Override
            protected PreparedStatement doPrepareStatement(String sql) throws SQLException {
                return ExtendedConnection.this.delegate.prepareStatement(sql, autoGeneratedKeys);
            }
        };
        return new ExtendedPreparedStatement(this, delegatingPreparedStatement, sql, this.prop);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, final int[] columnIndexes) throws SQLException {
        PreparedStatement delegatingPreparedStatement = null;
        delegatingPreparedStatement = this.prop.isFastDelegate() ? this.delegate.prepareStatement(sql, columnIndexes) : new BasePreparedStatement(this){

            @Override
            protected PreparedStatement doPrepareStatement(String sql) throws SQLException {
                return ExtendedConnection.this.delegate.prepareStatement(sql, columnIndexes);
            }
        };
        return new ExtendedPreparedStatement(this, delegatingPreparedStatement, sql, this.prop);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, final String[] columnNames) throws SQLException {
        PreparedStatement delegatingPreparedStatement = null;
        delegatingPreparedStatement = this.prop.isFastDelegate() ? this.delegate.prepareStatement(sql, columnNames) : new BasePreparedStatement(this){

            @Override
            protected PreparedStatement doPrepareStatement(String sql) throws SQLException {
                return ExtendedConnection.this.delegate.prepareStatement(sql, columnNames);
            }
        };
        return new ExtendedPreparedStatement(this, delegatingPreparedStatement, sql, this.prop);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.delegate.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.delegate.prepareCall(sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        return this.delegate.getTypeMap();
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.delegate.setTypeMap(map);
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.delegate.setHoldability(holdability);
    }

    @Override
    public int getHoldability() throws SQLException {
        return this.delegate.getHoldability();
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        return this.delegate.setSavepoint();
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        return this.delegate.setSavepoint(name);
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.delegate.rollback();
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.delegate.releaseSavepoint(savepoint);
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        return this.delegate.prepareCall(sql);
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        return this.delegate.nativeSQL(sql);
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.delegate.setAutoCommit(autoCommit);
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return this.delegate.getAutoCommit();
    }

    @Override
    public void commit() throws SQLException {
        this.delegate.commit();
    }

    @Override
    public void rollback() throws SQLException {
        this.delegate.rollback();
    }

    @Override
    public void close() throws SQLException {
        this.delegate.close();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.delegate.isClosed();
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return this.delegate.getMetaData();
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.delegate.setReadOnly(readOnly);
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return this.delegate.isReadOnly();
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.delegate.setCatalog(catalog);
    }

    @Override
    public String getCatalog() throws SQLException {
        return this.delegate.getCatalog();
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.delegate.setTransactionIsolation(level);
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return this.delegate.getTransactionIsolation();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.delegate.getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.delegate.clearWarnings();
    }

    @Override
    public Clob createClob() throws SQLException {
        return this.delegate.createClob();
    }

    @Override
    public Blob createBlob() throws SQLException {
        return this.delegate.createBlob();
    }

    @Override
    public NClob createNClob() throws SQLException {
        return this.delegate.createNClob();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        return this.delegate.createSQLXML();
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        return this.delegate.isValid(timeout);
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        this.delegate.setClientInfo(name, value);
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        this.delegate.setClientInfo(properties);
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        return this.delegate.getClientInfo(name);
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        return this.delegate.getClientInfo();
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        return this.delegate.createArrayOf(typeName, elements);
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        return this.delegate.createStruct(typeName, attributes);
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        this.delegate.setSchema(schema);
    }

    @Override
    public String getSchema() throws SQLException {
        return this.delegate.getSchema();
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        this.delegate.abort(executor);
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        this.delegate.setNetworkTimeout(executor, milliseconds);
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        return this.delegate.getNetworkTimeout();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.delegate.unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.delegate.isWrapperFor(iface);
    }
}

