/*
 * Decompiled with CFR 0.152.
 */
package com.sofa.alipay.tracer.plugins.rest;

import com.alipay.common.tracer.core.reporter.stat.AbstractSofaTracerStatisticReporter;
import com.alipay.common.tracer.core.reporter.stat.model.StatKey;
import com.alipay.common.tracer.core.reporter.stat.model.StatMapKey;
import com.alipay.common.tracer.core.span.SofaTracerSpan;
import com.alipay.common.tracer.core.utils.TracerUtils;
import java.util.Map;

public class RestTemplateStatJsonReporter
extends AbstractSofaTracerStatisticReporter {
    public RestTemplateStatJsonReporter(String statTracerName, String rollingPolicy, String logReserveConfig) {
        super(statTracerName, rollingPolicy, logReserveConfig);
    }

    public void doReportStat(SofaTracerSpan sofaTracerSpan) {
        Map tagsWithStr = sofaTracerSpan.getTagsWithStr();
        StatMapKey statKey = new StatMapKey();
        statKey.addKey("local.app", (String)tagsWithStr.get("local.app"));
        statKey.addKey("request.url", (String)tagsWithStr.get("request.url"));
        statKey.addKey("method", (String)tagsWithStr.get("method"));
        String resultCode = (String)tagsWithStr.get("result.code");
        boolean success = this.isWebHttpClientSuccess(resultCode);
        statKey.setResult(success ? "Y" : "N");
        statKey.setLoadTest(TracerUtils.isLoadTest((SofaTracerSpan)sofaTracerSpan));
        statKey.setEnd(TracerUtils.getLoadTestMark((SofaTracerSpan)sofaTracerSpan));
        long duration = sofaTracerSpan.getEndTime() - sofaTracerSpan.getStartTime();
        long[] values = new long[]{1L, duration};
        this.addStat((StatKey)statKey, values);
    }
}

