/*
 * Decompiled with CFR 0.152.
 */
package com.sofa.alipay.tracer.plugins.rest;

import com.alipay.common.tracer.core.tracer.AbstractTracer;
import com.sofa.alipay.tracer.plugins.rest.RestTemplateTracer;
import com.sofa.alipay.tracer.plugins.rest.interceptor.AsyncRestTemplateRequestInterceptor;
import com.sofa.alipay.tracer.plugins.rest.interceptor.RestTemplateInterceptor;
import java.util.ArrayList;
import org.springframework.web.client.AsyncRestTemplate;
import org.springframework.web.client.RestTemplate;

public class SofaTracerRestTemplateBuilder {
    private static volatile AbstractTracer restTemplateTracer = null;

    public static RestTemplate buildRestTemplate() {
        RestTemplate restTemplate = new RestTemplate();
        ArrayList<RestTemplateInterceptor> interceptors = new ArrayList<RestTemplateInterceptor>();
        RestTemplateInterceptor restTemplateInterceptor = new RestTemplateInterceptor(SofaTracerRestTemplateBuilder.getRestTemplateTracer());
        interceptors.add(restTemplateInterceptor);
        restTemplate.setInterceptors(interceptors);
        return restTemplate;
    }

    @Deprecated
    public static AsyncRestTemplate buildAsyncRestTemplate() {
        AsyncRestTemplate asyncRestTemplate = new AsyncRestTemplate();
        ArrayList<AsyncRestTemplateRequestInterceptor> interceptors = new ArrayList<AsyncRestTemplateRequestInterceptor>();
        AsyncRestTemplateRequestInterceptor asyncRestTemplateInterceptor = new AsyncRestTemplateRequestInterceptor(SofaTracerRestTemplateBuilder.getRestTemplateTracer());
        interceptors.add(asyncRestTemplateInterceptor);
        asyncRestTemplate.setInterceptors(interceptors);
        return asyncRestTemplate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AbstractTracer getRestTemplateTracer() {
        if (restTemplateTracer != null) return restTemplateTracer;
        Class<RestTemplateTracer> clazz = RestTemplateTracer.class;
        synchronized (RestTemplateTracer.class) {
            if (restTemplateTracer != null) return restTemplateTracer;
            restTemplateTracer = new RestTemplateTracer();
            // ** MonitorExit[var0] (shouldn't be in output)
            return restTemplateTracer;
        }
    }
}

