/*
 * Decompiled with CFR 0.152.
 */
package com.sofa.alipay.tracer.plugins.rest.interceptor;

import com.alipay.common.tracer.core.SofaTracer;
import com.alipay.common.tracer.core.configuration.SofaTracerConfiguration;
import com.alipay.common.tracer.core.holder.SofaTraceContextHolder;
import com.alipay.common.tracer.core.registry.ExtendFormat;
import com.alipay.common.tracer.core.span.SofaTracerSpan;
import com.alipay.common.tracer.core.tracer.AbstractTracer;
import com.sofa.alipay.tracer.plugins.rest.RestTemplateRequestCarrier;
import io.opentracing.SpanContext;
import io.opentracing.tag.Tags;
import java.io.IOException;
import java.util.List;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.AsyncClientHttpRequestExecution;
import org.springframework.http.client.AsyncClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.util.concurrent.ListenableFuture;
import org.springframework.util.concurrent.ListenableFutureCallback;

public class AsyncRestTemplateRequestInterceptor
implements AsyncClientHttpRequestInterceptor {
    protected AbstractTracer restTemplateTracer;

    public AsyncRestTemplateRequestInterceptor(AbstractTracer restTemplateTracer) {
        this.restTemplateTracer = restTemplateTracer;
    }

    public ListenableFuture<ClientHttpResponse> intercept(HttpRequest request, byte[] body, AsyncClientHttpRequestExecution execution) throws IOException {
        SofaTracerSpan sofaTracerSpan = this.restTemplateTracer.clientSend(request.getMethod().name());
        this.appendRestTemplateRequestSpanTags(request, sofaTracerSpan);
        IOException exception = null;
        try {
            ListenableFuture result = execution.executeAsync(request, body);
            result.addCallback((ListenableFutureCallback)new SofaTraceListenableFutureCallback(this.restTemplateTracer, sofaTracerSpan));
            ListenableFuture listenableFuture = result;
            return listenableFuture;
        }
        catch (IOException e) {
            exception = e;
            throw e;
        }
        finally {
            if (exception != null) {
                SofaTracerSpan currentSpan = SofaTraceContextHolder.getSofaTraceContext().getCurrentSpan();
                currentSpan.setTag(Tags.ERROR.getKey(), exception.getMessage());
                this.restTemplateTracer.clientReceive(String.valueOf(500));
            } else {
                SofaTraceContextHolder.getSofaTraceContext().pop();
                if (sofaTracerSpan != null && sofaTracerSpan.getParentSofaTracerSpan() != null) {
                    SofaTraceContextHolder.getSofaTraceContext().push(sofaTracerSpan.getParentSofaTracerSpan());
                }
            }
        }
    }

    private void appendRestTemplateRequestSpanTags(HttpRequest request, SofaTracerSpan sofaTracerSpan) {
        if (sofaTracerSpan == null) {
            return;
        }
        String appName = SofaTracerConfiguration.getProperty((String)"spring.application.name", (String)"");
        String methodName = request.getMethod().name();
        sofaTracerSpan.setTag("local.app", appName == null ? "" : appName);
        sofaTracerSpan.setTag("remote.app", "");
        sofaTracerSpan.setTag("request.url", request.getURI().toString());
        sofaTracerSpan.setTag("method", methodName);
        HttpHeaders headers = request.getHeaders();
        if (headers != null && headers.containsKey((Object)"Content-Length")) {
            List contentLengthList = headers.get((Object)"Content-Length");
            if (contentLengthList != null && !contentLengthList.isEmpty()) {
                sofaTracerSpan.setTag("req.size.bytes", (String)contentLengthList.get(0));
            }
        } else {
            sofaTracerSpan.setTag("req.size.bytes", String.valueOf(-1));
        }
        this.injectCarrier(request, sofaTracerSpan);
    }

    public void injectCarrier(HttpRequest request, SofaTracerSpan currentSpan) {
        SofaTracer sofaTracer = this.restTemplateTracer.getSofaTracer();
        sofaTracer.inject((SpanContext)currentSpan.getSofaTracerSpanContext(), ExtendFormat.Builtin.B3_HTTP_HEADERS, (Object)new RestTemplateRequestCarrier(request));
    }

    static final class SofaTraceListenableFutureCallback
    implements ListenableFutureCallback<ClientHttpResponse> {
        final AbstractTracer restTemplateTracer;
        final SofaTracerSpan sofaTracerSpan;

        SofaTraceListenableFutureCallback(AbstractTracer restTemplateTracer, SofaTracerSpan sofaTracerSpan) {
            this.restTemplateTracer = restTemplateTracer;
            this.sofaTracerSpan = sofaTracerSpan;
        }

        public void onFailure(Throwable throwable) {
            this.restTemplateTracer.clientReceiveTagFinish(this.sofaTracerSpan, String.valueOf(500));
        }

        public void onSuccess(ClientHttpResponse response) {
            try {
                int statusCode = response.getStatusCode().value();
                this.appendRestTemplateResponseSpanTags(response, this.sofaTracerSpan);
                this.restTemplateTracer.clientReceiveTagFinish(this.sofaTracerSpan, String.valueOf(statusCode));
            }
            catch (IOException e) {
                this.restTemplateTracer.clientReceiveTagFinish(this.sofaTracerSpan, String.valueOf(500));
            }
        }

        private void appendRestTemplateResponseSpanTags(ClientHttpResponse response, SofaTracerSpan sofaTracerSpan) {
            if (sofaTracerSpan == null) {
                return;
            }
            HttpHeaders headers = response.getHeaders();
            List contentLengthList = headers.get((Object)"Content-Length");
            if (headers != null && contentLengthList != null && !contentLengthList.isEmpty()) {
                String len = (String)contentLengthList.get(0);
                sofaTracerSpan.setTag("resp.size.bytes", len);
            }
            sofaTracerSpan.setTag("current.thread.name", Thread.currentThread().getName());
        }
    }
}

