/*
 * Decompiled with CFR 0.152.
 */
package com.sofa.alipay.tracer.plugins.rest.interceptor;

import com.alipay.common.tracer.core.SofaTracer;
import com.alipay.common.tracer.core.configuration.SofaTracerConfiguration;
import com.alipay.common.tracer.core.context.trace.SofaTraceContext;
import com.alipay.common.tracer.core.holder.SofaTraceContextHolder;
import com.alipay.common.tracer.core.registry.ExtendFormat;
import com.alipay.common.tracer.core.span.SofaTracerSpan;
import com.alipay.common.tracer.core.tracer.AbstractTracer;
import com.sofa.alipay.tracer.plugins.rest.RestTemplateRequestCarrier;
import io.opentracing.SpanContext;
import io.opentracing.tag.Tags;
import java.io.IOException;
import java.util.List;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;

public class RestTemplateInterceptor
implements ClientHttpRequestInterceptor {
    protected AbstractTracer restTemplateTracer;

    public RestTemplateInterceptor(AbstractTracer restTemplateTracer) {
        this.restTemplateTracer = restTemplateTracer;
    }

    public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        SofaTracerSpan sofaTracerSpan = this.restTemplateTracer.clientSend(request.getMethod().name());
        this.appendRestTemplateRequestSpanTags(request, sofaTracerSpan);
        ClientHttpResponse response = null;
        IOException t = null;
        try {
            ClientHttpResponse clientHttpResponse = response = execution.execute(request, body);
            return clientHttpResponse;
        }
        catch (IOException e) {
            t = e;
            throw e;
        }
        finally {
            SofaTraceContext sofaTraceContext = SofaTraceContextHolder.getSofaTraceContext();
            SofaTracerSpan currentSpan = sofaTraceContext.getCurrentSpan();
            String resultCode = "99";
            if (t != null) {
                currentSpan.setTag(Tags.ERROR.getKey(), t.getMessage());
                sofaTracerSpan.setTag("current.thread.name", Thread.currentThread().getName());
            }
            if (response != null) {
                this.appendRestTemplateResponseSpanTags(response, currentSpan);
                resultCode = String.valueOf(response.getStatusCode().value());
            }
            this.restTemplateTracer.clientReceive(resultCode);
        }
    }

    private void appendRestTemplateResponseSpanTags(ClientHttpResponse response, SofaTracerSpan sofaTracerSpan) {
        if (sofaTracerSpan == null) {
            return;
        }
        HttpHeaders headers = response.getHeaders();
        if (headers != null && headers.get((Object)"Content-Length") != null && !headers.get((Object)"Content-Length").isEmpty()) {
            List contentLengthList = headers.get((Object)"Content-Length");
            String len = (String)contentLengthList.get(0);
            sofaTracerSpan.setTag("resp.size.bytes", (Number)Long.valueOf(len));
        }
        sofaTracerSpan.setTag("current.thread.name", Thread.currentThread().getName());
    }

    private void appendRestTemplateRequestSpanTags(HttpRequest request, SofaTracerSpan sofaTracerSpan) {
        if (sofaTracerSpan == null) {
            return;
        }
        String appName = SofaTracerConfiguration.getProperty((String)"spring.application.name", (String)"");
        String methodName = request.getMethod().name();
        sofaTracerSpan.setTag("local.app", appName == null ? "" : appName);
        sofaTracerSpan.setTag("request.url", request.getURI().toString());
        sofaTracerSpan.setTag("method", methodName);
        HttpHeaders headers = request.getHeaders();
        if (headers != null && headers.containsKey((Object)"Content-Length")) {
            List contentLengthList = headers.get((Object)"Content-Length");
            if (contentLengthList != null && !contentLengthList.isEmpty()) {
                sofaTracerSpan.setTag("req.size.bytes", (Number)Long.valueOf((String)contentLengthList.get(0)));
            }
        } else {
            sofaTracerSpan.setTag("req.size.bytes", String.valueOf(-1));
        }
        this.injectCarrier(request, sofaTracerSpan);
    }

    public void injectCarrier(HttpRequest request, SofaTracerSpan currentSpan) {
        SofaTracer sofaTracer = this.restTemplateTracer.getSofaTracer();
        sofaTracer.inject((SpanContext)currentSpan.getSofaTracerSpanContext(), ExtendFormat.Builtin.B3_HTTP_HEADERS, (Object)new RestTemplateRequestCarrier(request));
    }
}

