/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.tables.implementation;

import com.azure.data.tables.implementation.ConnectionSettings;
import java.util.Objects;

public final class StorageAuthenticationSettings {
    private final Type type;
    private final String sasToken;
    private final Account account;

    public Type getType() {
        return this.type;
    }

    public String getSasToken() {
        return this.sasToken;
    }

    public Account getAccount() {
        return this.account;
    }

    public static StorageAuthenticationSettings fromConnectionSettings(ConnectionSettings settings) {
        String accountName = settings.getSettingValue("AccountName");
        String accountKey = settings.getSettingValue("AccountKey");
        String sasSignature = settings.getSettingValue("SharedAccessSignature");
        if (accountName != null && accountKey != null && sasSignature == null) {
            return new StorageAuthenticationSettings(new Account(accountName, accountKey));
        }
        if (accountKey == null && sasSignature != null) {
            return new StorageAuthenticationSettings(sasSignature);
        }
        return new StorageAuthenticationSettings();
    }

    public static StorageAuthenticationSettings forEmulator() {
        return new StorageAuthenticationSettings(new Account("devstoreaccount1", "Eby8vdM02xNOcqFlqUwJPLlmEtlCDXJ1OUzFT50uSRZ6IFsuFq2UVErCz4I6tq/K1SZFPTOtr/KBHBeksoGMGw=="));
    }

    private StorageAuthenticationSettings() {
        this.type = Type.NONE;
        this.account = null;
        this.sasToken = null;
    }

    private StorageAuthenticationSettings(String sasToken) {
        this.type = Type.SAS_TOKEN;
        this.sasToken = Objects.requireNonNull(sasToken);
        this.account = null;
    }

    private StorageAuthenticationSettings(Account account) {
        this.type = Type.ACCOUNT_NAME_KEY;
        this.account = Objects.requireNonNull(account);
        this.sasToken = null;
    }

    public static final class Account {
        private final String name;
        private final String accessKey;

        private Account(String name, String accessKey) {
            this.name = Objects.requireNonNull(name);
            this.accessKey = Objects.requireNonNull(accessKey);
        }

        public String getName() {
            return this.name;
        }

        public String getAccessKey() {
            return this.accessKey;
        }
    }

    public static enum Type {
        NONE,
        ACCOUNT_NAME_KEY,
        SAS_TOKEN;

    }
}

