/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.tables.implementation;

import com.azure.core.http.HttpHeader;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpMethod;
import com.azure.core.http.HttpRequest;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerEncoding;
import com.azure.data.tables.implementation.ModelHelper;
import com.azure.data.tables.implementation.TablesJacksonSerializer;
import com.azure.data.tables.implementation.models.MultipartPart;
import com.azure.data.tables.implementation.models.TableServiceError;
import com.azure.data.tables.implementation.models.TransactionalBatchChangeSet;
import com.azure.data.tables.implementation.models.TransactionalBatchSubRequest;
import com.azure.data.tables.models.TableTransactionActionResponse;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import reactor.core.publisher.Flux;

public class TablesMultipartSerializer
extends TablesJacksonSerializer {
    private static final String BOUNDARY_DELIMETER = "--";
    private final ClientLogger logger = new ClientLogger(TablesMultipartSerializer.class);

    @Override
    public void serialize(Object object, SerializerEncoding encoding, OutputStream outputStream) throws IOException {
        if (object instanceof MultipartPart) {
            this.writeMultipartPart(object, encoding, outputStream);
        } else if (object instanceof TransactionalBatchSubRequest) {
            this.writeRequest(object, outputStream);
        } else {
            super.serialize(object, encoding, outputStream);
        }
    }

    @Override
    public String serialize(Object object, SerializerEncoding encoding) throws IOException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        this.serialize(object, encoding, stream);
        return stream.toString(StandardCharsets.UTF_8.name());
    }

    @Override
    public byte[] serializeToBytes(Object object, SerializerEncoding encoding) throws IOException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        this.serialize(object, encoding, stream);
        return stream.toByteArray();
    }

    private void writeMultipartPart(Object object, SerializerEncoding encoding, OutputStream os) throws IOException {
        MultipartPart part = (MultipartPart)object;
        if (part instanceof TransactionalBatchChangeSet) {
            this.write("Content-Type: " + part.getContentType() + "\r\n\r\n", os);
        }
        for (Object content : part.getContents()) {
            this.write(BOUNDARY_DELIMETER + part.getBoundary() + "\r\n", os);
            this.serialize(content, encoding, os);
            this.write("\r\n", os);
        }
        this.write(BOUNDARY_DELIMETER + part.getBoundary() + BOUNDARY_DELIMETER + "\r\n", os);
    }

    private void writeRequest(Object object, OutputStream os) throws IOException {
        byte[] bodyBytes;
        HttpRequest request = ((TransactionalBatchSubRequest)object).getHttpRequest();
        String method = request.getHttpMethod() == HttpMethod.PATCH ? "MERGE" : request.getHttpMethod().toString();
        this.write("Content-Type: application/http\r\n", os);
        this.write("Content-Transfer-Encoding: binary\r\n\r\n", os);
        this.write(method + " " + request.getUrl().toString() + " HTTP/1.1\r\n", os);
        for (HttpHeader header : request.getHeaders()) {
            if ("x-ms-version".equalsIgnoreCase(header.getName())) continue;
            this.write(header.getName() + ": " + header.getValue() + "\r\n", os);
        }
        this.write("\r\n", os);
        if (request.getBody() != null && (bodyBytes = (byte[])FluxUtil.collectBytesInByteBufferStream((Flux)request.getBody()).block()) != null) {
            os.write(bodyBytes);
        }
    }

    private void write(String s, OutputStream os) throws IOException {
        os.write(s.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public <U> U deserialize(String value, Type type, SerializerEncoding serializerEncoding) throws IOException {
        return this.deserialize(value.getBytes(StandardCharsets.UTF_8), type, serializerEncoding);
    }

    @Override
    public <U> U deserialize(byte[] bytes, Type type, SerializerEncoding encoding) throws IOException {
        if (type == TableTransactionActionResponse.class) {
            return this.deserialize(new ByteArrayInputStream(bytes), type, encoding);
        }
        return super.deserialize(bytes, type, encoding);
    }

    @Override
    public <U> U deserialize(InputStream inputStream, Type type, SerializerEncoding serializerEncoding) throws IOException {
        if (type == TableTransactionActionResponse[].class) {
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
            String line = reader.readLine();
            if (line == null || !line.startsWith("--batchresponse_")) {
                throw this.logger.logExceptionAsError((RuntimeException)new IllegalStateException("Invalid multipart response."));
            }
            TableTransactionActionResponseBuilder responseParams = null;
            boolean foundBody = false;
            String body = null;
            ArrayList<TableTransactionActionResponse> responses = new ArrayList<TableTransactionActionResponse>();
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("--changesetresponse_")) {
                    if (responseParams != null) {
                        if (body != null && !body.isEmpty()) {
                            try {
                                responseParams.setValue(this.deserialize(body, (Type)((Object)TableServiceError.class), serializerEncoding));
                            }
                            catch (IOException e) {
                                this.logger.logThrowableAsWarning((Throwable)new IOException("Unable to deserialize sub-response body.", e));
                                responseParams.setValue(body);
                            }
                        }
                        responses.add(responseParams.build());
                    }
                    responseParams = null;
                    foundBody = false;
                    body = null;
                    continue;
                }
                if (responseParams == null && line.startsWith("HTTP/1.1")) {
                    responseParams = new TableTransactionActionResponseBuilder();
                    responseParams.setStatusCode(Integer.parseInt(line.substring(9, 12)));
                    continue;
                }
                if (responseParams != null && !foundBody) {
                    if (line.isEmpty()) {
                        foundBody = true;
                        continue;
                    }
                    String[] header = line.split(":", 2);
                    responseParams.putHeader(header[0].trim(), header[1].trim());
                    continue;
                }
                if (responseParams == null || line.isEmpty()) continue;
                body = (body == null ? line : body + line) + "\r\n";
            }
            return (U)responses.toArray(new TableTransactionActionResponse[0]);
        }
        return super.deserialize(inputStream, type, serializerEncoding);
    }

    private static class TableTransactionActionResponseBuilder {
        private int statusCode;
        private Object value;
        private final HttpHeaders headers = new HttpHeaders();

        private TableTransactionActionResponseBuilder() {
        }

        TableTransactionActionResponse build() {
            TableTransactionActionResponse response = ModelHelper.createTableTransactionActionResponse(this.statusCode, this.value);
            this.headers.forEach(h -> response.getHeaders().set(h.getName(), h.getValue()));
            return response;
        }

        void setStatusCode(int statusCode) {
            this.statusCode = statusCode;
        }

        void setValue(Object value) {
            this.value = value;
        }

        void putHeader(String name, String value) {
            this.headers.set(name, value);
        }
    }
}

