/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.servicebus;

import com.azure.core.amqp.exception.AmqpErrorCondition;
import com.azure.core.amqp.exception.AmqpException;
import com.azure.core.amqp.implementation.ErrorContextProvider;
import com.azure.core.amqp.implementation.MessageSerializer;
import com.azure.core.amqp.implementation.TracerProvider;
import com.azure.core.util.logging.ClientLogger;
import com.azure.messaging.servicebus.ServiceBusErrorSource;
import com.azure.messaging.servicebus.ServiceBusException;
import com.azure.messaging.servicebus.ServiceBusMessage;
import com.azure.messaging.servicebus.implementation.MessageUtils;
import java.nio.BufferOverflowException;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.apache.qpid.proton.message.Message;

public final class ServiceBusMessageBatch {
    private final ClientLogger logger = new ClientLogger(ServiceBusMessageBatch.class);
    private final Object lock = new Object();
    private final int maxMessageSize;
    private final ErrorContextProvider contextProvider;
    private final MessageSerializer serializer;
    private final List<ServiceBusMessage> serviceBusMessageList;
    private final byte[] eventBytes;
    private int sizeInBytes;
    private final TracerProvider tracerProvider;
    private final String entityPath;
    private final String hostname;

    ServiceBusMessageBatch(int maxMessageSize, ErrorContextProvider contextProvider, TracerProvider tracerProvider, MessageSerializer serializer, String entityPath, String hostname) {
        this.maxMessageSize = maxMessageSize;
        this.contextProvider = contextProvider;
        this.serializer = serializer;
        this.serviceBusMessageList = new LinkedList<ServiceBusMessage>();
        this.sizeInBytes = maxMessageSize / 65536 * 1024;
        this.eventBytes = new byte[maxMessageSize];
        this.tracerProvider = tracerProvider;
        this.entityPath = entityPath;
        this.hostname = hostname;
    }

    public int getCount() {
        return this.serviceBusMessageList.size();
    }

    public int getMaxSizeInBytes() {
        return this.maxMessageSize;
    }

    public int getSizeInBytes() {
        return this.sizeInBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryAddMessage(ServiceBusMessage serviceBusMessage) {
        int size;
        if (serviceBusMessage == null) {
            throw this.logger.logExceptionAsWarning((RuntimeException)new NullPointerException("'serviceBusMessage' cannot be null"));
        }
        ServiceBusMessage serviceBusMessageUpdated = this.tracerProvider.isEnabled() ? MessageUtils.traceMessageSpan(serviceBusMessage, serviceBusMessage.getContext(), this.hostname, this.entityPath, this.tracerProvider) : serviceBusMessage;
        try {
            size = this.getSize(serviceBusMessageUpdated, this.serviceBusMessageList.isEmpty());
        }
        catch (BufferOverflowException exception) {
            ServiceBusException ex = new ServiceBusException((Throwable)new AmqpException(false, AmqpErrorCondition.LINK_PAYLOAD_SIZE_EXCEEDED, String.format(Locale.US, "Size of the payload exceeded maximum message size: %s kb", this.maxMessageSize / 1024), this.contextProvider.getErrorContext()), ServiceBusErrorSource.SEND);
            throw this.logger.logExceptionAsWarning((RuntimeException)((Object)ex));
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.sizeInBytes + size > this.maxMessageSize) {
                return false;
            }
            this.sizeInBytes += size;
        }
        this.serviceBusMessageList.add(serviceBusMessageUpdated);
        return true;
    }

    List<ServiceBusMessage> getMessages() {
        return this.serviceBusMessageList;
    }

    private int getSize(ServiceBusMessage serviceBusMessage, boolean isFirst) {
        Objects.requireNonNull(serviceBusMessage, "'serviceBusMessage' cannot be null.");
        Message amqpMessage = this.serializer.serialize((Object)serviceBusMessage);
        int eventSize = amqpMessage.encode(this.eventBytes, 0, this.maxMessageSize);
        eventSize += 16;
        if (isFirst) {
            amqpMessage.setBody(null);
            amqpMessage.setApplicationProperties(null);
            amqpMessage.setProperties(null);
            amqpMessage.setDeliveryAnnotations(null);
            eventSize += amqpMessage.encode(this.eventBytes, 0, this.maxMessageSize);
        }
        return eventSize;
    }
}

