/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.servicebus;

import com.azure.core.util.IterableStream;
import com.azure.messaging.servicebus.ServiceBusMessage;
import com.azure.messaging.servicebus.ServiceBusMessageBatch;
import com.azure.messaging.servicebus.ServiceBusSenderAsyncClient;
import com.azure.messaging.servicebus.ServiceBusTransactionContext;
import com.azure.messaging.servicebus.models.CreateMessageBatchOptions;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.Objects;

public final class ServiceBusSenderClient
implements AutoCloseable {
    private final ServiceBusSenderAsyncClient asyncClient;
    private final Duration tryTimeout;

    ServiceBusSenderClient(ServiceBusSenderAsyncClient asyncClient, Duration tryTimeout) {
        this.asyncClient = Objects.requireNonNull(asyncClient, "'asyncClient' cannot be null.");
        this.tryTimeout = Objects.requireNonNull(tryTimeout, "'tryTimeout' cannot be null.");
    }

    public void cancelScheduledMessage(long sequenceNumber) {
        this.asyncClient.cancelScheduledMessage(sequenceNumber).block(this.tryTimeout);
    }

    public void cancelScheduledMessages(Iterable<Long> sequenceNumbers) {
        this.asyncClient.cancelScheduledMessages(sequenceNumbers).block(this.tryTimeout);
    }

    public ServiceBusMessageBatch createMessageBatch() {
        return (ServiceBusMessageBatch)this.asyncClient.createMessageBatch().block(this.tryTimeout);
    }

    public ServiceBusMessageBatch createMessageBatch(CreateMessageBatchOptions options) {
        Objects.requireNonNull(options, "'options' cannot be null.");
        return (ServiceBusMessageBatch)this.asyncClient.createMessageBatch(options).block(this.tryTimeout);
    }

    public String getEntityPath() {
        return this.asyncClient.getEntityPath();
    }

    public String getFullyQualifiedNamespace() {
        return this.asyncClient.getFullyQualifiedNamespace();
    }

    public void sendMessage(ServiceBusMessage message) {
        Objects.requireNonNull(message, "'message' cannot be null.");
        this.asyncClient.sendMessage(message).block(this.tryTimeout);
    }

    public void sendMessages(Iterable<ServiceBusMessage> messages) {
        this.asyncClient.sendMessages(messages).block(this.tryTimeout);
    }

    public void sendMessages(ServiceBusMessageBatch batch) {
        Objects.requireNonNull(batch, "'batch' cannot be null.");
        this.asyncClient.sendMessages(batch).block(this.tryTimeout);
    }

    public void sendMessage(ServiceBusMessage message, ServiceBusTransactionContext transactionContext) {
        this.asyncClient.sendMessage(message, transactionContext).block(this.tryTimeout);
    }

    public void sendMessages(Iterable<ServiceBusMessage> messages, ServiceBusTransactionContext transactionContext) {
        this.asyncClient.sendMessages(messages, transactionContext).block(this.tryTimeout);
    }

    public void sendMessages(ServiceBusMessageBatch batch, ServiceBusTransactionContext transactionContext) {
        this.asyncClient.sendMessages(batch, transactionContext).block(this.tryTimeout);
    }

    public Long scheduleMessage(ServiceBusMessage message, OffsetDateTime scheduledEnqueueTime) {
        return (Long)this.asyncClient.scheduleMessage(message, scheduledEnqueueTime).block(this.tryTimeout);
    }

    public Long scheduleMessage(ServiceBusMessage message, OffsetDateTime scheduledEnqueueTime, ServiceBusTransactionContext transactionContext) {
        return (Long)this.asyncClient.scheduleMessage(message, scheduledEnqueueTime, transactionContext).block(this.tryTimeout);
    }

    public Iterable<Long> scheduleMessages(Iterable<ServiceBusMessage> messages, OffsetDateTime scheduledEnqueueTime) {
        return new IterableStream(this.asyncClient.scheduleMessages(messages, scheduledEnqueueTime));
    }

    public Iterable<Long> scheduleMessages(Iterable<ServiceBusMessage> messages, OffsetDateTime scheduledEnqueueTime, ServiceBusTransactionContext transactionContext) {
        return new IterableStream(this.asyncClient.scheduleMessages(messages, scheduledEnqueueTime, transactionContext));
    }

    public ServiceBusTransactionContext createTransaction() {
        return (ServiceBusTransactionContext)this.asyncClient.createTransaction().block(this.tryTimeout);
    }

    public void commitTransaction(ServiceBusTransactionContext transactionContext) {
        this.asyncClient.commitTransaction(transactionContext).block(this.tryTimeout);
    }

    public void rollbackTransaction(ServiceBusTransactionContext transactionContext) {
        this.asyncClient.rollbackTransaction(transactionContext).block(this.tryTimeout);
    }

    @Override
    public void close() {
        this.asyncClient.close();
    }
}

