/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.servicebus;

import com.azure.core.amqp.implementation.MessageSerializer;
import com.azure.core.amqp.implementation.TracerProvider;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.messaging.servicebus.ReceiverOptions;
import com.azure.messaging.servicebus.ServiceBusReceiverAsyncClient;
import com.azure.messaging.servicebus.ServiceBusSessionManager;
import com.azure.messaging.servicebus.implementation.MessagingEntityType;
import com.azure.messaging.servicebus.implementation.ServiceBusConnectionProcessor;
import com.azure.messaging.servicebus.implementation.ServiceBusConstants;
import com.azure.messaging.servicebus.implementation.ServiceBusReceiveLink;
import java.util.Objects;
import reactor.core.publisher.Mono;

public final class ServiceBusSessionReceiverAsyncClient
implements AutoCloseable {
    private final String fullyQualifiedNamespace;
    private final String entityPath;
    private final MessagingEntityType entityType;
    private final ReceiverOptions receiverOptions;
    private final ServiceBusConnectionProcessor connectionProcessor;
    private final TracerProvider tracerProvider;
    private final MessageSerializer messageSerializer;
    private final Runnable onClientClose;
    private final ServiceBusSessionManager unNamedSessionManager;
    private final ClientLogger logger = new ClientLogger(ServiceBusSessionReceiverAsyncClient.class);

    ServiceBusSessionReceiverAsyncClient(String fullyQualifiedNamespace, String entityPath, MessagingEntityType entityType, ReceiverOptions receiverOptions, ServiceBusConnectionProcessor connectionProcessor, TracerProvider tracerProvider, MessageSerializer messageSerializer, Runnable onClientClose) {
        this.fullyQualifiedNamespace = Objects.requireNonNull(fullyQualifiedNamespace, "'fullyQualifiedNamespace' cannot be null.");
        this.entityPath = Objects.requireNonNull(entityPath, "'entityPath' cannot be null.");
        this.entityType = Objects.requireNonNull(entityType, "'entityType' cannot be null.");
        this.receiverOptions = Objects.requireNonNull(receiverOptions, "'receiveOptions cannot be null.'");
        this.connectionProcessor = Objects.requireNonNull(connectionProcessor, "'connectionProcessor' cannot be null.");
        this.tracerProvider = Objects.requireNonNull(tracerProvider, "'tracerProvider' cannot be null.");
        this.messageSerializer = Objects.requireNonNull(messageSerializer, "'messageSerializer' cannot be null.");
        this.onClientClose = Objects.requireNonNull(onClientClose, "'onClientClose' cannot be null.");
        this.unNamedSessionManager = new ServiceBusSessionManager(entityPath, entityType, connectionProcessor, tracerProvider, messageSerializer, receiverOptions);
    }

    public Mono<ServiceBusReceiverAsyncClient> acceptNextSession() {
        return this.unNamedSessionManager.getActiveLink().flatMap(receiveLink -> receiveLink.getSessionId().map(sessionId -> {
            ReceiverOptions newReceiverOptions = new ReceiverOptions(this.receiverOptions.getReceiveMode(), this.receiverOptions.getPrefetchCount(), this.receiverOptions.getMaxLockRenewDuration(), this.receiverOptions.isEnableAutoComplete(), (String)sessionId, null);
            ServiceBusSessionManager sessionSpecificManager = new ServiceBusSessionManager(this.entityPath, this.entityType, this.connectionProcessor, this.tracerProvider, this.messageSerializer, newReceiverOptions, (ServiceBusReceiveLink)receiveLink);
            return new ServiceBusReceiverAsyncClient(this.fullyQualifiedNamespace, this.entityPath, this.entityType, newReceiverOptions, this.connectionProcessor, ServiceBusConstants.OPERATION_TIMEOUT, this.tracerProvider, this.messageSerializer, () -> {}, sessionSpecificManager);
        }));
    }

    public Mono<ServiceBusReceiverAsyncClient> acceptSession(String sessionId) {
        if (sessionId == null) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new NullPointerException("'sessionId' cannot be null"));
        }
        if (CoreUtils.isNullOrEmpty((CharSequence)sessionId)) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new IllegalArgumentException("'sessionId' cannot be empty"));
        }
        ReceiverOptions newReceiverOptions = new ReceiverOptions(this.receiverOptions.getReceiveMode(), this.receiverOptions.getPrefetchCount(), this.receiverOptions.getMaxLockRenewDuration(), this.receiverOptions.isEnableAutoComplete(), sessionId, null);
        ServiceBusSessionManager sessionSpecificManager = new ServiceBusSessionManager(this.entityPath, this.entityType, this.connectionProcessor, this.tracerProvider, this.messageSerializer, newReceiverOptions);
        return sessionSpecificManager.getActiveLink().map(receiveLink -> new ServiceBusReceiverAsyncClient(this.fullyQualifiedNamespace, this.entityPath, this.entityType, newReceiverOptions, this.connectionProcessor, ServiceBusConstants.OPERATION_TIMEOUT, this.tracerProvider, this.messageSerializer, () -> {}, sessionSpecificManager));
    }

    @Override
    public void close() {
        this.onClientClose.run();
    }
}

