/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.servicebus.administration;

import com.azure.core.amqp.implementation.ConnectionStringProperties;
import com.azure.core.annotation.ServiceClientBuilder;
import com.azure.core.credential.TokenCredential;
import com.azure.core.exception.AzureException;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.AddHeadersFromContextPolicy;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpLoggingPolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.HttpPolicyProviders;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.util.ClientOptions;
import com.azure.core.util.Configuration;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.messaging.servicebus.ServiceBusServiceVersion;
import com.azure.messaging.servicebus.administration.ServiceBusAdministrationAsyncClient;
import com.azure.messaging.servicebus.administration.ServiceBusAdministrationClient;
import com.azure.messaging.servicebus.implementation.ServiceBusConstants;
import com.azure.messaging.servicebus.implementation.ServiceBusManagementClientImpl;
import com.azure.messaging.servicebus.implementation.ServiceBusManagementClientImplBuilder;
import com.azure.messaging.servicebus.implementation.ServiceBusManagementSerializer;
import com.azure.messaging.servicebus.implementation.ServiceBusSharedKeyCredential;
import com.azure.messaging.servicebus.implementation.ServiceBusTokenCredentialHttpPolicy;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@ServiceClientBuilder(serviceClients={ServiceBusAdministrationClient.class, ServiceBusAdministrationAsyncClient.class})
public final class ServiceBusAdministrationClientBuilder {
    private final ClientLogger logger = new ClientLogger(ServiceBusAdministrationClientBuilder.class);
    private final ServiceBusManagementSerializer serializer = new ServiceBusManagementSerializer();
    private final List<HttpPipelinePolicy> userPolicies = new ArrayList<HttpPipelinePolicy>();
    private final Map<String, String> properties = CoreUtils.getProperties((String)"azure-messaging-servicebus.properties");
    private Configuration configuration;
    private String endpoint;
    private HttpClient httpClient;
    private HttpLogOptions httpLogOptions = new HttpLogOptions();
    private HttpPipeline pipeline;
    private HttpPipelinePolicy retryPolicy;
    private TokenCredential tokenCredential;
    private ServiceBusServiceVersion serviceVersion;
    private ClientOptions clientOptions;

    public ServiceBusAdministrationAsyncClient buildAsyncClient() {
        if (this.endpoint == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new NullPointerException("'endpoint' cannot be null."));
        }
        ServiceBusServiceVersion apiVersion = this.serviceVersion == null ? ServiceBusServiceVersion.getLatest() : this.serviceVersion;
        HttpPipeline httpPipeline = this.createPipeline();
        ServiceBusManagementClientImpl client = new ServiceBusManagementClientImplBuilder().pipeline(httpPipeline).serializerAdapter(this.serializer).endpoint(this.endpoint).apiVersion(apiVersion.getVersion()).buildClient();
        return new ServiceBusAdministrationAsyncClient(client, this.serializer);
    }

    public ServiceBusAdministrationClient buildClient() {
        return new ServiceBusAdministrationClient(this.buildAsyncClient());
    }

    public ServiceBusAdministrationClientBuilder addPolicy(HttpPipelinePolicy policy) {
        Objects.requireNonNull(policy);
        this.userPolicies.add(policy);
        return this;
    }

    public ServiceBusAdministrationClientBuilder endpoint(String endpoint) {
        URL url;
        try {
            url = new URL(Objects.requireNonNull(endpoint, "'endpoint' cannot be null."));
        }
        catch (MalformedURLException ex) {
            throw this.logger.logExceptionAsWarning((RuntimeException)new IllegalArgumentException("'endpoint' must be a valid URL"));
        }
        this.endpoint = url.getHost();
        return this;
    }

    public ServiceBusAdministrationClientBuilder configuration(Configuration configuration) {
        this.configuration = configuration;
        return this;
    }

    public ServiceBusAdministrationClientBuilder connectionString(String connectionString) {
        ServiceBusSharedKeyCredential tokenCredential;
        Objects.requireNonNull(connectionString, "'connectionString' cannot be null.");
        ConnectionStringProperties properties = new ConnectionStringProperties(connectionString);
        try {
            tokenCredential = new ServiceBusSharedKeyCredential(properties.getSharedAccessKeyName(), properties.getSharedAccessKey(), ServiceBusConstants.TOKEN_VALIDITY);
        }
        catch (Exception e) {
            throw this.logger.logExceptionAsError((RuntimeException)new AzureException("Could not create the ServiceBusSharedKeyCredential.", (Throwable)e));
        }
        this.endpoint = properties.getEndpoint().getHost();
        if (properties.getEntityPath() != null && !properties.getEntityPath().isEmpty()) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("'connectionString' cannot contain an EntityPath. It should be a namespace connection string."));
        }
        return this.credential(properties.getEndpoint().getHost(), tokenCredential);
    }

    public ServiceBusAdministrationClientBuilder credential(String fullyQualifiedNamespace, TokenCredential credential) {
        this.endpoint = Objects.requireNonNull(fullyQualifiedNamespace, "'fullyQualifiedNamespace' cannot be null.");
        this.tokenCredential = Objects.requireNonNull(credential, "'credential' cannot be null.");
        if (CoreUtils.isNullOrEmpty((CharSequence)fullyQualifiedNamespace)) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("'fullyQualifiedNamespace' cannot be an empty string."));
        }
        return this;
    }

    public ServiceBusAdministrationClientBuilder httpClient(HttpClient client) {
        if (this.httpClient != null && client == null) {
            this.logger.info("HttpClient is being set to 'null' when it was previously configured.");
        }
        this.httpClient = client;
        return this;
    }

    public ServiceBusAdministrationClientBuilder httpLogOptions(HttpLogOptions logOptions) {
        this.httpLogOptions = logOptions;
        return this;
    }

    public ServiceBusAdministrationClientBuilder clientOptions(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        return this;
    }

    public ServiceBusAdministrationClientBuilder pipeline(HttpPipeline pipeline) {
        if (this.pipeline != null && pipeline == null) {
            this.logger.info("HttpPipeline is being set to 'null' when it was previously configured.");
        }
        this.pipeline = pipeline;
        return this;
    }

    public ServiceBusAdministrationClientBuilder retryPolicy(HttpPipelinePolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
        return this;
    }

    public ServiceBusAdministrationClientBuilder serviceVersion(ServiceBusServiceVersion serviceVersion) {
        this.serviceVersion = serviceVersion;
        return this;
    }

    private HttpPipeline createPipeline() {
        if (this.pipeline != null) {
            return this.pipeline;
        }
        Configuration buildConfiguration = this.configuration == null ? Configuration.getGlobalConfiguration().clone() : this.configuration;
        ArrayList<Object> httpPolicies = new ArrayList<Object>();
        String clientName = this.properties.getOrDefault("name", "UnknownName");
        String clientVersion = this.properties.getOrDefault("version", "UnknownVersion");
        String logApplicationId = null;
        if (this.httpLogOptions != null) {
            logApplicationId = this.httpLogOptions.getApplicationId();
        }
        String clientApplicationId = null;
        if (this.clientOptions != null && this.clientOptions.getApplicationId() != null) {
            clientApplicationId = this.clientOptions.getApplicationId();
        }
        if (logApplicationId != null && clientApplicationId != null && !logApplicationId.equalsIgnoreCase(clientApplicationId)) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalStateException("'httpLogOptions.getApplicationId() and clientOptions.getApplicationId()' cannot be different."));
        }
        String applicationId = clientApplicationId != null ? clientApplicationId : logApplicationId;
        httpPolicies.add(new UserAgentPolicy(applicationId, clientName, clientVersion, buildConfiguration));
        httpPolicies.add(new ServiceBusTokenCredentialHttpPolicy(this.tokenCredential));
        httpPolicies.add(new AddHeadersFromContextPolicy());
        HttpPolicyProviders.addBeforeRetryPolicies(httpPolicies);
        httpPolicies.add(this.retryPolicy == null ? new RetryPolicy() : this.retryPolicy);
        httpPolicies.addAll(this.userPolicies);
        httpPolicies.add(new HttpLoggingPolicy(this.httpLogOptions));
        HttpPolicyProviders.addAfterRetryPolicies(httpPolicies);
        return new HttpPipelineBuilder().policies(httpPolicies.toArray(new HttpPipelinePolicy[0])).httpClient(this.httpClient).build();
    }
}

