/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.keys.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.security.keyvault.keys.models.Base64UrlJsonDeserializer;
import com.azure.security.keyvault.keys.models.Base64UrlJsonSerializer;
import com.azure.security.keyvault.keys.models.ByteExtensions;
import com.azure.security.keyvault.keys.models.KeyCurveName;
import com.azure.security.keyvault.keys.models.KeyOperation;
import com.azure.security.keyvault.keys.models.KeyType;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPrivateKeySpec;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.EllipticCurve;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY)
public class JsonWebKey {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private final ClientLogger logger = new ClientLogger(JsonWebKey.class);
    @JsonProperty(value="kid")
    private String keyId;
    @JsonProperty(value="kty")
    private KeyType keyType;
    @JsonProperty(value="key_ops")
    private List<KeyOperation> keyOps;
    @JsonProperty(value="n")
    private byte[] n;
    @JsonProperty(value="e")
    private byte[] e;
    @JsonProperty(value="d")
    private byte[] d;
    @JsonProperty(value="dp")
    private byte[] dp;
    @JsonProperty(value="dq")
    private byte[] dq;
    @JsonProperty(value="qi")
    private byte[] qi;
    @JsonProperty(value="p")
    private byte[] p;
    @JsonProperty(value="q")
    private byte[] q;
    @JsonProperty(value="k")
    private byte[] k;
    @JsonProperty(value="key_hsm")
    private byte[] t;
    @JsonProperty(value="crv")
    private KeyCurveName crv;
    @JsonProperty(value="x")
    private byte[] x;
    @JsonProperty(value="y")
    private byte[] y;
    private static final Map<KeyCurveName, String> CURVE_TO_SPEC_NAME = JsonWebKey.setupCurveToSpecMap();

    @JsonProperty(value="kid")
    public String getId() {
        return this.keyId;
    }

    public JsonWebKey setId(String keyId) {
        this.keyId = keyId;
        return this;
    }

    @JsonProperty(value="kty")
    public KeyType getKeyType() {
        return this.keyType;
    }

    public JsonWebKey setKeyType(KeyType keyType) {
        this.keyType = keyType;
        return this;
    }

    @JsonProperty(value="key_ops")
    public List<KeyOperation> getKeyOps() {
        return this.keyOps == null ? Collections.unmodifiableList(new ArrayList()) : Collections.unmodifiableList(this.keyOps);
    }

    public JsonWebKey setKeyOps(List<KeyOperation> keyOps) {
        this.keyOps = keyOps;
        return this;
    }

    @JsonProperty(value="n")
    @JsonSerialize(using=Base64UrlJsonSerializer.class)
    @JsonDeserialize(using=Base64UrlJsonDeserializer.class)
    public byte[] getN() {
        return ByteExtensions.clone(this.n);
    }

    public JsonWebKey setN(byte[] n) {
        this.n = ByteExtensions.clone(n);
        return this;
    }

    @JsonProperty(value="e")
    @JsonSerialize(using=Base64UrlJsonSerializer.class)
    @JsonDeserialize(using=Base64UrlJsonDeserializer.class)
    public byte[] getE() {
        return ByteExtensions.clone(this.e);
    }

    public JsonWebKey setE(byte[] e) {
        this.e = ByteExtensions.clone(e);
        return this;
    }

    @JsonProperty(value="d")
    @JsonSerialize(using=Base64UrlJsonSerializer.class)
    @JsonDeserialize(using=Base64UrlJsonDeserializer.class)
    public byte[] getD() {
        return ByteExtensions.clone(this.d);
    }

    public JsonWebKey setD(byte[] d) {
        this.d = ByteExtensions.clone(d);
        return this;
    }

    @JsonProperty(value="dp")
    @JsonSerialize(using=Base64UrlJsonSerializer.class)
    @JsonDeserialize(using=Base64UrlJsonDeserializer.class)
    public byte[] getDp() {
        return ByteExtensions.clone(this.dp);
    }

    public JsonWebKey setDp(byte[] dp) {
        this.dp = ByteExtensions.clone(dp);
        return this;
    }

    @JsonProperty(value="dq")
    @JsonSerialize(using=Base64UrlJsonSerializer.class)
    @JsonDeserialize(using=Base64UrlJsonDeserializer.class)
    public byte[] getDq() {
        return ByteExtensions.clone(this.dq);
    }

    public JsonWebKey setDq(byte[] dq) {
        this.dq = ByteExtensions.clone(dq);
        return this;
    }

    @JsonProperty(value="qi")
    @JsonSerialize(using=Base64UrlJsonSerializer.class)
    @JsonDeserialize(using=Base64UrlJsonDeserializer.class)
    public byte[] getQi() {
        return ByteExtensions.clone(this.qi);
    }

    public JsonWebKey setQi(byte[] qi) {
        this.qi = ByteExtensions.clone(qi);
        return this;
    }

    @JsonProperty(value="p")
    @JsonSerialize(using=Base64UrlJsonSerializer.class)
    @JsonDeserialize(using=Base64UrlJsonDeserializer.class)
    public byte[] getP() {
        return ByteExtensions.clone(this.p);
    }

    public JsonWebKey setP(byte[] p) {
        this.p = ByteExtensions.clone(p);
        return this;
    }

    @JsonProperty(value="q")
    @JsonSerialize(using=Base64UrlJsonSerializer.class)
    @JsonDeserialize(using=Base64UrlJsonDeserializer.class)
    public byte[] getQ() {
        return ByteExtensions.clone(this.q);
    }

    public JsonWebKey setQ(byte[] q) {
        this.q = ByteExtensions.clone(q);
        return this;
    }

    @JsonProperty(value="k")
    @JsonSerialize(using=Base64UrlJsonSerializer.class)
    @JsonDeserialize(using=Base64UrlJsonDeserializer.class)
    public byte[] getK() {
        return ByteExtensions.clone(this.k);
    }

    public JsonWebKey setK(byte[] k) {
        this.k = ByteExtensions.clone(k);
        return this;
    }

    @JsonProperty(value="key_hsm")
    @JsonSerialize(using=Base64UrlJsonSerializer.class)
    @JsonDeserialize(using=Base64UrlJsonDeserializer.class)
    public byte[] getT() {
        return ByteExtensions.clone(this.t);
    }

    public JsonWebKey setT(byte[] t) {
        this.t = ByteExtensions.clone(t);
        return this;
    }

    public String toString() {
        try {
            return MAPPER.writeValueAsString((Object)this);
        }
        catch (IOException e) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalStateException(e));
        }
    }

    @JsonProperty(value="crv")
    public KeyCurveName getCurveName() {
        return this.crv;
    }

    public JsonWebKey setCurveName(KeyCurveName crv) {
        this.crv = crv;
        return this;
    }

    @JsonProperty(value="x")
    @JsonSerialize(using=Base64UrlJsonSerializer.class)
    @JsonDeserialize(using=Base64UrlJsonDeserializer.class)
    public byte[] getX() {
        return ByteExtensions.clone(this.x);
    }

    public JsonWebKey setX(byte[] x) {
        this.x = ByteExtensions.clone(x);
        return this;
    }

    @JsonProperty(value="y")
    @JsonSerialize(using=Base64UrlJsonSerializer.class)
    @JsonDeserialize(using=Base64UrlJsonDeserializer.class)
    public byte[] getY() {
        return ByteExtensions.clone(this.y);
    }

    public JsonWebKey setY(byte[] y) {
        this.y = ByteExtensions.clone(y);
        return this;
    }

    private RSAPublicKeySpec getRsaPublicKeySpec() {
        return new RSAPublicKeySpec(JsonWebKey.toBigInteger(this.n), JsonWebKey.toBigInteger(this.e));
    }

    private RSAPrivateKeySpec getRsaPrivateKeySpec() {
        return new RSAPrivateCrtKeySpec(JsonWebKey.toBigInteger(this.n), JsonWebKey.toBigInteger(this.e), JsonWebKey.toBigInteger(this.d), JsonWebKey.toBigInteger(this.p), JsonWebKey.toBigInteger(this.q), JsonWebKey.toBigInteger(this.dp), JsonWebKey.toBigInteger(this.dq), JsonWebKey.toBigInteger(this.qi));
    }

    private PublicKey getRsaPublicKey(Provider provider) {
        try {
            RSAPublicKeySpec publicKeySpec = this.getRsaPublicKeySpec();
            KeyFactory factory = provider != null ? KeyFactory.getInstance("RSA", provider) : KeyFactory.getInstance("RSA");
            return factory.generatePublic(publicKeySpec);
        }
        catch (GeneralSecurityException e) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalStateException(e));
        }
    }

    private PrivateKey getRsaPrivateKey(Provider provider) {
        try {
            RSAPrivateKeySpec privateKeySpec = this.getRsaPrivateKeySpec();
            KeyFactory factory = provider != null ? KeyFactory.getInstance("RSA", provider) : KeyFactory.getInstance("RSA");
            return factory.generatePrivate(privateKeySpec);
        }
        catch (GeneralSecurityException e) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalStateException(e));
        }
    }

    private static PublicKey getEcPublicKey(ECPoint ecPoint, ECParameterSpec curveSpec, Provider provider) {
        try {
            ECPublicKeySpec pubSpec = new ECPublicKeySpec(ecPoint, curveSpec);
            KeyFactory kf = provider != null ? KeyFactory.getInstance("EC", provider) : KeyFactory.getInstance("EC", "SunEC");
            return (ECPublicKey)kf.generatePublic(pubSpec);
        }
        catch (GeneralSecurityException e) {
            throw new IllegalStateException(e);
        }
    }

    private static PrivateKey getEcPrivateKey(byte[] d, ECParameterSpec curveSpec, Provider provider) {
        try {
            ECPrivateKeySpec priSpec = new ECPrivateKeySpec(new BigInteger(1, d), curveSpec);
            KeyFactory kf = provider != null ? KeyFactory.getInstance("EC", provider) : KeyFactory.getInstance("EC", "SunEC");
            return (ECPrivateKey)kf.generatePrivate(priSpec);
        }
        catch (GeneralSecurityException e) {
            throw new IllegalStateException(e);
        }
    }

    private void checkRsaCompatible() {
        if (!KeyType.RSA.equals((Object)this.keyType) && !KeyType.RSA_HSM.equals((Object)this.keyType)) {
            throw this.logger.logExceptionAsError((RuntimeException)new UnsupportedOperationException("Not an RSA key"));
        }
    }

    private static byte[] toByteArray(BigInteger n) {
        byte[] result = n.toByteArray();
        if (result[0] == 0) {
            return Arrays.copyOfRange(result, 1, result.length);
        }
        return result;
    }

    private static BigInteger toBigInteger(byte[] b) {
        if (b[0] < 0) {
            byte[] temp = new byte[1 + b.length];
            System.arraycopy(b, 0, temp, 1, b.length);
            b = temp;
        }
        return new BigInteger(b);
    }

    public static JsonWebKey fromRsa(KeyPair keyPair) {
        RSAPrivateCrtKey privateKey = (RSAPrivateCrtKey)keyPair.getPrivate();
        JsonWebKey key = null;
        if (privateKey != null) {
            key = new JsonWebKey().setKeyType(KeyType.RSA).setN(JsonWebKey.toByteArray(privateKey.getModulus())).setE(JsonWebKey.toByteArray(privateKey.getPublicExponent())).setD(JsonWebKey.toByteArray(privateKey.getPrivateExponent())).setP(JsonWebKey.toByteArray(privateKey.getPrimeP())).setQ(JsonWebKey.toByteArray(privateKey.getPrimeQ())).setDp(JsonWebKey.toByteArray(privateKey.getPrimeExponentP())).setDq(JsonWebKey.toByteArray(privateKey.getPrimeExponentQ())).setQi(JsonWebKey.toByteArray(privateKey.getCrtCoefficient()));
        } else {
            RSAPublicKey publicKey = (RSAPublicKey)keyPair.getPublic();
            key = new JsonWebKey().setKeyType(KeyType.RSA).setN(JsonWebKey.toByteArray(publicKey.getModulus())).setE(JsonWebKey.toByteArray(publicKey.getPublicExponent())).setD(null).setP(null).setQ(null).setDp(null).setDq(null).setQi(null);
        }
        return key;
    }

    public static JsonWebKey fromRsa(KeyPair keyPair, List<KeyOperation> keyOperations) {
        return JsonWebKey.fromRsa(keyPair).setKeyOps(keyOperations);
    }

    public KeyPair toRsa() {
        return this.toRsa(false);
    }

    public KeyPair toRsa(boolean includePrivateParameters) {
        return this.toRsa(includePrivateParameters, null);
    }

    public KeyPair toRsa(boolean includePrivateParameters, Provider provider) {
        this.checkRsaCompatible();
        if (includePrivateParameters) {
            return new KeyPair(this.getRsaPublicKey(provider), this.getRsaPrivateKey(provider));
        }
        return new KeyPair(this.getRsaPublicKey(provider), null);
    }

    public KeyPair toEc() {
        return this.toEc(false, null);
    }

    public KeyPair toEc(boolean includePrivateParameters) {
        return this.toEc(includePrivateParameters, null);
    }

    public KeyPair toEc(boolean includePrivateParameters, Provider provider) {
        if (provider == null) {
            provider = Security.getProvider("SunEC");
        }
        if (!KeyType.EC.equals((Object)this.keyType) && !KeyType.EC_HSM.equals((Object)this.keyType)) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Not an EC key."));
        }
        try {
            KeyPairGenerator kpg = KeyPairGenerator.getInstance("EC", provider);
            ECGenParameterSpec gps = new ECGenParameterSpec(CURVE_TO_SPEC_NAME.get((Object)this.crv));
            kpg.initialize(gps);
            KeyPair apair = kpg.generateKeyPair();
            ECPublicKey apub = (ECPublicKey)apair.getPublic();
            ECParameterSpec aspec = apub.getParams();
            ECPoint ecPoint = new ECPoint(new BigInteger(1, this.x), new BigInteger(1, this.y));
            KeyPair realKeyPair = includePrivateParameters ? new KeyPair(JsonWebKey.getEcPublicKey(ecPoint, aspec, provider), JsonWebKey.getEcPrivateKey(this.d, aspec, provider)) : new KeyPair(JsonWebKey.getEcPublicKey(ecPoint, aspec, provider), null);
            return realKeyPair;
        }
        catch (GeneralSecurityException e) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalStateException(e));
        }
    }

    public static JsonWebKey fromEc(KeyPair keyPair, Provider provider) {
        ECPublicKey apub = (ECPublicKey)keyPair.getPublic();
        ECPoint point = apub.getW();
        ECPrivateKey apriv = (ECPrivateKey)keyPair.getPrivate();
        if (apriv != null) {
            return new JsonWebKey().setKeyType(KeyType.EC).setCurveName(JsonWebKey.getCurveFromKeyPair(keyPair, provider)).setX(point.getAffineX().toByteArray()).setY(point.getAffineY().toByteArray()).setD(apriv.getS().toByteArray()).setKeyType(KeyType.EC);
        }
        return new JsonWebKey().setKeyType(KeyType.EC).setCurveName(JsonWebKey.getCurveFromKeyPair(keyPair, provider)).setX(point.getAffineX().toByteArray()).setY(point.getAffineY().toByteArray()).setKeyType(KeyType.EC);
    }

    public static JsonWebKey fromEc(KeyPair keyPair, Provider provider, List<KeyOperation> keyOperations) {
        return JsonWebKey.fromEc(keyPair, provider).setKeyOps(keyOperations);
    }

    private static KeyCurveName getCurveFromKeyPair(KeyPair keyPair, Provider provider) {
        try {
            ECPublicKey key = (ECPublicKey)keyPair.getPublic();
            ECParameterSpec spec = key.getParams();
            EllipticCurve crv = spec.getCurve();
            List<KeyCurveName> curveList = Arrays.asList(KeyCurveName.P_256, KeyCurveName.P_384, KeyCurveName.P_521, KeyCurveName.P_256K);
            for (KeyCurveName curve : curveList) {
                ECGenParameterSpec gps = new ECGenParameterSpec(CURVE_TO_SPEC_NAME.get((Object)curve));
                KeyPairGenerator kpg = KeyPairGenerator.getInstance("EC", provider);
                kpg.initialize(gps);
                KeyPair apair = kpg.generateKeyPair();
                ECPublicKey apub = (ECPublicKey)apair.getPublic();
                ECParameterSpec aspec = apub.getParams();
                EllipticCurve acurve = aspec.getCurve();
                if (!acurve.equals(crv)) continue;
                return curve;
            }
            throw new NoSuchAlgorithmException("Curve not supported.");
        }
        catch (GeneralSecurityException e) {
            throw new IllegalStateException(e);
        }
    }

    public static JsonWebKey fromAes(SecretKey secretKey) {
        if (secretKey == null) {
            return null;
        }
        return new JsonWebKey().setK(secretKey.getEncoded()).setKeyType(KeyType.OCT);
    }

    public static JsonWebKey fromAes(SecretKey secretKey, List<KeyOperation> keyOperations) {
        return JsonWebKey.fromAes(secretKey).setKeyOps(keyOperations);
    }

    public SecretKey toAes() {
        if (this.k == null) {
            return null;
        }
        SecretKeySpec secretKey = new SecretKeySpec(this.k, "AES");
        return secretKey;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof JsonWebKey) {
            return this.equals((JsonWebKey)obj);
        }
        return super.equals(obj);
    }

    public boolean equals(JsonWebKey jwk) {
        if (jwk == null) {
            return false;
        }
        if (!this.objectEquals(this.keyId, jwk.keyId)) {
            return false;
        }
        if (!this.objectEquals((Object)this.keyType, (Object)jwk.keyType)) {
            return false;
        }
        if (!this.objectEquals(this.keyOps, jwk.keyOps)) {
            return false;
        }
        if (!this.objectEquals((Object)this.crv, (Object)jwk.crv)) {
            return false;
        }
        if (!Arrays.equals(this.k, jwk.k)) {
            return false;
        }
        if (!Arrays.equals(this.n, jwk.n)) {
            return false;
        }
        if (!Arrays.equals(this.e, jwk.e)) {
            return false;
        }
        if (!Arrays.equals(this.d, jwk.d)) {
            return false;
        }
        if (!Arrays.equals(this.dp, jwk.dp)) {
            return false;
        }
        if (!Arrays.equals(this.dq, jwk.dq)) {
            return false;
        }
        if (!Arrays.equals(this.qi, jwk.qi)) {
            return false;
        }
        if (!Arrays.equals(this.p, jwk.p)) {
            return false;
        }
        if (!Arrays.equals(this.q, jwk.q)) {
            return false;
        }
        if (!Arrays.equals(this.x, jwk.x)) {
            return false;
        }
        if (!Arrays.equals(this.y, jwk.y)) {
            return false;
        }
        return Arrays.equals(this.t, jwk.t);
    }

    public boolean hasPrivateKey() {
        if (KeyType.OCT.equals((Object)this.keyType)) {
            return this.k != null;
        }
        if (KeyType.RSA.equals((Object)this.keyType) || KeyType.RSA_HSM.equals((Object)this.keyType)) {
            return this.d != null && this.dp != null && this.dq != null && this.qi != null && this.p != null && this.q != null;
        }
        if (KeyType.EC.equals((Object)this.keyType) || KeyType.EC_HSM.equals((Object)this.keyType)) {
            return this.d != null;
        }
        return false;
    }

    @JsonIgnore
    public boolean isValid() {
        if (this.keyType == null) {
            return false;
        }
        if (this.keyOps != null) {
            HashSet<KeyOperation> set = new HashSet<KeyOperation>(KeyOperation.values());
            for (int i = 0; i < this.keyOps.size(); ++i) {
                if (set.contains((Object)this.keyOps.get(i))) continue;
                return false;
            }
        }
        if (KeyType.OCT.equals((Object)this.keyType) || KeyType.OCT_HSM.equals((Object)this.keyType)) {
            return this.isValidOctet();
        }
        if (KeyType.RSA.equals((Object)this.keyType)) {
            return this.isValidRsa();
        }
        if (KeyType.RSA_HSM.equals((Object)this.keyType)) {
            return this.isValidRsaHsm();
        }
        if (KeyType.EC.equals((Object)this.keyType)) {
            return this.isValidEc();
        }
        if (KeyType.EC_HSM.equals((Object)this.keyType)) {
            return this.isValidEcHsm();
        }
        return false;
    }

    private boolean isValidOctet() {
        return this.k != null;
    }

    private boolean isValidRsa() {
        if (this.n == null || this.e == null) {
            return false;
        }
        return this.hasPrivateKey() || this.d == null && this.dp == null && this.dq == null && this.qi == null && this.p == null && this.q == null;
    }

    private boolean isValidRsaHsm() {
        boolean publicParameters;
        if (this.n == null && this.e != null || this.n != null && this.e == null) {
            return false;
        }
        if (this.hasPrivateKey()) {
            return false;
        }
        boolean tokenParameters = this.t != null;
        boolean bl = publicParameters = this.n != null && this.e != null;
        if (tokenParameters && publicParameters) {
            return false;
        }
        return tokenParameters || publicParameters;
    }

    private boolean isValidEc() {
        boolean ecPointParameters;
        boolean bl = ecPointParameters = this.x != null && this.y != null;
        if (!ecPointParameters || this.crv == null) {
            return false;
        }
        return this.hasPrivateKey() || this.d == null;
    }

    private boolean isValidEcHsm() {
        boolean tokenParameters;
        boolean ecPointParameters;
        boolean bl = ecPointParameters = this.x != null && this.y != null;
        if (ecPointParameters && this.crv == null || !ecPointParameters && this.crv != null) {
            return false;
        }
        if (this.hasPrivateKey()) {
            return false;
        }
        boolean publicParameters = ecPointParameters && this.crv != null;
        boolean bl2 = tokenParameters = this.t != null;
        if (tokenParameters && publicParameters) {
            return false;
        }
        return tokenParameters || publicParameters;
    }

    public void clearMemory() {
        JsonWebKey.zeroArray(this.k);
        this.k = null;
        JsonWebKey.zeroArray(this.n);
        this.n = null;
        JsonWebKey.zeroArray(this.e);
        this.e = null;
        JsonWebKey.zeroArray(this.d);
        this.d = null;
        JsonWebKey.zeroArray(this.dp);
        this.dp = null;
        JsonWebKey.zeroArray(this.dq);
        this.dq = null;
        JsonWebKey.zeroArray(this.qi);
        this.qi = null;
        JsonWebKey.zeroArray(this.p);
        this.p = null;
        JsonWebKey.zeroArray(this.q);
        this.q = null;
        JsonWebKey.zeroArray(this.t);
        this.t = null;
        JsonWebKey.zeroArray(this.x);
        this.x = null;
        JsonWebKey.zeroArray(this.y);
        this.y = null;
    }

    private static void zeroArray(byte[] bytes) {
        if (bytes != null) {
            Arrays.fill(bytes, (byte)0);
        }
    }

    public int hashCode() {
        int hashCode = 48313;
        if (this.keyId != null) {
            hashCode += this.keyId.hashCode();
        }
        if (KeyType.OCT.equals((Object)this.keyType)) {
            hashCode += JsonWebKey.hashCode(this.k);
        } else if (KeyType.RSA.equals((Object)this.keyType)) {
            hashCode += JsonWebKey.hashCode(this.n);
        } else if (KeyType.EC.equals((Object)this.keyType)) {
            hashCode += JsonWebKey.hashCode(this.x);
            hashCode += JsonWebKey.hashCode(this.y);
            hashCode += this.crv.hashCode();
        } else if (KeyType.RSA_HSM.equals((Object)this.keyType) || KeyType.EC_HSM.equals((Object)this.keyType)) {
            hashCode += JsonWebKey.hashCode(this.t);
        }
        return hashCode;
    }

    private static int hashCode(byte[] obj) {
        int hashCode = 0;
        if (obj == null || obj.length == 0) {
            return 0;
        }
        for (int i = 0; i < obj.length; ++i) {
            hashCode = hashCode << 3 | hashCode >> 29 ^ obj[i];
        }
        return hashCode;
    }

    private static Map<KeyCurveName, String> setupCurveToSpecMap() {
        HashMap<KeyCurveName, String> curveToSpecMap = new HashMap<KeyCurveName, String>();
        curveToSpecMap.put(KeyCurveName.P_256, "secp256r1");
        curveToSpecMap.put(KeyCurveName.P_384, "secp384r1");
        curveToSpecMap.put(KeyCurveName.P_521, "secp521r1");
        curveToSpecMap.put(KeyCurveName.P_256K, "secp256k1");
        return curveToSpecMap;
    }

    private boolean objectEquals(Object a, Object b) {
        if (a == null && b == null) {
            return true;
        }
        if (a != null && b != null) {
            return a.equals(b);
        }
        return false;
    }
}

