/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.share.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.ResponseBase;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.storage.file.share.implementation.AzureFileStorageImpl;
import com.azure.storage.file.share.implementation.models.ListSharesIncludeType;
import com.azure.storage.file.share.implementation.models.ListSharesResponse;
import com.azure.storage.file.share.implementation.models.ServicesGetPropertiesHeaders;
import com.azure.storage.file.share.implementation.models.ServicesListSharesSegmentHeaders;
import com.azure.storage.file.share.implementation.models.ServicesListSharesSegmentNextHeaders;
import com.azure.storage.file.share.implementation.models.ServicesSetPropertiesHeaders;
import com.azure.storage.file.share.implementation.models.ShareItemInternal;
import com.azure.storage.file.share.models.ShareServiceProperties;
import com.azure.storage.file.share.models.ShareStorageException;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;

public final class ServicesImpl {
    private final ServicesService service;
    private final AzureFileStorageImpl client;

    ServicesImpl(AzureFileStorageImpl client) {
        this.service = (ServicesService)RestProxy.create(ServicesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<ServicesSetPropertiesHeaders, Void>> setPropertiesWithResponseAsync(ShareServiceProperties shareServiceProperties, Integer timeout, Context context) {
        String restype = "service";
        String comp = "properties";
        String accept = "application/xml";
        return this.service.setProperties(this.client.getUrl(), "service", "properties", timeout, this.client.getVersion(), shareServiceProperties, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<ServicesGetPropertiesHeaders, ShareServiceProperties>> getPropertiesWithResponseAsync(Integer timeout, Context context) {
        String restype = "service";
        String comp = "properties";
        String accept = "application/xml";
        return this.service.getProperties(this.client.getUrl(), "service", "properties", timeout, this.client.getVersion(), "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<ShareItemInternal>> listSharesSegmentSinglePageAsync(String prefix, String marker, Integer maxresults, List<ListSharesIncludeType> include, Integer timeout, Context context) {
        String comp = "list";
        String accept = "application/xml";
        String includeConverted = include == null ? null : include.stream().map(value -> Objects.toString(value, "")).collect(Collectors.joining(","));
        return this.service.listSharesSegment(this.client.getUrl(), "list", prefix, marker, maxresults, includeConverted, timeout, this.client.getVersion(), "application/xml", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ListSharesResponse)res.getValue()).getShareItems(), ((ListSharesResponse)res.getValue()).getNextMarker(), (Object)((ServicesListSharesSegmentHeaders)res.getDeserializedHeaders())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<ShareItemInternal>> listSharesSegmentNextSinglePageAsync(String nextLink, Context context) {
        String accept = "application/xml";
        return this.service.listSharesSegmentNext(nextLink, this.client.getUrl(), this.client.getVersion(), "application/xml", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ListSharesResponse)res.getValue()).getShareItems(), ((ListSharesResponse)res.getValue()).getNextMarker(), (Object)((ServicesListSharesSegmentNextHeaders)res.getDeserializedHeaders())));
    }

    @Host(value="{url}")
    @ServiceInterface(name="AzureFileStorageServ")
    public static interface ServicesService {
        @Put(value="/")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<ResponseBase<ServicesSetPropertiesHeaders, Void>> setProperties(@HostParam(value="url") String var1, @QueryParam(value="restype") String var2, @QueryParam(value="comp") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-version") String var5, @BodyParam(value="application/xml") ShareServiceProperties var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Get(value="/")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<ResponseBase<ServicesGetPropertiesHeaders, ShareServiceProperties>> getProperties(@HostParam(value="url") String var1, @QueryParam(value="restype") String var2, @QueryParam(value="comp") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Get(value="/")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<ResponseBase<ServicesListSharesSegmentHeaders, ListSharesResponse>> listSharesSegment(@HostParam(value="url") String var1, @QueryParam(value="comp") String var2, @QueryParam(value="prefix") String var3, @QueryParam(value="marker") String var4, @QueryParam(value="maxresults") Integer var5, @QueryParam(value="include") String var6, @QueryParam(value="timeout") Integer var7, @HeaderParam(value="x-ms-version") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<ResponseBase<ServicesListSharesSegmentNextHeaders, ListSharesResponse>> listSharesSegmentNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="url") String var2, @HeaderParam(value="x-ms-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);
    }
}

