/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.tls.i18n;

import cfca.sadk.tls.sun.security.ssl.Debugger;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;

public final class JSSEMessage {
    private static final String basename = "JSSEMessage";
    private static final Locale currentLocale = Locale.getDefault();
    private static final ResourceBundle bundle = ResourceBundle.getBundle("JSSEMessage", currentLocale);

    public static final String getMessage(String key) {
        return bundle.getString(key);
    }

    public static final String getMessage(String key, Object arg) {
        return JSSEMessage.getMessage(key, new Object[]{arg});
    }

    public static final String getMessage(String key, Object[] args) {
        try {
            MessageFormat messageFormat = new MessageFormat(bundle.getString(key));
            return messageFormat.format(args);
        }
        catch (Exception e) {
            if (Debugger.handshaker.isDebugEnabled()) {
                Debugger.handshaker.debug("get message from {} failure by key={}: {}", new Object[]{basename, key, e.getMessage()});
            }
            return JSSEMessage.getUnknownMessage(key);
        }
    }

    private static final String getUnknownMessage(String key) {
        try {
            return new MessageFormat(bundle.getString("cfca.sadk.tls.resources.missing")).format(new Object[]{key});
        }
        catch (Exception e) {
            if (Debugger.handshaker.isDebugEnabled()) {
                Debugger.handshaker.debug("get message from {} failure by key={}: {}", new Object[]{basename, key, e.getMessage()});
            }
            return "Unknown key: " + key;
        }
    }
}

