/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.tls.javax.net.ssl;

import cfca.sadk.tls.javax.net.ssl.GMSSLParameters;
import cfca.sadk.tls.javax.net.ssl.GMSSLTransfer;
import cfca.sadk.tls.sun.security.validator.GMAlgorithmConstraints;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSession;

public abstract class GMSSLEngine
extends SSLEngine
implements GMSSLTransfer {
    private String peerHost = null;
    private int peerPort = -1;

    protected GMSSLEngine() {
    }

    protected GMSSLEngine(String peerHost, int peerPort) {
        this.peerHost = peerHost;
        this.peerPort = peerPort;
    }

    @Override
    public String getPeerHost() {
        return this.peerHost;
    }

    @Override
    public int getPeerPort() {
        return this.peerPort;
    }

    @Override
    public SSLSession getHandshakeSession() {
        throw new UnsupportedOperationException();
    }

    @Override
    public GMSSLParameters getCFCASSLParameters() {
        GMSSLParameters params = new GMSSLParameters();
        params.setCipherSuites(this.getEnabledCipherSuites());
        params.setProtocols(this.getEnabledProtocols());
        if (this.getNeedClientAuth()) {
            params.setNeedClientAuth(true);
        } else if (this.getWantClientAuth()) {
            params.setWantClientAuth(true);
        }
        return params;
    }

    @Override
    public void setCFCASSLParameters(GMSSLParameters params) {
        if (params != null) {
            String[] protocols;
            String[] cipherSuites = params.getCipherSuites();
            if (cipherSuites != null) {
                this.setEnabledCipherSuites(cipherSuites);
            }
            if ((protocols = params.getProtocols()) != null) {
                this.setEnabledProtocols(protocols);
            }
            if (params.getNeedClientAuth()) {
                this.setNeedClientAuth(true);
            } else if (params.getWantClientAuth()) {
                this.setWantClientAuth(true);
            } else {
                this.setWantClientAuth(false);
            }
        }
    }

    @Override
    public GMAlgorithmConstraints getAlgorithmConstraints() {
        return this.getCFCASSLParameters().getAlgorithmConstraints();
    }
}

