/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.tls.kse;

import cfca.sadk.algorithm.common.CBCParam;
import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.lib.crypto.bcsoft.BCSoftLib;
import cfca.sadk.org.bouncycastle.crypto.digests.SM3DigestKit;
import cfca.sadk.system.SecureRandoms;
import cfca.sadk.tls.util.Args;
import cfca.sadk.util.Base64;
import java.nio.charset.Charset;
import java.security.Key;
import java.util.Arrays;
import javax.crypto.spec.SecretKeySpec;

public final class PasswordTool {
    private static final Charset US_ASCII = Charset.forName("US-ASCII");
    private static final int PASSWORD_ENCRYPT_MIN_LEN = 16;
    private static final String PASSWORD_ENCRYPT_PREFIX = "ENCRYPT@";

    public static final String restored(String password, String name) throws Exception {
        try {
            return PasswordTool.decrypt(password);
        }
        catch (Exception e) {
            throw new Exception(name + " restored password failure: " + password, e);
        }
    }

    public static final String encrypt(String plainPassword) throws Exception {
        Args.notNull(plainPassword, "plainPassword");
        byte[] iv = SecureRandoms.getInstance().genBytes(16);
        IvAndKey ik = PasswordTool.kdf();
        byte[] password = plainPassword.getBytes(US_ASCII);
        byte[] enBytes = BCSoftLib.INSTANCE().encrypt(new Mechanism(Mechanism.SM4_CBC, (Object)ik.iv(iv)), ik.key(), password);
        byte[] ouBytes = new byte[iv.length + enBytes.length];
        System.arraycopy(iv, 0, ouBytes, 0, iv.length);
        System.arraycopy(enBytes, 0, ouBytes, iv.length, enBytes.length);
        return PASSWORD_ENCRYPT_PREFIX + Base64.toBase64String((byte[])((byte[])ouBytes.clone()));
    }

    public static final String decrypt(String base64EncryptPassword) throws Exception {
        Args.notNull(base64EncryptPassword, "base64EncryptPassword");
        String pass = base64EncryptPassword;
        if (base64EncryptPassword.startsWith(PASSWORD_ENCRYPT_PREFIX)) {
            if ((base64EncryptPassword = base64EncryptPassword.substring(PASSWORD_ENCRYPT_PREFIX.length())).length() < 16) {
                throw new Exception("the length of encrypted password must be more than 16!");
            }
            byte[] data = Base64.decode((String)base64EncryptPassword);
            byte[] iv = Arrays.copyOfRange(data, 0, 16);
            IvAndKey ik = PasswordTool.kdf();
            byte[] encryptBytes = Arrays.copyOfRange(data, 16, data.length);
            byte[] password = BCSoftLib.INSTANCE().decrypt(new Mechanism(Mechanism.SM4_CBC, (Object)ik.iv(iv)), ik.key(), encryptBytes);
            pass = new String(password, US_ASCII);
        }
        return pass;
    }

    static IvAndKey kdf() throws Exception {
        byte[] message = "SeakJSSE@+s9fhSBDvmDBmVHsm%He&&LONG".getBytes("utf8");
        byte[] ct = new byte[]{0, 0, 0, 1};
        SM3DigestKit sm3 = new SM3DigestKit();
        sm3.update(message, 0, message.length);
        sm3.update(ct, 0, ct.length);
        byte[] hash = new byte[32];
        sm3.doFinal(hash, 0);
        return new IvAndKey(hash);
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            System.err.println("command: password.sh <password>");
            return;
        }
        String enpassword = PasswordTool.encrypt(args[0]);
        String depassword = PasswordTool.decrypt(enpassword);
        if (depassword.equals(args[0])) {
            System.err.println(enpassword);
        } else {
            System.err.println("encrypt password failed: " + depassword);
        }
    }

    private static class IvAndKey {
        final byte[] iv = new byte[16];
        final byte[] kx = new byte[16];

        IvAndKey(byte[] hash) {
            System.arraycopy(hash, 0, this.iv, 0, this.iv.length);
            System.arraycopy(hash, 16, this.kx, 0, this.kx.length);
        }

        private final CBCParam iv(byte[] iv) {
            byte[] dx = (byte[])iv.clone();
            for (int i = 0; i < iv.length; ++i) {
                int n = i;
                dx[n] = (byte)(dx[n] ^ this.iv[i]);
            }
            return new CBCParam(dx);
        }

        private final Key key() {
            return new SecretKeySpec(this.kx, "SM4");
        }
    }
}

