/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.tls.sun.security.ssl.manager;

import cfca.sadk.tls.pure.impl.SM2Helper;
import cfca.sadk.tls.sun.security.ssl.manager.CertCheckResult;
import cfca.sadk.tls.sun.security.ssl.manager.CertKeyUsage;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

enum CertCheckType {
    NONE(new String[0]),
    CLIENT(new String[]{"2.5.29.37.0", "1.3.6.1.5.5.7.3.2"}),
    SERVER(new String[]{"2.5.29.37.0", "1.3.6.1.5.5.7.3.1", "2.16.840.1.113730.4.1", "1.3.6.1.4.1.311.10.3.3"});

    final Set<String> validEku;

    private CertCheckType(String[] validEku) {
        this.validEku = new HashSet<String>(Arrays.asList(validEku));
    }

    final CertCheckResult check(X509Certificate cert, Date date) {
        if (cert == null || date == null) {
            throw new IllegalArgumentException("parameters cert and date must not null");
        }
        CertCheckResult checkResult = CertCheckResult.OK;
        if (this == NONE) {
            return checkResult;
        }
        checkResult = this.checkExtensions(cert);
        if (checkResult != CertCheckResult.OK) {
            return checkResult;
        }
        checkResult = this.checkValidity(cert, date);
        return checkResult;
    }

    private final CertCheckResult checkExtensions(X509Certificate cert) {
        try {
            List<String> certEku = cert.getExtendedKeyUsage();
            if (certEku != null && Collections.disjoint(this.validEku, certEku)) {
                return CertCheckResult.EXTENSION_MISMATCH;
            }
            CertKeyUsage keyUsage = new CertKeyUsage(cert.getKeyUsage());
            if (keyUsage.enabled()) {
                String algorithm = cert.getPublicKey().getAlgorithm();
                boolean enabledSignBit = keyUsage.digitalSignature();
                if (!(!SM2Helper.isSM2Type(algorithm) || enabledSignBit || this != CLIENT && keyUsage.keyEncipherment())) {
                    return CertCheckResult.EXTENSION_MISMATCH;
                }
            }
        }
        catch (CertificateException e) {
            return CertCheckResult.EXTENSION_MISMATCH;
        }
        return CertCheckResult.OK;
    }

    private final CertCheckResult checkValidity(X509Certificate cert, Date date) {
        CertCheckResult checkResult = CertCheckResult.OK;
        try {
            cert.checkValidity(date);
        }
        catch (CertificateExpiredException e) {
            checkResult = CertCheckResult.EXPIRED;
        }
        catch (CertificateNotYetValidException e) {
            checkResult = CertCheckResult.NOTYETVALID;
        }
        return checkResult;
    }
}

