/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.tls.sun.security.ssl.manager;

import cfca.sadk.tls.javax.net.ssl.GMSSLEngine;
import cfca.sadk.tls.javax.net.ssl.GMSSLSocket;
import cfca.sadk.tls.sun.security.ssl.Debugger;
import cfca.sadk.tls.sun.security.ssl.manager.CertCheckResult;
import cfca.sadk.tls.sun.security.ssl.manager.CertCheckType;
import cfca.sadk.tls.sun.security.ssl.manager.CertKeyEntryStatus;
import cfca.sadk.tls.sun.security.ssl.manager.CertKeyType;
import cfca.sadk.tls.sun.security.ssl.manager.LRULinkedHashMap;
import cfca.sadk.tls.sun.security.ssl.sec.SSLAlgorithmConstraints;
import cfca.sadk.tls.sun.security.util.GMSSLConstants;
import cfca.sadk.tls.sun.security.validator.GMAlgorithmChecker;
import cfca.sadk.tls.sun.security.validator.GMAlgorithmConstraints;
import cfca.sadk.tls.sun.security.validator.GMCertificateException;
import cfca.sadk.tls.sun.security.validator.GMCertificateExpiredException;
import cfca.sadk.tls.sun.security.validator.GMCertificateNotYetValidException;
import cfca.sadk.tls.util.Loggings;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.net.Socket;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.UnrecoverableEntryException;
import java.security.cert.CertPathValidatorException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509KeyManager;

final class GMX509KeyManager
extends X509ExtendedKeyManager
implements X509KeyManager {
    private final List<KeyStore.Builder> builders;
    private final AtomicLong uidCounter;
    private final Map<String, Reference<KeyStore.PrivateKeyEntry>> entryCacheMap;

    GMX509KeyManager(KeyStore.Builder builder) {
        this(Collections.singletonList(builder));
    }

    GMX509KeyManager(List<KeyStore.Builder> builders) {
        this.builders = builders;
        this.uidCounter = new AtomicLong();
        int cacheSize = GMSSLConstants.cacheSizeOfPrivateKeys;
        this.entryCacheMap = Collections.synchronizedMap(new LRULinkedHashMap(cacheSize));
    }

    @Override
    public final X509Certificate[] getCertificateChain(String alias) {
        KeyStore.PrivateKeyEntry entry = this.getEntry(alias);
        X509Certificate[] chain = null;
        if (entry != null) {
            chain = (X509Certificate[])entry.getCertificateChain();
        }
        return chain;
    }

    @Override
    public final PrivateKey getPrivateKey(String alias) {
        KeyStore.PrivateKeyEntry entry = this.getEntry(alias);
        PrivateKey privateKey = null;
        if (entry != null) {
            privateKey = entry.getPrivateKey();
        }
        return privateKey;
    }

    @Override
    public final String chooseClientAlias(String[] keyTypes, Principal[] issuers, Socket socket) {
        GMAlgorithmConstraints constraints = this.getAlgorithmConstraints(socket);
        return this.chooseBestAlias(keyTypes, issuers, CertCheckType.CLIENT, constraints);
    }

    @Override
    public final String chooseEngineClientAlias(String[] keyTypes, Principal[] issuers, SSLEngine engine) {
        GMAlgorithmConstraints constraints = this.getAlgorithmConstraints(engine);
        return this.chooseBestAlias(keyTypes, issuers, CertCheckType.CLIENT, constraints);
    }

    @Override
    public final String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
        GMAlgorithmConstraints constraints = this.getAlgorithmConstraints(socket);
        return this.chooseBestAlias(new String[]{keyType}, issuers, CertCheckType.SERVER, constraints);
    }

    @Override
    public final String chooseEngineServerAlias(String keyType, Principal[] issuers, SSLEngine engine) {
        GMAlgorithmConstraints constraints = this.getAlgorithmConstraints(engine);
        return this.chooseBestAlias(new String[]{keyType}, issuers, CertCheckType.SERVER, constraints);
    }

    @Override
    public final String[] getClientAliases(String keyType, Principal[] issuers) {
        return this.findAliases(new String[]{keyType}, issuers, CertCheckType.CLIENT, null);
    }

    @Override
    public final String[] getServerAliases(String keyType, Principal[] issuers) {
        return this.findAliases(new String[]{keyType}, issuers, CertCheckType.SERVER, null);
    }

    private final GMAlgorithmConstraints getAlgorithmConstraints(Socket socket) {
        GMSSLSocket transfer = null;
        if (socket != null && socket.isConnected() && socket instanceof GMSSLSocket) {
            transfer = (GMSSLSocket)socket;
        }
        return new SSLAlgorithmConstraints(transfer, true);
    }

    private final GMAlgorithmConstraints getAlgorithmConstraints(SSLEngine engine) {
        GMSSLEngine transfer = null;
        if (engine instanceof GMSSLEngine) {
            transfer = (GMSSLEngine)engine;
        }
        return new SSLAlgorithmConstraints(transfer, true);
    }

    private final String makeAlias(CertKeyEntryStatus entry) {
        return this.uidCounter.incrementAndGet() + "." + entry.builderIndex + "." + entry.alias;
    }

    private final KeyStore.PrivateKeyEntry getEntry(String alias) {
        if (alias == null) {
            return null;
        }
        KeyStore.PrivateKeyEntry entryResult = this.findPrivateKeyEntryFromCache(alias);
        if (entryResult != null) {
            return entryResult;
        }
        Debugger.handshaker.debug("Find the PrivateKeyEntry({}) from builders running...", (Object)alias);
        try {
            entryResult = this.findPrivateKeyEntryFromBuilders(this.builders, alias);
        }
        catch (KeyStoreException e) {
            Debugger.handshaker.warn("Find the PrivateKeyEntry({}) from builders failure: {}", new Object[]{alias, e.getMessage(), e});
            throw new SecurityException("UnrecoverablePrivatekeyEntry with KeyStoreException", e);
        }
        catch (NoSuchAlgorithmException e) {
            Debugger.handshaker.warn("Find the PrivateKeyEntry({}) from builders failure: {}", new Object[]{alias, e.getMessage(), e});
            throw new SecurityException("UnrecoverablePrivatekeyEntry with NoSuchAlgorithmException", e);
        }
        catch (UnrecoverableEntryException e) {
            Debugger.handshaker.warn("Find the PrivateKeyEntry({}) from builders failure: {} (password invalid/jce-policy: illegal-key-size)", new Object[]{alias, e.getMessage(), e});
            throw new SecurityException("UnrecoverablePrivatekeyEntry with UnrecoverableEntryException(password invalid/jce-policy: illegal-key-size)", e);
        }
        Debugger.handshaker.debug("Find the PrivateKeyEntry({}) from builders Finished.", (Object)alias);
        if (entryResult != null) {
            this.entryCacheMap.put(alias, new SoftReference<KeyStore.PrivateKeyEntry>(entryResult));
            if (Debugger.handshaker.isDebugEnabled()) {
                Debugger.handshaker.debug("Find the PrivateKeyEntry({}) from builders, and current caches is {}", (Object)alias, (Object)this.entryCacheMap.size());
            }
        }
        return entryResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final KeyStore.PrivateKeyEntry findPrivateKeyEntryFromCache(String alias) {
        Debugger.handshaker.debug("Find the PrivateKeyEntry({}) from cache running...", (Object)alias);
        boolean findFlag = false;
        try {
            KeyStore.PrivateKeyEntry entryResult;
            if (alias == null) {
                KeyStore.PrivateKeyEntry privateKeyEntry = null;
                return privateKeyEntry;
            }
            Reference<KeyStore.PrivateKeyEntry> ref = this.entryCacheMap.get(alias);
            KeyStore.PrivateKeyEntry privateKeyEntry = entryResult = ref != null ? ref.get() : null;
            if (entryResult != null) {
                findFlag = true;
            }
            KeyStore.PrivateKeyEntry privateKeyEntry2 = entryResult;
            return privateKeyEntry2;
        }
        finally {
            Debugger.handshaker.debug("Find the PrivateKeyEntry({}) from cache Finished findFlag={}", (Object)alias, (Object)findFlag);
        }
    }

    private final KeyStore.PrivateKeyEntry findPrivateKeyEntryFromBuilders(List<KeyStore.Builder> builders, String alias) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableEntryException {
        if (builders == null || alias == null) {
            return null;
        }
        int firstDot = alias.indexOf(46);
        int secondDot = alias.indexOf(46, firstDot + 1);
        if (firstDot == -1 || secondDot == firstDot) {
            return null;
        }
        KeyStore.PrivateKeyEntry entryResult = null;
        int builderIndex = Integer.parseInt(alias.substring(firstDot + 1, secondDot));
        String keyStoreAlias = alias.substring(secondDot + 1);
        KeyStore.Builder builder = builders.get(builderIndex);
        KeyStore keystore = builder.getKeyStore();
        KeyStore.Entry entry = keystore.getEntry(keyStoreAlias, builder.getProtectionParameter(alias));
        if (entry instanceof KeyStore.PrivateKeyEntry) {
            entryResult = (KeyStore.PrivateKeyEntry)entry;
        }
        return entryResult;
    }

    private final String chooseBestAlias(String[] keyTypes, Principal[] issuers, CertCheckType checkType, GMAlgorithmConstraints constraints) {
        String alias = null;
        String[] aliases = this.findAliases(keyTypes, issuers, checkType, constraints, false, true);
        if (aliases != null && aliases.length > 0) {
            alias = aliases[0];
        }
        return alias;
    }

    private final String[] findAliases(String[] keyTypes, Principal[] issuers, CertCheckType checkType, GMAlgorithmConstraints constraints) {
        return this.findAliases(keyTypes, issuers, checkType, constraints, true, false);
    }

    private final String[] findAliases(String[] keyTypes, Principal[] issuers, CertCheckType checkType, GMAlgorithmConstraints constraints, boolean findAll, boolean chooseBestFlag) {
        if (keyTypes == null || keyTypes.length == 0) {
            return null;
        }
        ArrayList<CertKeyType> keyTypeList = new ArrayList<CertKeyType>();
        if (keyTypes != null) {
            for (String keyType : keyTypes) {
                if (keyType == null) continue;
                keyTypeList.add(new CertKeyType(keyType));
            }
        }
        if (keyTypeList.size() == 0) {
            return null;
        }
        HashSet<Principal> issuerSet = new HashSet<Principal>();
        if (issuers != null && issuers.length > 0) {
            for (Principal issuer : issuers) {
                if (issuer == null) continue;
                issuerSet.add(issuer);
            }
        }
        ArrayList<CertKeyEntryStatus> allResults = new ArrayList<CertKeyEntryStatus>();
        List<CertKeyEntryStatus> results = null;
        CertKeyEntryStatus status = null;
        int builderNumber = this.builders.size();
        for (int builderIndex = 0; builderIndex < builderNumber; ++builderIndex) {
            try {
                results = this.getAliases(builderIndex, keyTypeList, issuerSet, findAll, checkType, constraints);
                if (results == null || results.size() <= 0) continue;
                if (chooseBestFlag) {
                    status = results.get(0);
                    if (status == null) continue;
                    if (status.checkResult == CertCheckResult.OK) {
                        Debugger.handshaker.debug("KeyManager Find the best alias={}", (Object)status);
                        allResults.clear();
                        allResults.add(status);
                        break;
                    }
                    status = null;
                }
                allResults.addAll(results);
                continue;
            }
            catch (GMCertificateNotYetValidException e) {
                Debugger.handshaker.warn("KeyManager getAliases return NotYetValid: {}", (Object)builderIndex, (Object)e);
                throw e;
            }
            catch (GMCertificateExpiredException e) {
                Debugger.handshaker.warn("KeyManager getAliases return Expired: {}", (Object)builderIndex, (Object)e);
                throw e;
            }
            catch (GMCertificateException e) {
                Debugger.handshaker.warn("KeyManager getAliases failed: {}", (Object)builderIndex, (Object)e);
                throw e;
            }
            catch (Exception e) {
                Debugger.handshaker.warn("KeyManager getAliases failed: {}", (Object)builderIndex, (Object)e);
                throw new SecurityException("aliases failed", e);
            }
        }
        String[] aliases = null;
        if (allResults.isEmpty()) {
            Debugger.handshaker.debug("KeyManager no matching alias found");
        } else {
            Collections.sort(allResults);
            Debugger.handshaker.debug("KeyManager: no good matching key found, returning best match out of: {}", allResults);
            aliases = this.toAliases(allResults);
        }
        return aliases;
    }

    private final String[] toAliases(List<CertKeyEntryStatus> results) {
        String[] aliases = null;
        if (results == null) {
            aliases = new String[]{};
        } else {
            aliases = new String[results.size()];
            int i = 0;
            for (CertKeyEntryStatus result : results) {
                aliases[i++] = this.makeAlias(result);
            }
        }
        return aliases;
    }

    private List<CertKeyEntryStatus> getAliases(int builderIndex, List<CertKeyType> keyTypes, Set<Principal> issuers, boolean findAll, CertCheckType checkType, GMAlgorithmConstraints constraints) throws GMCertificateException, Exception {
        ArrayList<CertKeyEntryStatus> results = new ArrayList<CertKeyEntryStatus>(2);
        Date currentTime = new Date();
        KeyStore.Builder builder = this.builders.get(builderIndex);
        Loggings.datashaker.debug("GetAliases builder->{}", (Object)builder);
        KeyStore keystore = builder.getKeyStore();
        Enumeration<String> aliases = keystore.aliases();
        Loggings.datashaker.debug("GetAliases keystore->{}->{}", (Object)keystore, (Object)keystore.size());
        String alias = null;
        boolean signerFlag = false;
        boolean cipherFlag = false;
        Certificate[] chain = null;
        while (aliases.hasMoreElements()) {
            alias = aliases.nextElement();
            Loggings.datashaker.debug("Find alias {}", (Object)alias);
            if (!keystore.isKeyEntry(alias)) {
                Loggings.datashaker.debug("Ignoring alias {}: not KeyEntry", (Object)alias);
                continue;
            }
            chain = keystore.getCertificateChain(alias);
            if (chain == null || chain.length == 0) {
                Loggings.datashaker.debug("Ignoring alias {}: chain==null", (Object)alias);
                continue;
            }
            if (!this.conformsToX509Format(chain)) {
                Loggings.datashaker.debug("Ignoring alias {}: chain does not match", (Object)alias);
                continue;
            }
            int keyIndex = this.conformsToKeyType(chain, keyTypes);
            if (keyIndex == -1) {
                Loggings.datashaker.debug("Ignoring alias {}: key algorithm does not match", (Object)alias);
                continue;
            }
            if (!this.conformsToIssuers(chain, issuers)) {
                Loggings.datashaker.debug("Ignoring alias {}: issuers does not match", (Object)alias);
                continue;
            }
            if (!this.conformsToAlgorithmConstraints(chain, constraints)) {
                Loggings.datashaker.debug("Ignoring alias {}: ertificate list does not conform to algorithm constraints", (Object)alias);
                continue;
            }
            X509Certificate cert = (X509Certificate)chain[0];
            CertCheckResult checkResult = checkType.check(cert, currentTime);
            switch (checkResult) {
                case NOTYETVALID: {
                    SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ssZ");
                    String message = String.format("NotYetValid SN=%s,NotBefore=%s,servTime=%s", cert.getSerialNumber().toString(16), dateFormat.format(cert.getNotBefore()), dateFormat.format(currentTime));
                    Loggings.datashaker.error("Ignoring alias {}: {}", (Object)alias, (Object)message);
                    throw new GMCertificateNotYetValidException(message);
                }
                case EXPIRED: {
                    SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ssZ");
                    String message = String.format("Expired SN=%s,NotAfter=%s,servTime=%s", cert.getSerialNumber().toString(16), dateFormat.format(cert.getNotAfter()), dateFormat.format(currentTime));
                    Loggings.datashaker.error("Ignoring alias {}: {}", (Object)alias, (Object)message);
                    throw new GMCertificateExpiredException(message);
                }
            }
            if (alias.endsWith("@signer")) {
                Loggings.datashaker.debug("find signer alias {}", (Object)alias);
                signerFlag = true;
            } else if (alias.endsWith("@cipher")) {
                Loggings.datashaker.debug("find cipher alias {}", (Object)alias);
                cipherFlag = true;
            }
            results.add(new CertKeyEntryStatus(builderIndex, keyIndex, alias, chain, checkResult));
        }
        if (!signerFlag) {
            Loggings.datashaker.warn("missing signer cert for issuers={}", issuers);
        }
        if (!cipherFlag) {
            Loggings.datashaker.warn("missing cipher cert for issuers={}", issuers);
        }
        return results;
    }

    private final boolean conformsToX509Format(Certificate[] chain) {
        boolean valid = true;
        if (chain == null || chain.length == 0) {
            valid = false;
        } else {
            for (Certificate cert : chain) {
                if (cert != null && cert instanceof X509Certificate) continue;
                valid = false;
                break;
            }
        }
        return valid;
    }

    private final int conformsToKeyType(Certificate[] chain, List<CertKeyType> keyTypes) {
        int keyIndex = -1;
        int j = 0;
        for (CertKeyType keyType : keyTypes) {
            if (keyType.matches(chain)) {
                keyIndex = j;
                break;
            }
            ++j;
        }
        return keyIndex;
    }

    private final boolean conformsToIssuers(Certificate[] chain, Set<Principal> issuers) {
        boolean found = true;
        if (issuers == null || issuers.size() == 0) {
            found = true;
        } else {
            found = false;
            for (Certificate cert : chain) {
                if (cert == null || !issuers.contains(((X509Certificate)cert).getIssuerX500Principal())) continue;
                found = true;
                break;
            }
        }
        return found;
    }

    private boolean conformsToAlgorithmConstraints(Certificate[] chain, GMAlgorithmConstraints constraints) {
        boolean valid = true;
        if (constraints == null) {
            valid = true;
        } else {
            GMAlgorithmChecker checker = new GMAlgorithmChecker(constraints);
            try {
                checker.init(false);
            }
            catch (CertPathValidatorException cpve) {
                valid = false;
            }
            if (valid) {
                for (int i = chain.length - 1; i >= 0; --i) {
                    Certificate cert = chain[i];
                    try {
                        checker.check(cert, Collections.<String>emptySet());
                        continue;
                    }
                    catch (CertPathValidatorException cpve) {
                        valid = false;
                        break;
                    }
                }
            }
        }
        return valid;
    }
}

