/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.tls.sun.security.ssl.manager;

import cfca.sadk.tls.sun.security.ssl.manager.LRULinkedHashMap;
import cfca.sadk.tls.sun.security.util.GMSSLConstants;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Map;

class LRUTrustCerts {
    static final LRUTrustCerts INSTANCE = new LRUTrustCerts();
    private final Map<String, X509Certificate[]> clientCacheMap;
    private final Map<String, X509Certificate[]> serverCacheMap;
    private static final long DEVIATION_MS_TIME = 1000L * (long)GMSSLConstants.certValidateDeviationSeconds;

    private LRUTrustCerts() {
        int cacheSize = GMSSLConstants.cacheSizeOfCerts;
        this.clientCacheMap = Collections.synchronizedMap(new LRULinkedHashMap(cacheSize));
        this.serverCacheMap = Collections.synchronizedMap(new LRULinkedHashMap(cacheSize));
    }

    public X509Certificate[] findTrustedChain(X509Certificate[] chain, boolean isClient) throws CertificateException {
        X509Certificate[] trustedChain = null;
        if (chain != null && chain.length != 0) {
            String key = this.buildSNWithDN(chain[0]);
            X509Certificate[] x509CertificateArray = trustedChain = isClient ? this.clientCacheMap.get(key) : this.serverCacheMap.get(key);
            if (trustedChain != null) {
                LRUTrustCerts.checkCertDate(trustedChain[0]);
            }
        }
        return trustedChain;
    }

    public X509Certificate[] putTrustedChain(X509Certificate[] chain, boolean isClient) {
        X509Certificate[] trustedChain = chain;
        if (chain != null && chain.length != 0) {
            String key = this.buildSNWithDN(chain[0]);
            trustedChain = isClient ? this.clientCacheMap.put(key, chain) : this.serverCacheMap.put(key, chain);
        }
        return trustedChain;
    }

    private String buildSNWithDN(X509Certificate cert) {
        return new StringBuilder(128).append(cert.getSerialNumber().toString(16)).append(cert.getSubjectX500Principal()).toString();
    }

    private static void checkCertDate(X509Certificate cert) throws CertificateException {
        Date current = new Date();
        Date notBefore = cert.getNotBefore();
        if (notBefore.after(current) && !LRUTrustCerts.check(current, notBefore)) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ssZ");
            throw new CertificateNotYetValidException(dateFormat.format(notBefore));
        }
        Date notAfter = cert.getNotAfter();
        if (current.after(notAfter) && !LRUTrustCerts.check(current, notAfter)) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ssZ");
            throw new CertificateExpiredException(dateFormat.format(notAfter));
        }
    }

    private static boolean check(Date date, Date cert) {
        return Math.abs(date.getTime() - cert.getTime()) < DEVIATION_MS_TIME;
    }
}

