/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.tls.sun.security.ssl.message;

import cfca.sadk.tls.pure.ISignature;
import cfca.sadk.tls.pure.impl.SM2Helper;
import cfca.sadk.tls.pure.impl.SM2Signature;
import cfca.sadk.tls.sun.security.ssl.Debugger;
import cfca.sadk.tls.sun.security.ssl.HandshakeInStream;
import cfca.sadk.tls.sun.security.ssl.HandshakeOutStream;
import cfca.sadk.tls.sun.security.ssl.ProtocolVersion;
import cfca.sadk.tls.sun.security.ssl.message.HandshakeMessage;
import cfca.sadk.tls.sun.security.ssl.sec.HandshakeHash;
import cfca.sadk.tls.sun.security.ssl.sec.SignatureAndHashAlgorithm;
import cfca.sadk.tls.util.Hex;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.util.List;
import javax.crypto.SecretKey;

public final class CertificateVerify
extends HandshakeMessage {
    private byte[] signatureBytes;
    private ProtocolVersion protocolVersion;
    private HandshakeHash handshakeHash;
    private ISignature signature = null;

    public CertificateVerify(ProtocolVersion protocolVersion, HandshakeHash handshakeHash, PrivateKey signingKey, SecretKey masterKey, SignatureAndHashAlgorithm signatureAlgorithm, SecureRandom random) throws Exception {
        this.protocolVersion = protocolVersion;
        this.handshakeHash = handshakeHash;
        this.signature = this.signatureFrom(protocolVersion, handshakeHash, signingKey);
        this.signature.initSign(signingKey);
        this.signatureUpdate(protocolVersion, handshakeHash, masterKey);
        this.signatureBytes = this.signature.sign();
    }

    public CertificateVerify(ProtocolVersion protocolVersion, HandshakeHash handshakeHash, HandshakeInStream in, List<SignatureAndHashAlgorithm> signatureAlgorithmItems) throws IOException {
        this.protocolVersion = protocolVersion;
        this.handshakeHash = handshakeHash;
        this.signatureBytes = in.getBytes16();
    }

    public boolean verify(PublicKey publicKey, SecretKey masterKey) throws Exception {
        this.signature = this.signatureFrom(this.protocolVersion, this.handshakeHash, publicKey);
        this.signature.initVerify(publicKey);
        this.signatureUpdate(this.protocolVersion, this.handshakeHash, masterKey);
        return this.signature.verify(this.signatureBytes);
    }

    private final ISignature signatureFrom(ProtocolVersion protocolVersion, HandshakeHash handshakeHash, Key key) throws Exception {
        String algorithm = key.getAlgorithm().toUpperCase();
        SM2Signature signature = null;
        if (!SM2Helper.isSM2Type(algorithm)) {
            throw new SignatureException("Unrecognized algorithm: " + algorithm);
        }
        signature = new SM2Signature();
        return signature;
    }

    final void signatureUpdate(ProtocolVersion protocolVersion, HandshakeHash handshakeHash, SecretKey masterKey) throws Exception {
        if (protocolVersion.isChinaTLS11()) {
            byte[] hash = handshakeHash.getFinishedHash();
            if (Debugger.handshaker.isDebugEnabled()) {
                Debugger.handshaker.debug("handshakeHash: 0x{}", (Object)Hex.hexify(hash));
            }
            this.signature.update(hash);
            return;
        }
        throw new GeneralSecurityException("Only GMTLS 1.1 supported");
    }

    @Override
    public final int messageType() {
        return 15;
    }

    @Override
    final int messageLength() {
        int length = 2;
        return length + this.signatureBytes.length;
    }

    @Override
    final void send(HandshakeOutStream out) throws IOException {
        out.putBytes16(this.signatureBytes);
    }

    public final String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("\n*** CertificateVerify");
        builder.append("\n***");
        return builder.toString();
    }
}

