/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.tls.sun.security.validator;

import cfca.sadk.system.SADKDebugger;
import cfca.sadk.tls.sun.security.ssl.Debugger;
import cfca.sadk.tls.sun.security.ssl.manager.CertKeyUsage;
import cfca.sadk.tls.sun.security.validator.TLSValidatorException;
import cfca.sadk.tls.sun.security.validator.TLSValidatorVariant;
import cfca.sadk.tls.util.Loggings;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;

final class TLSKeyUsageChecker {
    private static final String OID_EKU_TLS_SERVER = "1.3.6.1.5.5.7.3.1";
    private static final String OID_EKU_TLS_CLIENT = "1.3.6.1.5.5.7.3.2";
    private static final String OID_EKU_ANY_USAGE = "2.5.29.37.0";
    private static final String OID_EKU_NS_SGC = "2.16.840.1.113730.4.1";
    private static final String OID_EKU_MS_SGC = "1.3.6.1.4.1.311.10.3.3";
    private static final String OID_SUBJECT_ALT_NAME = "2.5.29.17";
    private static final CertKeyUsage.KeyUsage KU_SIGNATURE = CertKeyUsage.KeyUsage.digitalSignature;
    private static final CertKeyUsage.KeyUsage KU_KEY_ENCIPHERMENT = CertKeyUsage.KeyUsage.keyEncipherment;
    private static final CertKeyUsage.KeyUsage KU_KEY_AGREEMENT = CertKeyUsage.KeyUsage.keyAgreement;
    private static final Collection<String> KU_SERVER_SIGNATURE = Arrays.asList("SM2PKEA_SM2DSA");
    private static final Collection<String> KU_SERVER_ENCRYPTION = Arrays.asList("SM2PKEA_SM2DSA");
    private static final Collection<String> KU_SERVER_KEY_AGREEMENT = Arrays.asList("ECDHE_SM2DSA");
    private final TLSValidatorVariant variant;

    private TLSKeyUsageChecker(TLSValidatorVariant variant) {
        this.variant = variant;
    }

    static TLSKeyUsageChecker getInstance(TLSValidatorVariant variant) {
        return new TLSKeyUsageChecker(variant);
    }

    final void check(X509Certificate cert, Object parameter) throws CertificateException {
        block8: {
            block7: {
                if (!(parameter instanceof String)) break block7;
                if (Loggings.INFO.isInfoEnabled()) {
                    StringBuilder buffer = new StringBuilder();
                    buffer.append("check<<<<<<Running");
                    buffer.append("\n cert: ");
                    buffer.append(Debugger.dump(cert));
                    buffer.append("\n parameter: ");
                    buffer.append(SADKDebugger.dump((String)((String)parameter)));
                    Loggings.INFO.info(buffer.toString());
                }
                if (cert == null) {
                    return;
                }
                if (this.variant == null) {
                    throw new CertificateException("Unknown variant: " + (Object)((Object)this.variant));
                }
                switch (this.variant) {
                    case TLS_SERVER: {
                        this.checkTLSServer(cert, (String)parameter);
                        break block8;
                    }
                    case TLS_CLIENT: {
                        this.checkTLSClient(cert);
                        break block8;
                    }
                    default: {
                        throw new CertificateException("Unknown variant: " + (Object)((Object)this.variant));
                    }
                }
            }
            throw new CertificateException("parameter required String type! ");
        }
    }

    private final void checkTLSClient(X509Certificate cert) throws CertificateException {
        if (Loggings.INFO.isInfoEnabled()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("checkTLSClient<<<<<<Running");
            buffer.append("\n cert: ");
            buffer.append(Debugger.dump(cert));
            Loggings.INFO.info(buffer.toString());
        }
        try {
            if (!this.checkKeyUsage(cert, KU_SIGNATURE)) {
                throw new TLSValidatorException("KeyUsage does not allow digital signatures", TLSValidatorException.T_EE_EXTENSIONS, cert);
            }
            if (!this.checkExtendedKeyUsage(cert, OID_EKU_TLS_CLIENT)) {
                throw new TLSValidatorException("Extended key usage does not permit use for TLS client authentication", TLSValidatorException.T_EE_EXTENSIONS, cert);
            }
            Set<String> exts = this.getCriticalExtensions(cert);
            exts.remove("2.5.29.15");
            exts.remove("2.5.29.37");
            exts.remove("2.16.840.1.113730.1.1");
            this.checkRemainingExtensions(exts);
        }
        catch (TLSValidatorException e) {
            if (Loggings.INFO.isInfoEnabled()) {
                StringBuilder buffer = new StringBuilder();
                buffer.append("checkTLSClient<<<<<<Failure");
                buffer.append("\n cert: ");
                buffer.append(Debugger.dump(cert));
                Loggings.INFO.info(buffer.toString());
            }
            throw e;
        }
        catch (CertificateException e) {
            if (Loggings.INFO.isInfoEnabled()) {
                StringBuilder buffer = new StringBuilder();
                buffer.append("checkTLSClient<<<<<<Failure");
                buffer.append("\n cert: ");
                buffer.append(Debugger.dump(cert));
                Loggings.INFO.info(buffer.toString());
            }
            throw e;
        }
    }

    private final void checkTLSServer(X509Certificate cert, String parameter) throws CertificateException {
        if (Loggings.INFO.isInfoEnabled()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("checkTLSServer<<<<<<Running");
            buffer.append("\n cert: ");
            buffer.append(Debugger.dump(cert));
            buffer.append("\n parameter: ");
            buffer.append(SADKDebugger.dump((String)parameter));
            Loggings.INFO.info(buffer.toString());
        }
        try {
            Set<String> exts = this.getCriticalExtensions(cert);
            if (exts.size() != 0) {
                if (KU_SERVER_ENCRYPTION.contains(parameter)) {
                    if (!this.checkKeyUsage(cert, KU_KEY_ENCIPHERMENT)) {
                        throw new TLSValidatorException("KeyUsage does not allow key encipherment", TLSValidatorException.T_EE_EXTENSIONS, cert);
                    }
                } else if (KU_SERVER_SIGNATURE.contains(parameter)) {
                    if (!this.checkKeyUsage(cert, KU_SIGNATURE)) {
                        throw new TLSValidatorException("KeyUsage does not allow digital signatures", TLSValidatorException.T_EE_EXTENSIONS, cert);
                    }
                } else if (KU_SERVER_KEY_AGREEMENT.contains(parameter)) {
                    if (!this.checkKeyUsage(cert, KU_KEY_AGREEMENT)) {
                        throw new TLSValidatorException("KeyUsage does not allow key agreement", TLSValidatorException.T_EE_EXTENSIONS, cert);
                    }
                } else {
                    throw new CertificateException("Unknown authType: " + parameter);
                }
            }
            if (!(this.checkExtendedKeyUsage(cert, OID_EKU_TLS_SERVER) || this.checkExtendedKeyUsage(cert, OID_EKU_MS_SGC) || this.checkExtendedKeyUsage(cert, OID_EKU_NS_SGC))) {
                throw new TLSValidatorException("Extended key usage does not permit use for TLS server authentication", TLSValidatorException.T_EE_EXTENSIONS, cert);
            }
            exts.remove("2.5.29.15");
            exts.remove("2.5.29.37");
            exts.remove("2.16.840.1.113730.1.1");
            this.checkRemainingExtensions(exts);
        }
        catch (TLSValidatorException e) {
            if (Loggings.INFO.isInfoEnabled()) {
                StringBuilder buffer = new StringBuilder();
                buffer.append("checkTLSServer<<<<<<Failure");
                buffer.append("\n cert: ");
                buffer.append(Debugger.dump(cert));
                Loggings.INFO.info(buffer.toString(), (Throwable)e);
            }
            throw e;
        }
        catch (CertificateException e) {
            if (Loggings.INFO.isInfoEnabled()) {
                StringBuilder buffer = new StringBuilder();
                buffer.append("checkTLSServer<<<<<<Failure");
                buffer.append("\n cert: ");
                buffer.append(Debugger.dump(cert));
                Loggings.INFO.info(buffer.toString(), (Throwable)e);
            }
            throw e;
        }
    }

    private final Set<String> getCriticalExtensions(X509Certificate cert) {
        if (Loggings.INFO.isInfoEnabled()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("getCriticalExtensions<<<<<<Running");
            buffer.append("\n cert: ");
            buffer.append(Debugger.dump(cert));
            Loggings.INFO.info(buffer.toString());
        }
        Set<String> exts = null;
        if (cert != null) {
            exts = cert.getCriticalExtensionOIDs();
        }
        if (exts == null) {
            exts = Collections.emptySet();
        }
        return exts;
    }

    private final boolean checkKeyUsage(X509Certificate cert, CertKeyUsage.KeyUsage kUsage) throws CertificateException {
        return true;
    }

    private final boolean checkExtendedKeyUsage(X509Certificate cert, String expectedEKU) throws CertificateException {
        List<String> eku;
        if (Loggings.INFO.isInfoEnabled()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("checkExtendedKeyUsage<<<<<<Running");
            buffer.append("\n cert: ");
            buffer.append(Debugger.dump(cert));
            buffer.append("\n expectedEKU: ");
            buffer.append(SADKDebugger.dump((String)expectedEKU));
            Loggings.INFO.info(buffer.toString());
        }
        boolean bool = true;
        if (cert != null && expectedEKU != null && (eku = cert.getExtendedKeyUsage()) != null && eku.size() != 0) {
            bool = eku.contains(expectedEKU) || eku.contains(OID_EKU_ANY_USAGE);
        }
        return bool;
    }

    private final void checkRemainingExtensions(Set<String> exts) throws CertificateException {
        if (exts != null) {
            exts.remove("2.5.29.19");
            exts.remove(OID_SUBJECT_ALT_NAME);
            if (!exts.isEmpty()) {
                throw new CertificateException("Certificate contains unsupported  critical extensions: " + exts);
            }
        }
    }
}

