/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.tls.sun.security.validator;

import cfca.sadk.tls.sun.security.validator.GMCertificateExpiredException;
import cfca.sadk.tls.sun.security.validator.GMCertificateNotYetValidException;
import cfca.sadk.tls.sun.security.validator.GMCertificateSignatureException;
import cfca.sadk.tls.sun.security.validator.TLSValidator;
import cfca.sadk.tls.sun.security.validator.TLSValidatorException;
import cfca.sadk.tls.util.Loggings;
import cfca.sadk.x509.certificate.X509Cert;
import java.io.IOException;
import java.security.PublicKey;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;

abstract class TrustAnchorHelper {
    TrustAnchorHelper() {
    }

    protected static TrustAnchor findTrustAnchor(X509Certificate cert, Set<TrustAnchor> trustAnchors) throws Exception {
        TrustAnchor trust = null;
        PublicKey trustPublicKey = null;
        Exception invalidKeyEx = null;
        X500Principal certIssuer = cert.getIssuerX500Principal();
        X509CertSelector certSelectX509 = new X509CertSelector();
        certSelectX509.setCertificate(cert);
        try {
            certSelectX509.setSubject(certIssuer.getEncoded());
        }
        catch (IOException ex) {
            throw new CertificateException("Cannot set subject search criteria for trust anchor.", ex);
        }
        Iterator<TrustAnchor> iter = trustAnchors.iterator();
        while (iter.hasNext() && trust == null) {
            block15: {
                trust = iter.next();
                if (trust.getTrustedCert() != null) {
                    if (TrustAnchorHelper.match(certSelectX509.getCertificate(), trust.getTrustedCert())) {
                        trustPublicKey = trust.getTrustedCert().getPublicKey();
                    } else {
                        trust = null;
                    }
                } else if (trust.getCAName() != null && trust.getCAPublicKey() != null) {
                    try {
                        X500Principal caName = new X500Principal(trust.getCAName());
                        if (certIssuer.equals(caName)) {
                            trustPublicKey = trust.getCAPublicKey();
                            break block15;
                        }
                        trust = null;
                    }
                    catch (IllegalArgumentException ex) {
                        trust = null;
                    }
                } else {
                    trust = null;
                }
            }
            if (trustPublicKey == null) continue;
            try {
                cert.verify(trustPublicKey);
            }
            catch (Exception ex) {
                invalidKeyEx = ex;
                trust = null;
                trustPublicKey = null;
            }
        }
        if (trust == null && invalidKeyEx != null) {
            throw new CertificateException("TrustAnchor found but certificate validation failed.", invalidKeyEx);
        }
        return trust;
    }

    public static boolean match(X509Certificate cert, X509Certificate trustCert) throws Exception {
        boolean issuerDNMatch;
        X509Cert xcert = new X509Cert(cert.getEncoded());
        X509Cert x509TrustCert = new X509Cert(trustCert.getEncoded());
        boolean issuerKeyidMatch = true;
        if (x509TrustCert.getSubjectKeyIdentifier() != null) {
            issuerKeyidMatch = x509TrustCert.getSubjectKeyIdentifier().equals((Object)xcert.getAuthorityKeyIdentifier());
        }
        if (!(issuerDNMatch = x509TrustCert.getSubjectX500Name().equals((Object)xcert.getIssuerX500Name())) && !issuerKeyidMatch) {
            Loggings.INFO.info("ValidatorHelper.match:  issuer DNs and KeyIdentifiers don't match");
            return false;
        }
        try {
            TLSValidator.validate(xcert);
        }
        catch (GMCertificateNotYetValidException e) {
            Loggings.handshaker.warn("peer validate failed: {}", (Object)e.getMessage());
            throw e;
        }
        catch (GMCertificateExpiredException e) {
            Loggings.handshaker.warn("peer validate failed: {}", (Object)e.getMessage());
            throw e;
        }
        boolean signResult = xcert.verify(x509TrustCert.getPublicKey());
        if (!signResult) {
            String message = String.format("SN:%s@DN:%s not trust by IssuerDN:%s", xcert.getStringSerialNumber(), xcert.getSubject(), xcert.getIssuer());
            Loggings.handshaker.warn(message);
            throw new GMCertificateSignatureException(message);
        }
        return true;
    }

    static final X509Certificate[] toArray(CertPath path, TrustAnchor anchor) throws CertificateException {
        X509Certificate[] chain = null;
        if (path == null || anchor == null) {
            chain = TLSValidator.CHAIN0;
        } else {
            List<? extends Certificate> certs = path.getCertificates();
            chain = new X509Certificate[certs.size() + 1];
            certs.toArray(chain);
            X509Certificate trustedCert = anchor.getTrustedCert();
            if (trustedCert == null) {
                throw new TLSValidatorException("TrustAnchor must be specified as certificate");
            }
            chain[chain.length - 1] = trustedCert;
        }
        return chain;
    }

    static final X509Certificate[] toArray(X509Certificate[] x509Certs, TrustAnchor anchor) throws CertificateException {
        X509Certificate[] chain = null;
        if (x509Certs == null || anchor == null) {
            chain = TLSValidator.CHAIN0;
        } else {
            List<X509Certificate> certs = Arrays.asList(x509Certs);
            chain = new X509Certificate[certs.size() + 1];
            certs.toArray(chain);
            X509Certificate trustedCert = anchor.getTrustedCert();
            if (trustedCert == null) {
                throw new TLSValidatorException("TrustAnchor must be specified as certificate");
            }
            chain[chain.length - 1] = trustedCert;
        }
        return chain;
    }
}

