/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.tls.util;

import java.nio.ByteBuffer;

public final class Hex {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final char[] HEXCHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final char[] hexchars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    private static final void deleteLastLineSeparator(StringBuilder buff) {
        if (buff == null) {
            return;
        }
        int start = buff.length() - LINE_SEPARATOR.length();
        if (start < 0) {
            return;
        }
        if (LINE_SEPARATOR.equals(buff.substring(start))) {
            buff.delete(start, buff.length());
        }
    }

    private static final StringBuilder hexify(long value, int len) {
        StringBuilder builder = new StringBuilder("");
        for (int end = len - 1; end >= 0; --end) {
            builder.append(HEXCHARS[(int)(value >> end * 4 & 0xFL)]);
        }
        return builder;
    }

    public static final StringBuilder dump(String linePrefix, ByteBuffer data) {
        if (data == null) {
            return new StringBuilder("");
        }
        return Hex.dump(linePrefix, data.array(), data.position(), data.remaining());
    }

    public static final StringBuilder dump(String linePrefix, byte[] data) {
        if (data == null) {
            return new StringBuilder("");
        }
        return Hex.dump(linePrefix, data, 0, data.length);
    }

    public static final StringBuilder dump(String linePrefix, byte[] data, int offset, int len) {
        int end;
        if (data == null) {
            return new StringBuilder("");
        }
        if (len <= 0 || offset >= data.length) {
            return new StringBuilder("");
        }
        if (offset < 0) {
            offset = 0;
        }
        if ((end = offset + len) > data.length) {
            end = data.length;
        }
        int countLines = linePrefix == null ? 80 : 80 + linePrefix.length();
        int capacity = (data.length + 15) / 16 * countLines;
        char[] ascii = new char[16];
        StringBuilder out = new StringBuilder(capacity);
        int i = offset;
        while (i < end) {
            out.append(linePrefix);
            out.append((CharSequence)Hex.hexify(i, 8));
            out.append(":  ");
            int j = 0;
            while (j < 16) {
                if (i < data.length) {
                    byte b = (byte)(data[i] & 0xFF);
                    if (j == 7) {
                        out.append((CharSequence)Hex.hexify(b, 2)).append("  ");
                    } else {
                        out.append((CharSequence)Hex.hexify(b, 2)).append(" ");
                    }
                    ascii[j] = b >= 32 && b < 127 ? (int)b : 46;
                } else {
                    out.append(" ");
                    ascii[j] = 32;
                }
                ++j;
                ++i;
            }
            out.append(' ').append(ascii).append(LINE_SEPARATOR);
        }
        Hex.deleteLastLineSeparator(out);
        return out;
    }

    public static final String hexify(byte[] data) {
        if (data == null) {
            return "";
        }
        return Hex.hexify(data, 0, data.length);
    }

    public static final String hexify(byte[] data, int offset, int length) {
        if (data == null || data.length < offset) {
            return "";
        }
        StringBuilder builder = new StringBuilder(data.length * 2);
        int k = 0;
        int n = 0;
        for (int i = offset; i < data.length && n < length; ++n, ++i) {
            k = data[i] & 0xFF;
            builder.append(hexchars[k >>> 4]);
            builder.append(hexchars[k & 0xF]);
        }
        return builder.toString();
    }
}

