/*
 * Decompiled with CFR 0.152.
 */
package com.cq1080.universal.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class UnzipUtil {
    public static boolean unZip(String srcPath, String destPath, boolean includeZipFileName) {
        try {
            ZipInputStream Zin = new ZipInputStream(new FileInputStream(srcPath));
            BufferedInputStream Bin = new BufferedInputStream(Zin);
            if (includeZipFileName) {
                String zipFileName = srcPath.substring(srcPath.lastIndexOf(File.separator));
                zipFileName = zipFileName.substring(0, zipFileName.indexOf("."));
                destPath = destPath + zipFileName;
            }
            File Fout = null;
            try {
                ZipEntry entry;
                while ((entry = Zin.getNextEntry()) != null) {
                    int b;
                    if (entry.isDirectory()) continue;
                    Fout = new File(destPath, entry.getName());
                    if (!Fout.exists()) {
                        new File(Fout.getParent()).mkdirs();
                    }
                    FileOutputStream out = new FileOutputStream(Fout);
                    BufferedOutputStream Bout = new BufferedOutputStream(out);
                    while ((b = Bin.read()) != -1) {
                        Bout.write(b);
                    }
                    Bout.close();
                    out.close();
                }
                Bin.close();
                Zin.close();
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UnzipUtil)) {
            return false;
        }
        UnzipUtil other = (UnzipUtil)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof UnzipUtil;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }

    public String toString() {
        return "UnzipUtil()";
    }
}

