/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.research.trap.utils;

import com.ericsson.research.trap.utils.Future;
import com.ericsson.research.trap.utils.FutureImpl;
import com.ericsson.research.trap.utils.RunnableFuture;
import com.ericsson.research.trap.utils.ThreadPool;
import com.ericsson.research.trap.utils.WeakDelay;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ThreadPoolImpl
extends ThreadPool {
    protected int CACHED_THREADS_MIN = 0;
    protected int CACHED_THREADS_MAX = 2000;
    protected int CACHED_THREADS_TIMEOUT = 60000;
    protected int FIXED_THREADS = 10;
    protected int SCHEDULED_THREADS = 10;
    protected ThreadPoolExecutor cachedPool = new ThreadPoolExecutor(this.CACHED_THREADS_MIN, this.CACHED_THREADS_MAX, this.CACHED_THREADS_TIMEOUT, TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>());
    protected ThreadPoolExecutor fixedPool = new ThreadPoolExecutor(this.FIXED_THREADS, this.FIXED_THREADS, Long.MAX_VALUE, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
    protected ScheduledThreadPoolExecutor scheduledPool = new ScheduledThreadPoolExecutor(this.SCHEDULED_THREADS);
    protected DelayQueue<WeakDelay> weakFutureTasks = new DelayQueue();
    protected Runnable weakFutureExecutor = null;
    static ThreadPoolImpl lastInstance = null;

    public ThreadPoolImpl() {
        this.fixedPool.prestartAllCoreThreads();
        this.scheduledPool.prestartAllCoreThreads();
        lastInstance = this;
    }

    public static String describeState() {
        if (lastInstance == null) {
            return "";
        }
        String cachedStatus = "cachedPool: " + ThreadPoolImpl.describeState(ThreadPoolImpl.lastInstance.cachedPool);
        String fixedStatus = "fixedPool: " + ThreadPoolImpl.describeState(ThreadPoolImpl.lastInstance.fixedPool);
        String scheduledStatus = "scheduledPool: " + ThreadPoolImpl.describeState(ThreadPoolImpl.lastInstance.scheduledPool);
        return cachedStatus + "\n" + fixedStatus + "\n" + scheduledStatus;
    }

    private static String describeState(ThreadPoolExecutor pool) {
        return pool.getActiveCount() + " active, " + pool.getPoolSize() + " pooled, " + pool.getMaximumPoolSize() + " max. " + pool.getQueue().size() + " queued";
    }

    protected Future performSchedule(Runnable task, long delay) {
        return new FutureImpl(this.scheduledPool.schedule(task, delay, TimeUnit.MILLISECONDS));
    }

    protected void performExecuteFixed(Runnable task) {
        try {
            this.fixedPool.submit(task);
        }
        catch (OutOfMemoryError e) {
            try {
                System.out.println("Out Of Memory");
                System.gc();
                Thread.sleep(10L);
                task.run();
                return;
            }
            catch (InterruptedException ie) {
                throw e;
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                throw e;
            }
        }
    }

    protected void performExecuteCached(Runnable task) {
        try {
            this.cachedPool.submit(task);
        }
        catch (RejectedExecutionException e) {
            for (int i = 1; i < 3; ++i) {
                try {
                    Thread.yield();
                    Thread.sleep(i);
                    Thread.yield();
                    this.cachedPool.submit(task);
                    return;
                }
                catch (InterruptedException ie) {
                    throw e;
                }
                catch (RejectedExecutionException e2) {
                    System.out.println("Execution rejected for task; running it in-thread. PoolSize is: " + this.cachedPool.getQueue().size());
                    continue;
                }
            }
            task.run();
        }
        catch (OutOfMemoryError e) {
            System.gc();
            if (this.cachedPool.getActiveCount() < this.CACHED_THREADS_MAX) {
                try {
                    this.setCachedMaxThreads(this.cachedPool.getActiveCount() - 1);
                }
                catch (IllegalArgumentException e1) {
                    throw e;
                }
                try {
                    System.gc();
                    Thread.sleep(100L);
                    this.performExecuteCached(task);
                }
                catch (InterruptedException interruptedException) {}
            }
            throw e;
        }
    }

    protected void setCachedMaxThreads(int newThreads) {
        this.CACHED_THREADS_MAX = newThreads;
        this.cachedPool.setMaximumPoolSize(newThreads);
        System.out.println("Setting new thread size: " + newThreads);
    }

    protected void finalize() throws Throwable {
        System.out.println("Final...");
        super.finalize();
        this.cachedPool.shutdownNow();
        this.fixedPool.shutdownNow();
        this.scheduledPool.shutdownNow();
        System.gc();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Future performWeakExecuteAfter(Runnable task, long delay) {
        RunnableFuture future = new RunnableFuture(task);
        WeakDelay delayed = new WeakDelay(future, delay);
        this.weakFutureTasks.add(delayed);
        ThreadPoolImpl threadPoolImpl = this;
        synchronized (threadPoolImpl) {
            if (this.weakFutureExecutor == null) {
                this.weakFutureExecutor = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        try {
                            while (!ThreadPoolImpl.this.weakFutureTasks.isEmpty()) {
                                Object delayed = (WeakDelay)ThreadPoolImpl.this.weakFutureTasks.poll(1L, TimeUnit.HOURS);
                                ThreadPool.executeFixed((Runnable)delayed);
                            }
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        finally {
                            ThreadPoolImpl threadPoolImpl = ThreadPoolImpl.this;
                            synchronized (threadPoolImpl) {
                                ThreadPoolImpl.this.weakFutureExecutor = null;
                            }
                        }
                    }
                };
                this.performExecuteCached(this.weakFutureExecutor);
            }
        }
        return future;
    }
}

