/*
 * Decompiled with CFR 0.152.
 */
package com.fasc.open.api.v5_1.client;

import com.fasc.open.api.bean.base.BaseRes;
import com.fasc.open.api.exception.ApiException;
import com.fasc.open.api.v5_1.client.OpenApiClient;
import com.fasc.open.api.v5_1.req.archives.ArchivedListReq;
import com.fasc.open.api.v5_1.req.archives.ArchivesCatalogListReq;
import com.fasc.open.api.v5_1.req.archives.ArchivesDetailReq;
import com.fasc.open.api.v5_1.req.archives.ContactArchivedReq;
import com.fasc.open.api.v5_1.req.archives.CreateOrModifyPerformanceReq;
import com.fasc.open.api.v5_1.req.archives.DeletePerformanceReq;
import com.fasc.open.api.v5_1.req.archives.GetArchivesDownLoadUrlReq;
import com.fasc.open.api.v5_1.req.archives.GetArchivesLedgerDetailReq;
import com.fasc.open.api.v5_1.req.archives.GetArchivesManageUrlReq;
import com.fasc.open.api.v5_1.req.archives.GetArchivesPreviewUrlReq;
import com.fasc.open.api.v5_1.req.archives.GetPerformanceListReq;
import com.fasc.open.api.v5_1.res.archives.ArchivedDetailInfo;
import com.fasc.open.api.v5_1.res.archives.ArchivedListRes;
import com.fasc.open.api.v5_1.res.archives.ArchivesCatalogListRes;
import com.fasc.open.api.v5_1.res.archives.ContactArchivedRes;
import com.fasc.open.api.v5_1.res.archives.CreateOrModifyPerformanceRes;
import com.fasc.open.api.v5_1.res.archives.GetArchiveLedgerDetailRes;
import com.fasc.open.api.v5_1.res.archives.GetArchivesDownLoadUrlRes;
import com.fasc.open.api.v5_1.res.archives.GetArchivesManageUrlRes;
import com.fasc.open.api.v5_1.res.archives.GetArchivesPreviewUrlRes;
import com.fasc.open.api.v5_1.res.archives.GetPerformanceListRes;
import java.util.List;

public class ArchivesPerformanceClient {
    private OpenApiClient openApiClient;

    public ArchivesPerformanceClient(OpenApiClient openApiClient) {
        this.openApiClient = openApiClient;
    }

    public BaseRes<CreateOrModifyPerformanceRes> createOrModifyPerformance(CreateOrModifyPerformanceReq req) throws ApiException {
        return this.openApiClient.invokeApi(req, "POST /archives/performance/modify", CreateOrModifyPerformanceRes.class);
    }

    public BaseRes<Void> deletePerformance(DeletePerformanceReq req) throws ApiException {
        return this.openApiClient.invokeApi(req, "POST /archives/performance/delete", Void.class);
    }

    public BaseRes<List<GetPerformanceListRes>> getPerformanceList(GetPerformanceListReq req) throws ApiException {
        return this.openApiClient.invokeApiList(req, "POST /archives/performance/list", GetPerformanceListRes.class);
    }

    public BaseRes<ContactArchivedRes> contactArchived(ContactArchivedReq req) throws ApiException {
        return this.openApiClient.invokeApi(req, "POST /archives/contact-archived", ContactArchivedRes.class);
    }

    public BaseRes<ArchivedListRes> getArchivedList(ArchivedListReq req) throws ApiException {
        return this.openApiClient.invokeApi(req, "POST /archives/get-archived-list", ArchivedListRes.class);
    }

    public BaseRes<List<ArchivesCatalogListRes>> getArchivesCatalogList(ArchivesCatalogListReq req) throws ApiException {
        return this.openApiClient.invokeApiList(req, "POST /archives/catalog-list", ArchivesCatalogListRes.class);
    }

    public BaseRes<ArchivedDetailInfo> getArchivesDetail(ArchivesDetailReq req) throws ApiException {
        return this.openApiClient.invokeApi(req, "POST /archives/get-archived-detail", ArchivedDetailInfo.class);
    }

    public BaseRes<GetArchivesManageUrlRes> getArchivesManageUrl(GetArchivesManageUrlReq req) throws ApiException {
        return this.openApiClient.invokeApi(req, "POST /archives/get-archives-url", GetArchivesManageUrlRes.class);
    }

    public BaseRes<GetArchiveLedgerDetailRes> getLedGerDetail(GetArchivesLedgerDetailReq req) throws ApiException {
        return this.openApiClient.invokeApi(req, "POST /ledger/get-detail", GetArchiveLedgerDetailRes.class);
    }

    public BaseRes<GetArchivesPreviewUrlRes> getArchivesPreviewUrl(GetArchivesPreviewUrlReq req) throws ApiException {
        return this.openApiClient.invokeApi(req, "POST /archives/get-preview-url", GetArchivesPreviewUrlRes.class);
    }

    public BaseRes<GetArchivesDownLoadUrlRes> getArchivesDownloadUrl(GetArchivesDownLoadUrlReq req) throws ApiException {
        return this.openApiClient.invokeApi(req, "POST /archives/get-download-url", GetArchivesDownLoadUrlRes.class);
    }
}

