/*
 * Decompiled with CFR 0.152.
 */
package com.fadada.sdk.api;

import com.alibaba.fastjson.annotation.JSONField;
import com.fadada.sdk.api.ApiParams;
import com.fadada.sdk.enums.ErrorMessage;
import com.fadada.sdk.exception.SDKException;
import com.fadada.sdk.utils.crypt.FddEncryptTool;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractApiParams
implements ApiParams {
    @JSONField(name="app_id")
    private String appId;
    @JSONField(name="secret")
    private String secret;
    @JSONField(name="v")
    private String v;
    @JSONField(name="msg_digest")
    private String msgDigest;
    @JSONField(name="timestamp")
    private String timestamp;

    @Override
    public Map<String, Object> toMapParams() throws SDKException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        try {
            Class<?> clazz = this.getClass();
            for (Field field : clazz.getDeclaredFields()) {
                JSONField annotation;
                String fieldName = field.getName();
                if (fieldName.equals("serialVersionUID") || (annotation = field.getAnnotation(JSONField.class)) == null) continue;
                Method method = clazz.getMethod("get".concat(this.capitalizeName(fieldName)), new Class[0]);
                String realName = annotation.name();
                if (StringUtils.isNotBlank(realName)) {
                    params.put(realName, method.invoke((Object)this, new Object[0]));
                    continue;
                }
                params.put(fieldName, method.invoke((Object)this, new Object[0]));
            }
            if (params.containsKey("msgDigest")) {
                params.put("msgDigest", this.msgDigest);
            }
            for (Map.Entry m : params.entrySet()) {
                if (m.getValue() != null) continue;
                params.remove(m.getKey());
            }
            this.addCommonMapParams(params);
            return params;
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException var12) {
            throw new SDKException(var12, ErrorMessage.TOPARAM_ERROR);
        }
    }

    protected void addCommonMapParams(Map<String, Object> params) {
        params.put("app_id", this.appId);
        params.put("v", this.v);
        params.put("msg_digest", this.msgDigest);
        params.put("timestamp", this.timestamp);
    }

    private String capitalizeName(String name) {
        char[] ch = name.toCharArray();
        if (ch[0] >= 'a' && ch[0] <= 'z') {
            ch[0] = (char)(ch[0] - 32);
        }
        return new String(ch);
    }

    public abstract String joinContentStr();

    @Override
    public void setCommonParams(String appId, String secret, String v) {
        this.appId = appId;
        this.secret = secret;
        this.v = v;
        this.msgDigest = this.getMsgDigest(this.joinContentStr());
    }

    protected String getMsgDigest(String str) {
        String sha1 = "";
        try {
            this.timestamp = this.getTimeStamp();
            sha1 = FddEncryptTool.sha1(this.appId + FddEncryptTool.md5Digest(this.joinTimeBefore() + this.timestamp + this.joinTimeAfter()) + FddEncryptTool.sha1(this.secret + str) + this.joinFinal());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return new String(FddEncryptTool.Base64Encode(sha1.getBytes()));
    }

    public String joinTimeBefore() {
        return "";
    }

    public String joinTimeAfter() {
        return "";
    }

    public String joinFinal() {
        return "";
    }

    public String getMsgDigest() {
        return this.msgDigest;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    private String getTimeStamp() {
        Timestamp ts = new Timestamp(System.currentTimeMillis());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        return sdf.format(ts);
    }
}

