/*
 * Decompiled with CFR 0.152.
 */
package com.fadada.sdk.base.client;

import com.fadada.sdk.api.API;
import com.fadada.sdk.base.model.api.AddSignature;
import com.fadada.sdk.base.model.api.BeforeAuthSign;
import com.fadada.sdk.base.model.api.ContractFilling;
import com.fadada.sdk.base.model.api.CustomSignature;
import com.fadada.sdk.base.model.api.DownloadPdf;
import com.fadada.sdk.base.model.api.ExtSign;
import com.fadada.sdk.base.model.api.ExtSignAuto;
import com.fadada.sdk.base.model.api.GenerateContract;
import com.fadada.sdk.base.model.api.GetAuthStatus;
import com.fadada.sdk.base.model.api.RegisterAccount;
import com.fadada.sdk.base.model.api.UploadDocs;
import com.fadada.sdk.base.model.api.UploadTemplate;
import com.fadada.sdk.base.model.api.ViewPdfURL;
import com.fadada.sdk.base.model.req.AddSignatureParams;
import com.fadada.sdk.base.model.req.BeforeAuthSignParams;
import com.fadada.sdk.base.model.req.ContractFillingParams;
import com.fadada.sdk.base.model.req.CustomSignatureParams;
import com.fadada.sdk.base.model.req.DownloadPdfParams;
import com.fadada.sdk.base.model.req.ExtSignAutoParams;
import com.fadada.sdk.base.model.req.ExtSignParams;
import com.fadada.sdk.base.model.req.GenerateContractParams;
import com.fadada.sdk.base.model.req.GetAuthStatusParams;
import com.fadada.sdk.base.model.req.RegisterAccountParams;
import com.fadada.sdk.base.model.req.UploadDocsParams;
import com.fadada.sdk.base.model.req.UploadTemplateParams;
import com.fadada.sdk.base.model.req.ViewPdfURLParams;
import com.fadada.sdk.http.handler.DefaultFddClient;
import com.fadada.sdk.utils.crypt.FddEncryptTool;
import java.net.URLEncoder;
import org.apache.commons.lang3.StringUtils;

public class FddBaseClient
extends DefaultFddClient {
    public FddBaseClient(String appId, String secret, String version, String url) {
        super(appId, secret, version, url);
    }

    public FddBaseClient(String appId, String secret, String version, String url, String proxyHost, String proxyFlag, String proxyPort) {
        super(appId, secret, version, url, proxyHost, proxyFlag, proxyPort);
    }

    public FddBaseClient(String appId, String secret, String version, String url, Integer readTimeout, Integer writeTimeout, Integer fileReadTimeout, Integer fileWriteTimeout) {
        super(appId, secret, version, url, readTimeout, writeTimeout, fileReadTimeout, fileWriteTimeout);
    }

    public FddBaseClient(String appId, String secret, String version, String url, Integer readTimeout, Integer writeTimeout, Integer fileReadTimeout, Integer fileWriteTimeout, String proxyHost, String proxyFlag, String proxyPort) {
        super(appId, secret, version, url, readTimeout, writeTimeout, fileReadTimeout, fileWriteTimeout, proxyHost, proxyFlag, proxyPort);
    }

    public String invokeRegisterAccount(RegisterAccountParams params) {
        try {
            return super.invoke((API)new RegisterAccount(), params);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String invokeAddSignature(AddSignatureParams params) {
        try {
            if (StringUtils.isBlank(params.getSignatureImgBase64()) && null != params.getFile()) {
                String signatureImgBase64 = FddEncryptTool.getimgBase64(params.getFile());
                params.setSignatureImgBase64(signatureImgBase64);
            } else if (StringUtils.isBlank(params.getSignatureImgBase64()) && null != params.getImgUrl()) {
                String signatureImgBase64 = FddEncryptTool.ImageToBase64ByOnline(params.getImgUrl());
                params.setSignatureImgBase64(signatureImgBase64);
            }
            return super.invoke((API)new AddSignature(), params);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String invokeCustomSignature(CustomSignatureParams params) {
        try {
            return super.invoke((API)new CustomSignature(), params);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String invokeUploadDocs(UploadDocsParams params) {
        try {
            UploadDocs uploadDocs = new UploadDocs();
            uploadDocs.setHasFile(params.getFile() != null);
            return super.invoke((API)uploadDocs, params);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String invokeUploadTemplate(UploadTemplateParams params) {
        try {
            UploadTemplate uploadTemplate = new UploadTemplate();
            uploadTemplate.setHasFile(params.getFile() != null);
            return super.invoke((API)uploadTemplate, params);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String invokeGenerateContract(GenerateContractParams params) {
        try {
            return super.invoke((API)new GenerateContract(), params);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String invokeExtSignAuto(ExtSignAutoParams params) {
        try {
            if ("0".equals(params.getPositionType())) {
                params.setSignaturePositions(null);
            }
            if ("1".equals(params.getPositionType())) {
                params.setSignKeyword(null);
                params.setKeywordStrategy(null);
            }
            return super.invoke((API)new ExtSignAuto(), params);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String invokeExtSign(ExtSignParams params) {
        ExtSign extSign = new ExtSign();
        extSign.setUrl(super.getUrl());
        StringBuilder sBuilder = new StringBuilder(extSign.getUrl());
        try {
            params.setCommonParams(super.getAppId(), super.getSecret(), super.getVersion());
            sBuilder.append("?app_id=").append(super.getAppId()).append("&v=").append(super.getVersion()).append("&timestamp=").append(params.getTimestamp()).append("&transaction_id=").append(params.getTransactionId()).append("&customer_id=").append(params.getCustomerId());
            if (StringUtils.isNotBlank(params.getOuthCustomerId())) {
                sBuilder.append("&outh_customer_id=").append(params.getOuthCustomerId());
            }
            sBuilder.append("&contract_id=").append(params.getContractId()).append("&doc_title=").append(URLEncoder.encode(params.getDocTitle(), "UTF-8"));
            if (StringUtils.isNotBlank(params.getKeywordStrategy())) {
                sBuilder.append("&keyword_strategy=").append(params.getKeywordStrategy());
            }
            if (StringUtils.isNotBlank(params.getSignKeyword())) {
                sBuilder.append("&sign_keyword=").append(URLEncoder.encode(params.getSignKeyword(), "UTF-8"));
            }
            if (StringUtils.isNotBlank(params.getSignaturePositions())) {
                sBuilder.append("&signature_positions=").append(URLEncoder.encode(params.getSignaturePositions(), "utf-8"));
            }
            if (StringUtils.isNotBlank(params.getClientRole())) {
                sBuilder.append("&client_role=").append(params.getClientRole());
            }
            if (StringUtils.isNotBlank(params.getPositionType())) {
                sBuilder.append("&position_type=").append(params.getPositionType());
            }
            if (StringUtils.isNotBlank(params.getReadTime())) {
                sBuilder.append("&read_time=").append(params.getReadTime());
            }
            if (StringUtils.isNotBlank(params.getMobileSignType())) {
                sBuilder.append("&mobile_sign_type=").append(params.getMobileSignType());
            }
            if (StringUtils.isNotBlank(params.getSignVerifyWay())) {
                sBuilder.append("&sign_verify_way=").append(params.getSignVerifyWay());
            }
            if (StringUtils.isNotBlank(params.getVerifyWayFlag())) {
                sBuilder.append("&verify_way_flag=").append(params.getVerifyWayFlag());
            }
            if (StringUtils.isNotBlank(params.getOpenEnvironment())) {
                sBuilder.append("&open_environment=").append(params.getOpenEnvironment());
            }
            if (StringUtils.isNotBlank(params.getPcHandSignature())) {
                sBuilder.append("&pc_hand_signature=").append(params.getPcHandSignature());
            }
            if (StringUtils.isNotBlank(params.getResultType())) {
                sBuilder.append("&result_type=").append(params.getResultType());
            }
            if (StringUtils.isNotBlank(params.getClientType())) {
                sBuilder.append("&client_type=").append(params.getClientType());
            }
            if (StringUtils.isNotBlank(params.getCaNo())) {
                sBuilder.append("&ca_no=").append(params.getCaNo());
            }
            if (StringUtils.isNotBlank(params.getAcrossPageCustomerId())) {
                sBuilder.append("&acrosspage_customer_id=").append(params.getAcrossPageCustomerId());
            }
            if (StringUtils.isNotBlank(params.getShowType())) {
                sBuilder.append("&show_type=").append(params.getShowType());
            }
            if (StringUtils.isNotBlank(params.getSignatureId())) {
                sBuilder.append("&signature_id=").append(params.getSignatureId());
            }
            if (StringUtils.isNotBlank(params.getCustomerMobile())) {
                sBuilder.append("&customer_mobile=").append(params.getCustomerMobile());
            }
            if (StringUtils.isNotBlank(params.getCustomerName())) {
                sBuilder.append("&customer_name=").append(URLEncoder.encode(params.getCustomerName(), "UTF-8"));
            }
            if (StringUtils.isNotBlank(params.getCustomerIdentNo())) {
                sBuilder.append("&customer_ident_no=").append(params.getCustomerIdentNo());
            }
            if (StringUtils.isNotBlank(params.getFallBackUrl())) {
                sBuilder.append("&fall_back_url=").append(params.getFallBackUrl());
            }
            if (StringUtils.isNotBlank(params.getAcrossSignatureId())) {
                sBuilder.append("&across_signature_id=").append(params.getAcrossSignatureId());
            }
            if (StringUtils.isNotBlank(params.getSignatureShowTime())) {
                sBuilder.append("&signature_show_time=").append(params.getSignatureShowTime());
            }
            if (StringUtils.isNotBlank(params.getKeyx())) {
                sBuilder.append("&keyx=").append(params.getKeyx());
            }
            if (StringUtils.isNotBlank(params.getKeyy())) {
                sBuilder.append("&keyy=").append(params.getKeyy());
            }
            if (StringUtils.isNotBlank(params.getSmsTemplate())) {
                sBuilder.append("&sms_template=").append(params.getSmsTemplate());
            }
            if (StringUtils.isNotBlank(params.getWritingTrack())) {
                sBuilder.append("&writing_track=").append(params.getWritingTrack());
            }
            if (StringUtils.isNotBlank(params.getReadType())) {
                sBuilder.append("&read_type=").append(params.getReadType());
            }
            if (StringUtils.isNotBlank(params.getLang())) {
                sBuilder.append("&lang=").append(params.getLang());
            }
            if (StringUtils.isNotBlank(params.getReturnUrl())) {
                sBuilder.append("&return_url=").append(URLEncoder.encode(params.getReturnUrl(), "UTF-8"));
            }
            if (StringUtils.isNotBlank(params.getNotifyUrl())) {
                sBuilder.append("&notify_url=").append(URLEncoder.encode(params.getNotifyUrl(), "UTF-8"));
            }
            sBuilder.append("&msg_digest=").append(params.getMsgDigest());
            return sBuilder.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String invokeViewPdfURL(ViewPdfURLParams params) {
        ViewPdfURL viewPdfURL = new ViewPdfURL();
        viewPdfURL.setUrl(super.getUrl());
        StringBuilder sBuilder = new StringBuilder(viewPdfURL.getUrl());
        try {
            params.setCommonParams(super.getAppId(), super.getSecret(), super.getVersion());
            sBuilder.append("?app_id=").append(super.getAppId()).append("&v=").append(super.getVersion()).append("&timestamp=").append(params.getTimestamp()).append("&contract_id=").append(params.getContractId()).append("&msg_digest=").append(params.getMsgDigest());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return sBuilder.toString();
    }

    public String invokeDownloadPdf(DownloadPdfParams params) {
        DownloadPdf downloadPdf = new DownloadPdf();
        downloadPdf.setUrl(super.getUrl());
        downloadPdf.setAPIParams(params);
        try {
            if (StringUtils.isBlank(params.getPath())) {
                StringBuilder sBuilder = new StringBuilder(downloadPdf.getUrl());
                return this.getDownloadUrl(params, sBuilder);
            }
            return super.invoke(downloadPdf);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String getDownloadUrl(DownloadPdfParams params, StringBuilder sBuilder) {
        params.setCommonParams(super.getAppId(), super.getSecret(), super.getVersion());
        sBuilder.append("?app_id=").append(super.getAppId()).append("&v=").append(super.getVersion()).append("&timestamp=").append(params.getTimestamp()).append("&contract_id=").append(params.getContractId()).append("&msg_digest=").append(params.getMsgDigest());
        return sBuilder.toString();
    }

    public String invokeContractFilling(ContractFillingParams params) {
        try {
            return super.invoke((API)new ContractFilling(), params);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String invokeBeforeAuthSign(BeforeAuthSignParams params) {
        BeforeAuthSign beforeAuthSign = new BeforeAuthSign();
        beforeAuthSign.setUrl(super.getUrl());
        beforeAuthSign.setAPIParams(params);
        params.setCommonParams(super.getAppId(), super.getSecret(), super.getVersion());
        StringBuilder sb = new StringBuilder(beforeAuthSign.getUrl()).append("?app_id=").append(super.getAppId()).append("&v=").append(super.getVersion()).append("&timestamp=").append(params.getTimestamp()).append("&msg_digest=").append(params.getMsgDigest()).append("&transaction_id=").append(params.getTransactionId()).append("&auth_type=").append(params.getAuthType()).append("&contract_id=").append(params.getContractId()).append("&customer_id=").append(params.getCustomerId()).append("&return_url=").append(params.getReturnUrl()).append("&notify_url=").append(params.getNotifyUrl());
        return sb.toString();
    }

    public String invokeGetAuthStatus(GetAuthStatusParams params) {
        try {
            return super.invoke((API)new GetAuthStatus(), params);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

