/*
 * Decompiled with CFR 0.152.
 */
package com.fadada.sdk.http;

import com.fadada.sdk.api.API;
import com.fadada.sdk.enums.ErrorMessage;
import com.fadada.sdk.exception.SDKException;
import com.fadada.sdk.http.HttpClient;
import com.fadada.sdk.utils.config.SystemConfig;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public class DefaultHttpClient
implements HttpClient {
    private OkHttpClient okHttpClient = null;
    private OkHttpClient timeHttpClient = null;
    private static final TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }};

    public DefaultHttpClient() {
        this.init();
    }

    private void init() {
        SSLContext trustAllSslContext = null;
        try {
            trustAllSslContext = SSLContext.getInstance("SSL");
            trustAllSslContext.init(null, trustAllCerts, new SecureRandom());
        }
        catch (KeyManagementException | NoSuchAlgorithmException generalSecurityException) {
            // empty catch block
        }
        SSLSocketFactory trustAllSslSocketFactory = Objects.requireNonNull(trustAllSslContext).getSocketFactory();
        OkHttpClient.Builder builder = new OkHttpClient.Builder().connectTimeout(10L, TimeUnit.SECONDS).readTimeout(SystemConfig.getFileReadTimeout().intValue(), TimeUnit.SECONDS).writeTimeout(SystemConfig.getFileWriteTimeout().intValue(), TimeUnit.SECONDS).sslSocketFactory(trustAllSslSocketFactory, (X509TrustManager)trustAllCerts[0]).hostnameVerifier(new HostnameVerifier(){

            @Override
            public boolean verify(String s, SSLSession sslSession) {
                return true;
            }
        });
        String proxyFlag = SystemConfig.getProxyFlag();
        if ("ON".equalsIgnoreCase(proxyFlag)) {
            String proxyHost = SystemConfig.getProxyHost();
            String proxyPort = SystemConfig.getProxyPort();
            builder.proxy(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHost, Integer.parseInt(proxyPort))));
        }
        this.okHttpClient = builder.build();
        this.timeHttpClient = builder.connectTimeout(10L, TimeUnit.SECONDS).readTimeout(SystemConfig.getReadTimeout().intValue(), TimeUnit.SECONDS).writeTimeout(SystemConfig.getWriteTimeout().intValue(), TimeUnit.SECONDS).build();
    }

    @Override
    public Response send(Request request, API api) throws SDKException {
        try {
            if (api.hasDownload() || api.hasFile()) {
                return this.okHttpClient.newCall(request).execute();
            }
            return this.timeHttpClient.newCall(request).execute();
        }
        catch (IOException e) {
            throw new SDKException(e, ErrorMessage.IO_ERROR, e.getMessage());
        }
    }
}

