/*
 * Decompiled with CFR 0.152.
 */
package com.fadada.sdk.verify.client;

import com.fadada.sdk.api.API;
import com.fadada.sdk.http.handler.DefaultFddClient;
import com.fadada.sdk.verify.model.api.ApplyCert;
import com.fadada.sdk.verify.model.api.CancelExtsignAutoPage;
import com.fadada.sdk.verify.model.api.CompanyVerifyUrl;
import com.fadada.sdk.verify.model.api.FileForUUID;
import com.fadada.sdk.verify.model.api.FindCompanyCert;
import com.fadada.sdk.verify.model.api.FindPersonCert;
import com.fadada.sdk.verify.model.api.PersonVerifyUrl;
import com.fadada.sdk.verify.model.req.ApplyCertParams;
import com.fadada.sdk.verify.model.req.CancelExtsignAutoPageParams;
import com.fadada.sdk.verify.model.req.CompanyVerifyUrlParams;
import com.fadada.sdk.verify.model.req.FileForUUIDParams;
import com.fadada.sdk.verify.model.req.FindCompanyCertParams;
import com.fadada.sdk.verify.model.req.FindPersonCertParams;
import com.fadada.sdk.verify.model.req.PersonVerifyUrlParams;
import java.net.URLEncoder;
import org.apache.commons.lang3.StringUtils;

public class FddVerifyClient
extends DefaultFddClient {
    public FddVerifyClient(String appId, String secret, String version, String url) {
        super(appId, secret, version, url);
    }

    public FddVerifyClient(String appId, String secret, String version, String url, String proxyHost, String proxyFlag, String proxyPort) {
        super(appId, secret, version, url, proxyHost, proxyFlag, proxyPort);
    }

    public FddVerifyClient(String appId, String secret, String version, String url, Integer readTimeout, Integer writeTimeout, Integer fileReadTimeout, Integer fileWriteTimeout) {
        super(appId, secret, version, url, readTimeout, writeTimeout, fileReadTimeout, fileWriteTimeout);
    }

    public FddVerifyClient(String appId, String secret, String version, String url, Integer readTimeout, Integer writeTimeout, Integer fileReadTimeout, Integer fileWriteTimeout, String proxyHost, String proxyFlag, String proxyPort) {
        super(appId, secret, version, url, readTimeout, writeTimeout, fileReadTimeout, fileWriteTimeout, proxyHost, proxyFlag, proxyPort);
    }

    public String invokePersonVerifyUrl(PersonVerifyUrlParams params) {
        try {
            return super.invoke((API)new PersonVerifyUrl(), params);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String invokeCompanyVerifyUrl(CompanyVerifyUrlParams params) {
        try {
            CompanyVerifyUrl companyVerifyUrl = new CompanyVerifyUrl();
            companyVerifyUrl.setHasFile(params.getAuthorizationFile() != null);
            companyVerifyUrl.setUrl(super.getUrl());
            companyVerifyUrl.setAPIParams(params);
            return super.invoke(companyVerifyUrl);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String invokeFindPersonCert(FindPersonCertParams params) {
        try {
            return super.invoke((API)new FindPersonCert(), params);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String invokeFindCompanyCert(FindCompanyCertParams params) {
        try {
            return super.invoke((API)new FindCompanyCert(), params);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String invokeApplyCert(ApplyCertParams params) {
        try {
            return super.invoke((API)new ApplyCert(), params);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String invokeFileForUUID(FileForUUIDParams params) {
        FileForUUID fileForUUID = new FileForUUID();
        fileForUUID.setUrl(super.getUrl());
        params.setCommonParams(super.getAppId(), super.getSecret(), super.getVersion());
        StringBuilder sBuilder = new StringBuilder(fileForUUID.getUrl()).append("?app_id=").append(super.getAppId()).append("&v=").append(super.getVersion()).append("&timestamp=").append(params.getTimestamp()).append("&uuid=").append(params.getUuid()).append("&doc_type=").append(params.getDocType()).append("&msg_digest=").append(params.getMsgDigest());
        return sBuilder.toString();
    }

    public String invokeCancelExtsignAutoPage(CancelExtsignAutoPageParams params) {
        CancelExtsignAutoPage cancelExtsignAutoPage = new CancelExtsignAutoPage();
        cancelExtsignAutoPage.setUrl(super.getUrl());
        params.setCommonParams(super.getAppId(), super.getSecret(), super.getVersion());
        StringBuilder sBuilder = new StringBuilder(cancelExtsignAutoPage.getUrl());
        try {
            sBuilder.append("?app_id=").append(super.getAppId()).append("&v=").append(super.getVersion()).append("&timestamp=").append(params.getTimestamp()).append("&customer_id=").append(params.getCustomerId());
            if (StringUtils.isNotBlank(params.getReturnUrl())) {
                sBuilder.append("&return_url=").append(URLEncoder.encode(params.getReturnUrl(), "UTF-8"));
            }
            if (StringUtils.isNotBlank(params.getNotifyUrl())) {
                sBuilder.append("&notify_url=").append(URLEncoder.encode(params.getNotifyUrl(), "UTF-8"));
            }
            sBuilder.append("&msg_digest=").append(params.getMsgDigest());
            return sBuilder.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

