package HslCommunication.CNC.Fanuc;

import HslCommunication.Core.IMessage.INetMessage;
import HslCommunication.Core.IMessage.NetMessageBase;

public class CNCFanucSeriesMessage extends NetMessageBase implements INetMessage
{
    public int ProtocolHeadBytesLength(){
        return 10;
    }

    public int GetContentLengthByHeadBytes() {
        byte[] HeadBytes = getHeadBytes();
        byte[] SendBytes = getSendBytes();
        return (HeadBytes[8] & 0xff) * 256 + (HeadBytes[9] & 0xff);
    }

    public boolean CheckHeadBytesLegal(byte[] token)
    {
        return true;
    }
}
