package HslCommunication.CNC.Fanuc;

import java.nio.charset.StandardCharsets;

/**
 * Fanuc的系统信息
 */
public class FanucSysInfo {
    /**
     * 实例化一个空对象
     */
    public FanucSysInfo( )
    {

    }

    /**
     * 使用缓存数据来实例化一个对象
     * @param buffer 原始的字节信息
     */
    public FanucSysInfo( byte[] buffer )
    {
        TypeCode = new String( buffer, 32, 2, StandardCharsets.US_ASCII);
        switch (TypeCode)
        {
            case "15": CncType = "Series 15/15i"; break;
            case "16": CncType = "Series 16/16i"; break;
            case "18": CncType = "Series 18/18i"; break;
            case "21": CncType = "Series 21/210i"; break;
            case "30": CncType = "Series 30i"; break;
            case "31": CncType = "Series 31i"; break;
            case "32": CncType = "Series 32i"; break;
            case " 0": CncType = "Series 0i"; break;
            case "PD": CncType = "Power Mate i-D"; break;
            case "PH": CncType = "Power Mate i-H"; break;
        }
        CncType += "-";
        switch (new String( buffer, 34, 2 , StandardCharsets.US_ASCII))
        {
            case " M": MtType = "Machining center"; break;
            case " T": MtType = "Lathe"; break;
            case "MM": MtType = "M series with 2 path control"; break;
            case "TT": MtType = "T series with 2/3 path control"; break;
            case "MT": MtType = "T series with compound machining function"; break;
            case " P": MtType = "Punch press"; break;
            case " L": MtType = "Laser"; break;
            case " W": MtType = "Wire cut"; break;
        }
        CncType += new String( buffer, 34, 2 , StandardCharsets.US_ASCII).trim( );
        switch (buffer[28])
        {
            case 1: CncType += "A"; break;
            case 2: CncType += "B"; break;
            case 3: CncType += "C"; break;
            case 4: CncType += "D"; break;
            case 6: CncType += "F"; break;
        }

        Series = new String( buffer, 36, 4, StandardCharsets.US_ASCII);
        Version = new String( buffer, 40, 4, StandardCharsets.US_ASCII );
        Axes = Integer.parseInt( new String( buffer, 44, 2, StandardCharsets.US_ASCII ) );
    }

    /**
     * CNC的类型代号
     */
    public String TypeCode = "";

    /**
     * CNC的类型
     */
    public String CncType = "";

    /**
     * Kind of M/T,
     */
    public String MtType = "";

    /**
     * 系列信息
     */
    public String Series = "";

    /**
     * 版本号信息
     */
    public String Version = "";

    /**
     * Current controlled axes
     */
    public int Axes = 0;

    @Override
    public String toString() {
        return "TypeCode: " + TypeCode + "\r\n" +
                "CncType: " + CncType + "\r\n" +
                "MtType: " + MtType + "\r\n" +
                "Series: " + Series + "\r\n" +
                "Version: " + Version;
    }
}
