package HslCommunication.CNC.Fanuc;

import HslCommunication.Core.Transfer.IByteTransform;
import HslCommunication.Utilities;

import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

/**
 * 文件或是文件夹的信息
 */
public class FileDirInfo {

    /**
     * 实例化一个默认的对象
     */
    public FileDirInfo( )
    {

    }

    /**
     * 使用原始字节来实例化对象
     * @param byteTransform 字节变换对象
     * @param buffer 原始的字节信息
     * @param index 起始的索引信息
     */
    public FileDirInfo(IByteTransform byteTransform, byte[] buffer, int index )
    {
        IsDirectory = byteTransform.TransInt16( buffer, index ) == 0x00;
        Name        = Utilities.GetStringOrEndChar( buffer,index + 28, 36, StandardCharsets.US_ASCII);

        if (!IsDirectory)
        {
            Calendar calendar = Calendar.getInstance();
            calendar.set(
                    byteTransform.TransInt16( buffer, index + 2 ),
                    byteTransform.TransInt16( buffer, index + 4 ) - 1 ,
                    byteTransform.TransInt16( buffer, index + 6 ),
                    byteTransform.TransInt16( buffer, index + 8 ),
                    byteTransform.TransInt16( buffer, index + 10 ),
                    byteTransform.TransInt16( buffer, index + 12 ) );
            LastModified = calendar.getTime();
            Size = byteTransform.TransInt32( buffer, index + 20 );
        }
    }

    /**
     * 是否为文件夹，True就是文件夹，False就是文件
     */
    public boolean IsDirectory = false;

    /**
     * 文件或是文件夹的名称
     */
    public String Name = "";

    /**
     * 最后一次更新时间，当为文件的时候有效
     */
    public Date LastModified = new Date();

    /**
     * 文件的大小，当为文件的时候有效
     */
    public int Size = 0;

    public String toFileString(){
        StringBuilder stringBuilder = new StringBuilder( );
        stringBuilder.append( IsDirectory ? "[PATH]   " : "[FILE]   " );
        stringBuilder.append( String.format("%-40s",Name) );

        if (!IsDirectory)
        {
            stringBuilder.append( "     " );
            stringBuilder.append( new SimpleDateFormat("yyyy-MM-dd hh:mm:ss").format(LastModified) );
            stringBuilder.append( "         " );
            stringBuilder.append( HslCommunication.BasicFramework.SoftBasic.GetSizeDescription( Size ) );
        }
        return stringBuilder.toString( );
    }

    public String toString( )
    {
       return Name;
    }
}

