/*
 * Decompiled with CFR 0.152.
 */
package HslCommunication.Core.Net.NetworkBase;

import HslCommunication.BasicFramework.SoftBasic;
import HslCommunication.Core.IMessage.INetMessage;
import HslCommunication.Core.Net.NetworkBase.NetworkBase;
import HslCommunication.Core.Net.StateOne.AlienSession;
import HslCommunication.Core.Thread.SimpleHybirdLock;
import HslCommunication.Core.Transfer.IByteTransform;
import HslCommunication.Core.Types.OperateResult;
import HslCommunication.Core.Types.OperateResultExOne;
import HslCommunication.Core.Types.OperateResultExTwo;
import HslCommunication.LogNet.Core.ILogNet;
import HslCommunication.StringResources;
import HslCommunication.Utilities;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;

public class NetworkDoubleBase
extends NetworkBase {
    private IByteTransform byteTransform;
    private String ipAddress = "127.0.0.1";
    private int port = 10000;
    private int connectTimeOut = 10000;
    private int receiveTimeOut = 10000;
    protected boolean isPersistentConn = false;
    protected SimpleHybirdLock simpleHybirdLock = new SimpleHybirdLock();
    protected boolean IsSocketError = false;
    protected boolean LogMsgFormatBinary = true;
    private boolean isUseSpecifiedSocket = false;
    private String connectionId = SoftBasic.GetUniqueStringByGuidAndRandom();
    private int sleepTime = 0;
    public AlienSession AlienSession = null;
    protected boolean isUseAccountCertificate = false;
    private String userName = "";
    private String password = "";

    protected INetMessage GetNewNetMessage() {
        return null;
    }

    public IByteTransform getByteTransform() {
        return this.byteTransform;
    }

    public void setByteTransform(IByteTransform transform) {
        this.byteTransform = transform;
    }

    public int getConnectTimeOut() {
        return this.connectTimeOut;
    }

    public void setConnectTimeOut(int connectTimeOut) {
        this.connectTimeOut = connectTimeOut;
    }

    public int getReceiveTimeOut() {
        return this.receiveTimeOut;
    }

    public void setReceiveTimeOut(int receiveTimeOut) {
        this.receiveTimeOut = receiveTimeOut;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(String ipAddress) {
        if (!ipAddress.isEmpty()) {
            this.ipAddress = ipAddress;
        }
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getConnectionId() {
        return this.connectionId;
    }

    public void setConnectionId(String connectionId) {
        this.connectionId = connectionId;
    }

    public int getSleepTime() {
        return this.sleepTime;
    }

    public void setSleepTime(int sleepTime) {
        this.sleepTime = sleepTime;
    }

    public void SetPersistentConnection() {
        this.isPersistentConn = true;
    }

    public boolean IpAddressPing() throws IOException {
        return InetAddress.getByName(this.ipAddress).isReachable(3000);
    }

    public OperateResult ConnectServer() {
        this.isPersistentConn = true;
        this.CloseSocket(this.CoreSocket);
        OperateResultExOne<Socket> rSocket = this.CreateSocketAndInitialication();
        if (!rSocket.IsSuccess) {
            this.IsSocketError = true;
            rSocket.Content = null;
        } else {
            this.CoreSocket = (Socket)rSocket.Content;
            ILogNet logNet = this.LogNet;
            if (logNet != null) {
                logNet.WriteDebug(this.toString(), StringResources.Language.NetEngineStart());
            }
        }
        return rSocket;
    }

    public OperateResult ConnectServer(AlienSession session) {
        this.isPersistentConn = true;
        this.isUseSpecifiedSocket = true;
        if (session != null) {
            if (this.AlienSession != null) {
                this.CloseSocket(this.AlienSession.getSocket());
            }
            if (this.connectionId.isEmpty()) {
                this.connectionId = session.getDTU();
            }
            if (this.connectionId.equals(session.getDTU())) {
                if (session.getIsStatusOk()) {
                    OperateResult ini = this.InitializationOnConnect(session.getSocket());
                    if (ini.IsSuccess) {
                        this.CoreSocket = session.getSocket();
                        this.IsSocketError = !session.getIsStatusOk();
                        this.AlienSession = session;
                    } else {
                        this.IsSocketError = true;
                    }
                    return ini;
                }
                return new OperateResult();
            }
            this.IsSocketError = true;
            return new OperateResult();
        }
        this.IsSocketError = true;
        return new OperateResult();
    }

    public OperateResult ConnectClose() {
        OperateResult result = new OperateResult();
        this.isPersistentConn = false;
        this.simpleHybirdLock.Enter();
        result = this.ExtraOnDisconnect(this.CoreSocket);
        this.CloseSocket(this.CoreSocket);
        this.CoreSocket = null;
        this.simpleHybirdLock.Leave();
        if (this.LogNet != null) {
            this.LogNet.WriteDebug(this.toString(), StringResources.Language.NetEngineClose());
        }
        return result;
    }

    protected OperateResult InitializationOnConnect(Socket socket) {
        return OperateResult.CreateSuccessResult();
    }

    protected OperateResult ExtraOnDisconnect(Socket socket) {
        return OperateResult.CreateSuccessResult();
    }

    protected void ExtraAfterReadFromCoreServer(OperateResult read) {
    }

    public void SetLoginAccount(String userName, String password) {
        if (!Utilities.IsStringNullOrEmpty(userName)) {
            this.isUseAccountCertificate = true;
            this.userName = userName;
            this.password = password;
        } else {
            this.isUseAccountCertificate = false;
        }
    }

    protected OperateResult AccountCertificate(Socket socket) {
        OperateResult send = this.SendAccountAndCheckReceive(socket, 1, this.userName, this.password);
        if (!send.IsSuccess) {
            return send;
        }
        OperateResultExTwo<Integer, String[]> read = this.ReceiveStringArrayContentFromSocket(socket);
        if (!read.IsSuccess) {
            return read;
        }
        if ((Integer)read.Content1 == 0) {
            return new OperateResult(((String[])read.Content2)[0]);
        }
        return OperateResult.CreateSuccessResult();
    }

    protected byte[] PackCommandWithHeader(byte[] command) {
        return command;
    }

    protected OperateResultExOne<byte[]> UnpackResponseContent(byte[] send, byte[] response) {
        return OperateResultExOne.CreateSuccessResult(response);
    }

    protected OperateResultExOne<Socket> GetAvailableSocket() {
        if (this.isPersistentConn) {
            if (this.isUseSpecifiedSocket) {
                if (this.IsSocketError) {
                    return new OperateResultExOne<Socket>(StringResources.Language.ConnectionIsNotAvailable());
                }
                return OperateResultExOne.CreateSuccessResult(this.CoreSocket);
            }
            if (this.IsSocketError || this.CoreSocket == null) {
                OperateResult connect = this.ConnectServer();
                if (!connect.IsSuccess) {
                    this.IsSocketError = true;
                    return OperateResultExOne.CreateFailedResult(connect);
                }
                this.IsSocketError = false;
                return OperateResultExOne.CreateSuccessResult(this.CoreSocket);
            }
            return OperateResultExOne.CreateSuccessResult(this.CoreSocket);
        }
        return this.CreateSocketAndInitialication();
    }

    private OperateResultExOne<Socket> CreateSocketAndInitialication() {
        OperateResultExOne<Socket> result = this.CreateSocketAndConnect(this.ipAddress, this.port, this.connectTimeOut);
        if (result.IsSuccess) {
            OperateResult initi = this.InitializationOnConnect((Socket)result.Content);
            if (!initi.IsSuccess) {
                this.CloseSocket((Socket)result.Content);
                result.IsSuccess = initi.IsSuccess;
                result.CopyErrorFromOther(initi);
            }
        }
        return result;
    }

    public OperateResultExOne<byte[]> ReadFromCoreServer(Socket socket, byte[] send, boolean hasResponseData, boolean usePackAndUnpack) {
        INetMessage netMessage;
        byte[] sendValue = usePackAndUnpack ? this.PackCommandWithHeader(send) : send;
        ILogNet logNet = this.LogNet;
        if (logNet != null) {
            logNet.WriteDebug(this.toString(), StringResources.Language.Send() + " : " + (this.LogMsgFormatBinary ? SoftBasic.ByteToHexString(sendValue, ' ') : SoftBasic.GetAsciiStringRender(sendValue)));
        }
        if ((netMessage = this.GetNewNetMessage()) != null) {
            netMessage.setSendBytes(sendValue);
        }
        OperateResult resultSend = this.Send(socket, sendValue);
        if (!resultSend.IsSuccess) {
            return OperateResultExOne.CreateFailedResult(resultSend);
        }
        if (this.receiveTimeOut < 0) {
            return OperateResultExOne.CreateSuccessResult(new byte[0]);
        }
        if (!hasResponseData) {
            return OperateResultExOne.CreateSuccessResult(new byte[0]);
        }
        try {
            if (this.sleepTime > 0) {
                Thread.sleep(this.sleepTime);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        OperateResultExOne<byte[]> resultReceive = this.ReceiveByMessage(socket, this.receiveTimeOut, netMessage);
        if (!resultReceive.IsSuccess) {
            return OperateResultExOne.CreateFailedResult(resultReceive);
        }
        if (logNet != null) {
            logNet.WriteDebug(this.toString(), StringResources.Language.Receive() + " : " + (this.LogMsgFormatBinary ? SoftBasic.ByteToHexString((byte[])resultReceive.Content, ' ') : SoftBasic.GetAsciiStringRender((byte[])resultReceive.Content)));
        }
        if (netMessage != null && !netMessage.CheckHeadBytesLegal(Utilities.UUID2Byte(this.Token))) {
            this.CloseSocket(socket);
            return new OperateResultExOne<byte[]>(StringResources.Language.CommandHeadCodeCheckFailed());
        }
        return usePackAndUnpack ? this.UnpackResponseContent(sendValue, (byte[])resultReceive.Content) : resultReceive;
    }

    public OperateResultExOne<byte[]> ReadFromCoreServer(byte[] send, boolean hasResponseData, boolean usePackAndUnpack) {
        OperateResultExOne<byte[]> result = new OperateResultExOne<byte[]>();
        this.simpleHybirdLock.Enter();
        OperateResultExOne<Socket> resultSocket = this.GetAvailableSocket();
        if (!resultSocket.IsSuccess) {
            this.IsSocketError = true;
            if (this.AlienSession != null) {
                this.AlienSession.setIsStatusOk(false);
            }
            this.simpleHybirdLock.Leave();
            result.CopyErrorFromOther(resultSocket);
            return result;
        }
        OperateResultExOne<byte[]> read = this.ReadFromCoreServer((Socket)resultSocket.Content, send, hasResponseData, usePackAndUnpack);
        if (read.IsSuccess) {
            this.IsSocketError = false;
            result.IsSuccess = true;
            result.Content = read.Content;
            result.Message = StringResources.Language.SuccessText();
        } else {
            this.IsSocketError = true;
            if (this.AlienSession != null) {
                this.AlienSession.setIsStatusOk(false);
            }
            result.CopyErrorFromOther(read);
        }
        this.ExtraAfterReadFromCoreServer(read);
        this.simpleHybirdLock.Leave();
        if (!this.isPersistentConn) {
            this.CloseSocket((Socket)resultSocket.Content);
        }
        return result;
    }

    public OperateResultExOne<byte[]> ReadFromCoreServer(byte[] send) {
        return this.ReadFromCoreServer(send, true, true);
    }

    @Override
    public String toString() {
        if (this.GetNewNetMessage() == null) {
            return "NetworkDoubleBase[" + this.getIpAddress() + ":" + this.getPort() + "]";
        }
        return "NetworkDoubleBase<" + this.GetNewNetMessage().getClass().getTypeName() + ">[" + this.getIpAddress() + ":" + this.getPort() + "]";
    }
}

