/*
 * Decompiled with CFR 0.152.
 */
package com.github.lkqm.hcnet.options;

import com.github.lkqm.hcnet.HCNetSDK;
import com.github.lkqm.hcnet.HikDeviceTemplate;
import com.github.lkqm.hcnet.HikResult;
import com.github.lkqm.hcnet.options.BaseOptions;
import com.github.lkqm.hcnet.options.PtzOptions;
import com.sun.jna.NativeLong;

public class PtzOptionsImpl
extends BaseOptions
implements PtzOptions {
    private final NativeLong userId;

    public PtzOptionsImpl(HikDeviceTemplate deviceTemplate, long userId) {
        super(deviceTemplate);
        this.userId = new NativeLong(userId);
    }

    @Override
    public HikResult<?> control(int command, int stop, int speed) {
        boolean result = this.getHcnetsdk().NET_DVR_PTZControlWithSpeed_Other(this.userId, new NativeLong(1L), command, stop, speed);
        return result ? HikResult.ok() : this.lastError();
    }

    @Override
    public HikResult<?> controlStart(int command, int speed) {
        return this.control(command, 0, speed);
    }

    @Override
    public HikResult<?> controlStop(int command, int speed) {
        return this.control(command, 0, speed);
    }

    @Override
    public HikResult<?> presetSet(int presetIndex) {
        return this.preset(8, presetIndex);
    }

    @Override
    public HikResult<?> presetClean(int presetIndex) {
        return this.preset(9, presetIndex);
    }

    @Override
    public HikResult<?> presetGoto(int presetIndex) {
        return this.preset(39, presetIndex);
    }

    @Override
    public HikResult<?> preset(int presetCommand, int presetIndex) {
        boolean result = this.getHcnetsdk().NET_DVR_PTZPreset_Other(this.userId, new NativeLong(1L), presetCommand, presetIndex);
        return result ? HikResult.ok() : this.lastError();
    }

    @Override
    public HikResult<?> cruise(int cruiseCommand, int cruiseRoute, int cruisePoint, int speed) {
        boolean result = this.getHcnetsdk().NET_DVR_PTZCruise_Other(this.userId, new NativeLong(1L), cruiseCommand, (byte)cruiseRoute, (byte)cruisePoint, (byte)speed);
        return result ? HikResult.ok() : this.lastError();
    }

    @Override
    public HikResult<?> cruiseRun(int cruiseRoute) {
        return this.cruise(37, cruiseRoute, 0, 0);
    }

    @Override
    public HikResult<?> cruiseStop(int cruiseRoute) {
        return this.cruise(38, cruiseRoute, 0, 0);
    }

    @Override
    public HikResult<?> cruiseFillPreset(int cruiseRoute, int cruisePoint, int speed) {
        return this.cruise(30, cruiseRoute, cruisePoint, speed);
    }

    @Override
    public HikResult<?> track(int trackCommand) {
        boolean result = this.getHcnetsdk().NET_DVR_PTZTrack_Other(this.userId, new NativeLong(1L), trackCommand);
        return result ? HikResult.ok() : this.lastError();
    }

    @Override
    public HikResult<?> trackStartRecord() {
        return this.track(34);
    }

    @Override
    public HikResult<?> trackStopRecord() {
        return this.track(35);
    }

    @Override
    public HikResult<?> trackRun() {
        return this.track(35);
    }

    @Override
    public HikResult<?> zoom(int xTop, int yTop, int xBottom, int yBottom) {
        HCNetSDK.NET_DVR_POINT_FRAME point = new HCNetSDK.NET_DVR_POINT_FRAME();
        point.xTop = xTop;
        point.yTop = yTop;
        point.xBottom = xBottom;
        point.yBottom = yBottom;
        point.write();
        boolean result = this.getHcnetsdk().NET_DVR_PTZSelZoomIn_EX(this.userId, new NativeLong(1L), point);
        return result ? HikResult.ok() : this.lastError();
    }
}

