/*
 * Decompiled with CFR 0.152.
 */
package com.power.common.filter;

import com.power.common.filter.AbstractUrlMatcher;
import com.power.common.util.StringUtil;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SessionFilter
extends AbstractUrlMatcher
implements Filter {
    private String sessionKey;
    private Set<String> exceptUrlPattern = null;
    private String forwardUrl;
    private String redirectUrl;

    public void init(FilterConfig cfg) throws ServletException {
        this.sessionKey = cfg.getInitParameter("sessionKey");
        String exceptUrlString = cfg.getInitParameter("exceptUrlPattern");
        this.exceptUrlPattern = StringUtil.isNotEmpty(exceptUrlString) ? Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(exceptUrlString.split(";", 0)))) : Collections.emptySet();
        this.forwardUrl = cfg.getInitParameter("forwardUrl");
        this.redirectUrl = cfg.getInitParameter("redirectUrl");
    }

    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        if (StringUtil.isEmpty(this.sessionKey)) {
            chain.doFilter(req, resp);
            return;
        }
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)resp;
        String servletPath = request.getServletPath();
        if (servletPath.equals(this.redirectUrl) || this.isMatches(this.exceptUrlPattern, servletPath)) {
            chain.doFilter(req, resp);
            return;
        }
        Object sessionObj = request.getSession().getAttribute(this.sessionKey);
        if (null == sessionObj) {
            boolean isAjaxRequest = this.isAjaxRequest(request);
            if (isAjaxRequest) {
                response.setCharacterEncoding("UTF-8");
                response.sendError(401, "You have not operated for too long, please refresh the page");
                return;
            }
        } else {
            chain.doFilter(req, resp);
            return;
        }
        String contextPath = request.getContextPath();
        response.sendRedirect(contextPath + this.redirectUrl);
    }

    public void destroy() {
    }

    public boolean isAjaxRequest(HttpServletRequest request) {
        String header = request.getHeader("X-Requested-With");
        return header != null && "XMLHttpRequest".equals(header);
    }
}

