/*
 * Decompiled with CFR 0.152.
 */
package com.power.common.util;

import com.power.common.util.ValidateUtil;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.DayOfWeek;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Month;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAdjusters;
import java.time.temporal.TemporalField;
import java.time.temporal.WeekFields;
import java.util.Calendar;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class DateTimeUtil {
    public static final String DATE_FORMAT_MINITE = "yyyy-MM-dd HH:mm";
    public static final String DATE_FORMAT_DAY = "yyyy-MM-dd";
    public static final String DATE_FORMAT_SECOND = "yyyy-MM-dd HH:mm:ss";
    public static final String DATE_FORMAT_SECOND_12 = "yyyy-MM-dd hh:mm:ss";
    public static final String DATE_FORMAT_MILLISECOND = "yyyy-MM-dd HH:mm:ss.SSS";
    public static final String LOCAL_TIME = "HH:mm:ss";
    public static final String YEAR = "yyyy";
    public static final String YEAR_MONTH = "yyyy-MM";
    public static final String MONTH_DAY = "MM-dd";
    public static final String DATE_FORMAT_CHINESE = "yyyy\u5e74MM\u6708dd\u65e5";
    public static final String DATE_FORMAT_CHINESE_SECONDE = "yyyy\u5e74MM\u6708dd\u65e5 HH:mm:ss";
    public static final String DATE_FORMAT_CHINESE_WEEK_SECONDE = "yyyy\u5e74MM\u6708dd\u65e5 E HH:mm:ss";
    public static final String DATE_FORMAT_ZONED_DATE_TIME = "yyyy-MM-dd'T'HH:mm:ss.SSSXXX";
    public static final String YYYYMMDD = "yyyyMMdd";
    public static final String YYYYMMDDHHMMSS = "yyyyMMddHHmmss";
    public static final String YYYYMMDDHHMMSSSSS = "yyyyMMddHHmmssSSS";
    public static final String DATE_MINUTES_12 = "yyyy-MM-dd hh-mm-ss";
    public static final String STANDARD_DATE_FORMAT_UTC = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    public static final long DAY_MS = 86400000L;
    private static final ConcurrentMap<String, DateTimeFormatter> FORMATTER_CACHE = new ConcurrentHashMap<String, DateTimeFormatter>();
    private static final int PATTERN_CACHE_SIZE = 500;
    private static final String[] WEEK_ARR = new String[]{"\u5468\u65e5", "\u5468\u4e00", "\u5468\u4e8c", "\u5468\u4e09", "\u5468\u56db", "\u5468\u4e94", "\u5468\u516d"};

    public static String dateToStr(java.util.Date date, String format) {
        return DateTimeUtil.dateToStr(date, format, null);
    }

    public static String nowStrTime() {
        return DateTimeUtil.long2Str(System.currentTimeMillis(), DATE_FORMAT_SECOND);
    }

    public static String nowStrTime(String pattern) {
        return DateTimeUtil.long2Str(System.currentTimeMillis(), pattern);
    }

    public static String nowStrTime12() {
        return DateTimeUtil.long2Str(System.currentTimeMillis(), DATE_MINUTES_12);
    }

    public static String nowStrDate() {
        return LocalDate.now().toString();
    }

    public static String zonedDateTimeToStr(ZonedDateTime zonedDateTime, String format) {
        DateTimeFormatter formatter = DateTimeUtil.createCacheFormatter(format);
        return formatter.format(zonedDateTime);
    }

    public static String dateToStr(java.util.Date date, String pattern, Locale locale) {
        return DateTimeUtil.localDateTimeToStr(LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault()), pattern);
    }

    public static String sqlDateToStr(Date date, String format) {
        return DateTimeUtil.localDateTimeToStr(LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault()), format);
    }

    public static java.util.Date strToDate(String sDate, String format) {
        LocalDate localDate = DateTimeUtil.parseLocalDate(sDate, format);
        ZoneId zoneId = ZoneId.systemDefault();
        ZonedDateTime zdt = localDate.atStartOfDay(zoneId);
        return java.util.Date.from(zdt.toInstant());
    }

    public static Timestamp nowTimeStamp() {
        return new Timestamp(System.currentTimeMillis());
    }

    public static Timestamp strToStamp(String date) {
        return DateTimeUtil.strToStamp(date, DATE_FORMAT_SECOND);
    }

    public static Timestamp strToStamp(String date, String format) {
        LocalDateTime localDateTime = DateTimeUtil.parseLocalDateTime(date, format);
        return Timestamp.valueOf(localDateTime);
    }

    public static double calcRunTime(long beginTime, long endTime) {
        return endTime - beginTime;
    }

    public static void printRunTime(long beganTime, long endTime) {
        System.out.println("CostTime->" + (double)(endTime - beganTime) / 1000.0 + " Seconds");
    }

    public static Long getNowTime() {
        return System.currentTimeMillis();
    }

    public static long getDistanceOfTwoDate(java.util.Date before, java.util.Date after) {
        long beforeTime = before.getTime();
        long afterTime = after.getTime();
        return (afterTime - beforeTime) / 86400000L;
    }

    public static boolean isLeapYear(int year) {
        return year % 4 == 0 && year % 100 != 0 || year % 400 == 0;
    }

    public static String timestampToString(Timestamp time, String fmt) {
        DateTimeFormatter dateTimeFormatter = DateTimeUtil.createCacheFormatter(fmt);
        LocalDateTime dateTime = time.toLocalDateTime();
        return dateTimeFormatter.format(dateTime);
    }

    public static long setTimeToNextDay0H0M0S(Timestamp time) {
        if (time != null) {
            return DateTimeUtil.setTimeToNextDay0H0M0S(time.getTime());
        }
        throw new NullPointerException("Timestamp can not be null");
    }

    public static long setTimeToNextDay0H0M0S(long millis) {
        LocalDate localDate = DateTimeUtil.longToLocalDate(millis);
        localDate = localDate.plusDays(1L);
        return DateTimeUtil.localDateToLong(localDate);
    }

    public static long setToNextDay0H0M0SExceptToday(long millis) {
        boolean flag = DateTimeUtil.isDifferentDay(System.currentTimeMillis(), millis);
        long finalTime = flag ? DateTimeUtil.setTimeToNextDay0H0M0S(millis) : System.currentTimeMillis();
        return finalTime;
    }

    public static long setToNextDay0H0M0SExceptToday(Timestamp stamp) {
        long finalTime;
        if (Objects.nonNull(stamp)) {
            boolean flag = DateTimeUtil.isDifferentDay(DateTimeUtil.nowTimeStamp(), stamp);
            finalTime = flag ? DateTimeUtil.setTimeToNextDay0H0M0S(stamp) : System.currentTimeMillis();
        } else {
            throw new NullPointerException("Timestamp can not be null");
        }
        return finalTime;
    }

    public static long setTimeTo0H0M0S(Timestamp time) {
        if (Objects.nonNull(time)) {
            return DateTimeUtil.setTimeTo0H0M0S(time.getTime());
        }
        throw new NullPointerException("Timestamp can not be null");
    }

    public static long setTimeTo0H0M0S(long millis) {
        LocalDate localDate = DateTimeUtil.longToLocalDate(millis);
        return DateTimeUtil.localDateToLong(localDate);
    }

    public static void setTimeToLastDay0H0M0S(Timestamp time) {
        if (!Objects.nonNull(time)) {
            throw new NullPointerException("Timestamp can not be null");
        }
        LocalDate localDate = DateTimeUtil.longToLocalDate(time.getTime());
        localDate = localDate.plusDays(1L);
        time.setTime(DateTimeUtil.localDateToLong(localDate));
    }

    public static boolean isDifferentDay(Timestamp timestamp0, Timestamp timestamp1) {
        if (Objects.isNull(timestamp0) || Objects.isNull(timestamp1)) {
            throw new NullPointerException("Timestamp can not be null");
        }
        return DateTimeUtil.isDifferentDay(timestamp0.getTime(), timestamp1.getTime());
    }

    public static boolean isDifferentDay(long millis0, long millis1) {
        LocalDate localDate0 = DateTimeUtil.longToLocalDate(millis0);
        LocalDate localDate1 = DateTimeUtil.longToLocalDate(millis1);
        return DateTimeUtil.isDifferentDay(localDate0, localDate1);
    }

    public static boolean isDifferentDay(LocalDate localDate0, LocalDate localDate1) {
        return !localDate0.equals(localDate1);
    }

    public static String long2Str(Long millSec) {
        return DateTimeUtil.long2Str(millSec, DATE_FORMAT_CHINESE);
    }

    public static String long2Str(long millSec, String format) {
        return DateTimeUtil.long2Str(millSec, format, Locale.CHINESE);
    }

    public static String long2Str(long millSec, String format, Locale locale) {
        return DateTimeUtil.localDateTimeToStr(LocalDateTime.ofInstant(Instant.ofEpochMilli(millSec), ZoneId.systemDefault()), format);
    }

    public static long strToLong(String strTime, String pattern) {
        try {
            return DateTimeUtil.LocalDateTimeToLong(DateTimeUtil.parseLocalDateTime(strTime, pattern));
        }
        catch (Exception exception) {
            return DateTimeUtil.localDateToLong(DateTimeUtil.parseLocalDate(strTime, pattern));
        }
    }

    public static long todayPastMillisecond(long millions) {
        Calendar cal = DateTimeUtil.initCalenderWithMillis(millions);
        return cal.get(11) * 3600 + cal.get(12) * 60;
    }

    public static int getDayOfMonth() {
        return LocalDate.now().lengthOfMonth();
    }

    public static int getLengthOfMonth(Timestamp stamp) {
        if (Objects.nonNull(stamp)) {
            return DateTimeUtil.getLengthOfMonth(stamp.getTime());
        }
        throw new NullPointerException("Timestamp can not be null");
    }

    public static int getLengthOfMonth(long ms) {
        LocalDate localDateTime = DateTimeUtil.longToLocalDate(ms);
        return DateTimeUtil.getLengthOfMonth(localDateTime);
    }

    public static int getLengthOfMonth(LocalDate localDate) {
        if (Objects.nonNull(localDate)) {
            return localDate.lengthOfMonth();
        }
        throw new NullPointerException("LocalDate can not be null");
    }

    public static long getFirstDayOfCurrentWeek(Timestamp stamp) {
        if (null != stamp) {
            return DateTimeUtil.getFirstDayOfCurrentWeek(stamp.getTime());
        }
        throw new NullPointerException("Timestamp can not be null");
    }

    public static long getFirstDayOfCurrentWeek(long ms) {
        LocalDate localDate = DateTimeUtil.longToLocalDate(ms);
        TemporalField fieldIso = WeekFields.of(DayOfWeek.MONDAY, 1).dayOfWeek();
        localDate = localDate.with(fieldIso, 1L);
        return DateTimeUtil.localDateToLong(localDate);
    }

    public static long setToFirstDayOfCurrentYear(long millis) {
        LocalDate localDate = DateTimeUtil.longToLocalDate(millis);
        localDate = localDate.with(TemporalAdjusters.firstDayOfYear());
        return DateTimeUtil.localDateToLong(localDate);
    }

    public static long setToFirstDayOfNextYear(long millis) {
        LocalDate localDate = DateTimeUtil.longToLocalDate(millis);
        localDate = localDate.with(TemporalAdjusters.firstDayOfNextYear());
        return DateTimeUtil.localDateToLong(localDate);
    }

    public static long setToFirstDayOfLastMonth(long ms) {
        LocalDate localDate = DateTimeUtil.longToLocalDate(ms);
        localDate = localDate.minusMonths(1L);
        localDate = localDate.with(TemporalAdjusters.firstDayOfMonth());
        return DateTimeUtil.localDateToLong(localDate);
    }

    public static long setToLastMonthCommonDay(long ms) {
        LocalDate localDate = DateTimeUtil.longToLocalDate(ms);
        localDate = localDate.minusMonths(1L);
        return DateTimeUtil.localDateToLong(localDate);
    }

    public static long setToFirstDayOfCurrentMonth(long millis) {
        LocalDate localDate = DateTimeUtil.longToLocalDate(millis);
        localDate = localDate.with(TemporalAdjusters.firstDayOfMonth());
        return DateTimeUtil.localDateToLong(localDate);
    }

    public static long setToFirstDayOfNextMonth(long millis) {
        LocalDate localDate = DateTimeUtil.longToLocalDate(millis);
        localDate = localDate.with(TemporalAdjusters.firstDayOfNextMonth());
        return DateTimeUtil.localDateToLong(localDate);
    }

    public static long setToNextYearCommonDay(long millis) {
        LocalDate localDate = DateTimeUtil.longToLocalDate(millis);
        localDate = localDate.plusYears(1L);
        return DateTimeUtil.localDateToLong(localDate);
    }

    public static long setToLastYearCommonDay(long millis) {
        LocalDate localDate = DateTimeUtil.longToLocalDate(millis);
        localDate = localDate.minusYears(1L);
        return DateTimeUtil.localDateToLong(localDate);
    }

    public static long getLastDayOfCurrentWeek(Timestamp stamp) {
        LocalDate localDate = DateTimeUtil.longToLocalDate(stamp.getTime());
        TemporalField fieldIso = WeekFields.of(DayOfWeek.MONDAY, 1).dayOfWeek();
        localDate = localDate.with(fieldIso, 7L);
        return DateTimeUtil.localDateToLong(localDate);
    }

    public static long getFirstDayOfCurrentQuarter(long ms) {
        LocalDate localDate = DateTimeUtil.longToLocalDate(ms);
        Month month = localDate.getMonth();
        Month firstMonthOfQuarter = month.firstMonthOfQuarter();
        localDate = LocalDate.of(localDate.getYear(), firstMonthOfQuarter, 1);
        return DateTimeUtil.localDateToLong(localDate);
    }

    public static long getFirstDayOfNextQuarter(long ms) {
        LocalDate localDate = DateTimeUtil.longToLocalDate(ms);
        Month month = localDate.getMonth();
        Month firstMonthOfQuarter = month.firstMonthOfQuarter();
        Month endMonthOfQuarter = Month.of(firstMonthOfQuarter.getValue() + 3);
        localDate = LocalDate.of(localDate.getYear(), endMonthOfQuarter, 1);
        return DateTimeUtil.localDateToLong(localDate);
    }

    public static int getDayOfWeek(long ms) {
        LocalDate plainDate = DateTimeUtil.longToLocalDate(ms);
        return plainDate.getDayOfWeek().getValue();
    }

    public static long create0H0M0STime() {
        return DateTimeUtil.setTimeTo0H0M0S(System.currentTimeMillis());
    }

    public static boolean isToday(long ms) {
        LocalDate nowDate = LocalDate.now();
        LocalDate plainDate = DateTimeUtil.longToLocalDate(ms);
        return nowDate.equals(plainDate);
    }

    public static String friendlyTime(long ms) {
        String ftime = "";
        Calendar cal = Calendar.getInstance();
        if (DateTimeUtil.isDifferentDay(System.currentTimeMillis(), ms)) {
            int hour = (int)((cal.getTimeInMillis() - ms) / 3600000L);
            ftime = hour == 0 ? Math.max((cal.getTimeInMillis() - ms) / 60000L, 1L) + "\u5206\u949f\u524d" : hour + "\u5c0f\u65f6\u524d";
        }
        long lt = ms / 86400000L;
        long ct = cal.getTimeInMillis() / 86400000L;
        int days = (int)(ct - lt);
        if (days == 0) {
            int hour = (int)((cal.getTimeInMillis() - ms) / 3600000L);
            ftime = hour == 0 ? Math.max((cal.getTimeInMillis() - ms) / 60000L, 1L) + "\u5206\u949f\u524d" : hour + "\u5c0f\u65f6\u524d";
        } else if (days == 1) {
            ftime = "\u6628\u5929";
        } else if (days == 2) {
            ftime = "\u524d\u5929";
        } else if (days > 2 && days <= 10) {
            ftime = days + "\u5929\u524d";
        } else if (days > 10) {
            ftime = DateTimeUtil.long2Str(ms);
        }
        return ftime;
    }

    public static int getWeeks(long startTime, long endTime) {
        int temp = 0;
        try {
            temp = (int)((endTime - startTime) / 86400000L / 7L);
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
        return temp;
    }

    public static String getDateWithWeek(long ms) {
        Calendar cal = DateTimeUtil.initCalenderWithMillis(ms);
        int a = cal.get(7);
        String[] weekARR = new String[]{"\uff08\u5468\u65e5\uff09", "\uff08\u5468\u4e00\uff09", "\uff08\u5468\u4e8c\uff09", "\uff08\u5468\u4e09\uff09", "\uff08\u5468\u56db\uff09", "\uff08\u5468\u4e94\uff09", "\uff08\u5468\u516d\uff09"};
        return DateTimeUtil.long2Str(ms, "MM\u6708dd\u65e5" + weekARR[a - 1]);
    }

    public static String getDateWithWeekAndTime(long ms) {
        Calendar cal = DateTimeUtil.initCalenderWithMillis(ms);
        int a = cal.get(7);
        return DateTimeUtil.long2Str(ms, "yyyy\u5e74MM\u6708dd\u65e5 " + WEEK_ARR[a - 1] + " HH:mm");
    }

    public static int getAge(long ms) {
        LocalDateTime born = DateTimeUtil.longToLocalDateTime(ms);
        if (born.isAfter(LocalDateTime.now())) {
            return -1;
        }
        long until = born.until(LocalDateTime.now(), ChronoUnit.YEARS);
        return (int)until;
    }

    public static String getLastYearCommonDay(String strDate, String format) {
        long ms = DateTimeUtil.strToLong(strDate, format);
        return DateTimeUtil.long2Str(DateTimeUtil.setToLastYearCommonDay(ms), format);
    }

    public static String getLastMonthCommonDay(String strDate, String format) {
        long ms = DateTimeUtil.strToLong(strDate, format);
        return DateTimeUtil.long2Str(DateTimeUtil.setToLastMonthCommonDay(ms), format);
    }

    public static Timestamp getBirthdayFormIdCard(String idCard) {
        Timestamp timestamp;
        if (ValidateUtil.isIdCard(idCard)) {
            timestamp = idCard.length() == 18 ? DateTimeUtil.strToStamp(idCard.substring(6, 14), YYYYMMDD) : DateTimeUtil.strToStamp(idCard.substring(6, 12), YYYYMMDD);
        } else {
            throw new RuntimeException("invalid IdChard number:" + idCard);
        }
        return timestamp;
    }

    public static long getLongBirthFormIdCard(String idCard) {
        return DateTimeUtil.getBirthdayFormIdCard(idCard).getTime();
    }

    public static boolean isCurrentYear(long ms) {
        LocalDate localDate = DateTimeUtil.longToLocalDate(ms);
        int yearTemp = localDate.getYear();
        LocalDate calNow = LocalDate.now();
        int yearNow = calNow.getYear();
        return yearNow == yearTemp;
    }

    public static String localDateTimeToStr(LocalDateTime localDateTime, String pattern) {
        DateTimeFormatter formatter = DateTimeUtil.createCacheFormatter(pattern);
        return localDateTime.format(formatter);
    }

    private static DateTimeFormatter createCacheFormatter(String pattern) {
        DateTimeFormatter oldFormatter;
        if (Objects.isNull(pattern) || pattern.length() == 0) {
            throw new IllegalArgumentException("Invalid pattern specification");
        }
        DateTimeFormatter formatter = (DateTimeFormatter)FORMATTER_CACHE.get(pattern);
        if (formatter == null && FORMATTER_CACHE.size() < 500 && (oldFormatter = FORMATTER_CACHE.putIfAbsent(pattern, formatter = DateTimeFormatter.ofPattern(pattern))) != null) {
            formatter = oldFormatter;
        }
        return formatter;
    }

    public static LocalDate longToLocalDate(long ms) {
        return Instant.ofEpochMilli(ms).atZone(ZoneOffset.ofHours(8)).toLocalDate();
    }

    public static LocalDateTime longToLocalDateTime(long ms) {
        return Instant.ofEpochMilli(ms).atZone(ZoneOffset.ofHours(8)).toLocalDateTime();
    }

    public static long localDateToLong(LocalDate localDate) {
        return localDate.atStartOfDay(ZoneId.systemDefault()).toEpochSecond() * 1000L;
    }

    public static LocalDate parseLocalDate(String time, String pattern) {
        DateTimeFormatter formatter = DateTimeUtil.createCacheFormatter(pattern);
        return LocalDate.parse(time, formatter);
    }

    public static LocalDateTime parseLocalDateTime(String time, String pattern) {
        DateTimeFormatter formatter = DateTimeUtil.createCacheFormatter(pattern);
        return LocalDateTime.parse(time, formatter);
    }

    public static long LocalDateTimeToLong(LocalDateTime dateTime) {
        return dateTime.toInstant(ZoneOffset.of("+8")).toEpochMilli();
    }

    public static String UTCToCST(String utc, String format) {
        ZonedDateTime zdt = ZonedDateTime.parse(utc);
        LocalDateTime localDateTime = zdt.toLocalDateTime();
        DateTimeFormatter formatter = DateTimeUtil.createCacheFormatter(format);
        return formatter.format(localDateTime.plusHours(8L));
    }

    public static String CTSToUTC(String time, String inputFormat, String outFormat) {
        OffsetDateTime utcTime = LocalDateTime.parse(time, DateTimeUtil.createCacheFormatter(inputFormat)).atZone(ZoneId.systemDefault()).toOffsetDateTime().withOffsetSameInstant(ZoneOffset.UTC);
        return utcTime.format(DateTimeUtil.createCacheFormatter(outFormat));
    }

    public static String CTSToUTC(long timestamp, String outFormat) {
        OffsetDateTime utcTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(timestamp), ZoneId.systemDefault()).atZone(ZoneId.systemDefault()).toOffsetDateTime().withOffsetSameInstant(ZoneOffset.UTC);
        return utcTime.format(DateTimeUtil.createCacheFormatter(outFormat));
    }

    private static Calendar initCalenderWithMillis(long ms) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(ms);
        return cal;
    }
}

