/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.weixin.sdk.kit;

import com.jfinal.weixin.sdk.api.ApiConfig;
import com.jfinal.weixin.sdk.api.ApiConfigKit;
import com.jfinal.weixin.sdk.encrypt.WXBizMsgCrypt;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class MsgEncryptKit {
    private static final String format = "<xml><ToUserName><![CDATA[toUser]]></ToUserName><Encrypt><![CDATA[%1$s]]></Encrypt></xml>";

    public static String encrypt(String msg, String timestamp, String nonce) {
        try {
            ApiConfig ac = ApiConfigKit.getApiConfig();
            WXBizMsgCrypt pc = new WXBizMsgCrypt(ac.getToken(), ac.getEncodingAesKey(), ac.getAppId());
            return pc.encryptMsg(msg, timestamp, nonce);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String decrypt(String encryptedMsg, String timestamp, String nonce, String msgSignature) {
        try {
            ApiConfig ac = ApiConfigKit.getApiConfig();
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            StringReader sr = new StringReader(encryptedMsg);
            InputSource is = new InputSource(sr);
            Document document = db.parse(is);
            Element root = document.getDocumentElement();
            NodeList nodelist1 = root.getElementsByTagName("Encrypt");
            String encrypt = nodelist1.item(0).getTextContent();
            String fromXML = String.format(format, encrypt);
            String encodingAesKey = ac.getEncodingAesKey();
            if (encodingAesKey == null) {
                throw new IllegalStateException("encodingAesKey can not be null, config encodingAesKey first.");
            }
            WXBizMsgCrypt pc = new WXBizMsgCrypt(ac.getToken(), encodingAesKey, ac.getAppId());
            return pc.decryptMsg(msgSignature, timestamp, nonce, fromXML);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

